#include <Adafruit_GFX.h>
#include "KS0108_GLCD.h"    // include KS0108 GLCD library

#ifdef USE_FONTS
  #include <Fonts/Picopixel.h>
  #include <Fonts/Tiny3x3a2pt7b.h>
  #include <Fonts/Org_01.h>
#endif

#include <hardware/pwm.h>
#include <ArduinoJson.h>

#include "includes.h"

// ---------------------------------------------

void setup()   {                
  Serial.begin(9600);
  
  pinMode( BGL_PIN, OUTPUT_12MA );
  digitalWrite( BGL_PIN, HIGH );

  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    gpio_set_slew_rate( 
      rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // initialize KS0108 GLCD module with active high CS pins
  if ( display.begin(KS0108_CS_ACTIVE_HIGH) == false ) {
    Serial.println( F("display initialization failed!") );    // lack of RAM space
    while(true);  // stay here forever!
  }
  // display splash screen
  display.display();
  delay(2000);

  testlineerase(20);
  
  PWM_Init();
  
  while (!Serial.available()) {    
    if ((millis()-T)>1000) {
      GLCD_animate(30,8),
      T = millis(); 
      break; // override while debug
    }     
    GLCD_getBgl();
    //demo(); 
  } 
  buf = Serial.readStringUntil('\n');
  

  display.clearDisplay();           // Clear the buffer
  display.setTextSize(1);           // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON);  // Draw white text
  display.setCursor(0, 0);          // Start at top-left corner
  display.cp437(true);              // Use full 256 char 'Code Page 437' font
  display.setTextWrap(true);        // Toggle text wrap (else clip right).
  display.display();
  
  ui_mode = UI_READ;
  memset(buf_input, 0, sizeof(buf_input));
  kp_last_press = millis();

  menu(0);
}
// ---------------------------------------------

void loop() {
  if (ui_mode == UI_READ) {
    KeyMap *obj = readKeyPad();
    
    if (obj != NULL) {
      uint8_t key = obj->key;

      switch(key) {
        case 2:
          --active_entry %= ArrLen(entries1);
          menu();
          break;
        case 8:
          ++active_entry %= ArrLen(entries1);
          menu();
          break;
        case 5:
        case 6:
          paths[menu_level++] = active_entry;
          break;
        case 4:
        case 10:
          menu_level = (menu_level > 0) ? menu_level-1 : 0;
          paths[menu_level] = active_entry = 0;
          break;
        default:
          break;
      }
      delay(30);
    }
  }
  else if (ui_mode == UI_WRITE) {
    if (checkInput()) {
      display.clearDisplay();
      display.setCursor(0,0);
      display.print("> ");
      display.print(buf_input);
      display.write(curSym);
      display.write('\n');
      display.display();
      delay(30);
    }
  }
  GLCD_getBgl();
}

// ---------------------------------------------

KeyMap *readKeyPad() {
  for (uint8_t row = 0; row < 4; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = matrix[row][col].pin;
      uint8_t key = matrix[row][col].key;  
      
      if (digitalRead(col_pin) == LOW) {
        if (millis()-kp_last_press) {
          while (digitalRead(col_pin) == LOW); 
          digitalWrite(rowPins[row], HIGH);
          kp_last_press = millis();
          
          return &(matrix[row][col]);
        }
      }
    }
    digitalWrite(rowPins[row], HIGH);
  }
  return nullptr;
}
/* ------------------------------------------------- */

void t9_reset() {
  for (uint8_t x = 0; x < 4; x++) 
    for (uint8_t y = 0; y < 3; y++) 
      matrix[x][y].index = 0;
}
// ---------------------------------------------------------------

void clearBuf() {
  memset(buf_input, 0, sizeof(buf_input));
  buf_index = 0;
  t9_reset();
}
// ---------------------------------------------------------------

bool checkInput() {
  uint8_t key, index;
  char c;
  
  KeyMap *obj = readKeyPad();
  
  if (obj != NULL) {
    key = obj->key;

    if (obj->index < 1) {
      if (buf_input[buf_index] != '\0')
        buf_index = (key != 10 && key != 12) ? buf_index + 1 : buf_index;
      t9_reset();
    } 
    else {
      if (key > 10)  
        buf_index++;
    }
    
    if (key == 10) {
      buf_input[buf_index] = '\0';
      buf_index = (buf_index > 0) ? buf_index - 1 : 0;
    }
      
    index = obj->index % strlen(obj->t9_page);
    
    if (strlen(obj->t9_page) > 0) {
      buf_input[buf_index] = obj->t9_page[index];
      obj->index++;
    }
    return true;
  }
  return false;
}

// ---------------------------------------------



// ---------------------------------------------
