

#include "includes.h"

// ---------------------------------------------

template< unsigned N >
struct MyObjTemplate{
  const char* Array[ N ];
};

MyObjTemplate< 3 > obj = {
  "one","two","three"
};

typedef

void setup()   {
  delay(1000);              
  Serial.begin(9600);

  pinMode( BGL_PIN, OUTPUT_12MA );
  //pinMode( BGL_PIN, OUTPUT );
  
  // initialize KS0108 GLCD module with active high CS pins
  if ( display.begin(KS0108_CS_ACTIVE_HIGH) == false ) {
    Serial.println( F("display initialization failed!") );    // lack of RAM space
    while(true)  // stay here forever!
      digitalWrite(BGL_PIN, !digitalRead(BGL_PIN)), 
      delay(500);
  }

  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    gpio_set_slew_rate( 
      rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
    

  //digitalWrite( BGL_PIN, HIGH );
  PWM_Init();
  
  // display splash screen
  display.display();
  delay(2000);
  testlineerase(20);

  display.clearDisplay();           // Clear the buffer
  display.setTextSize(1);           // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON);  // Draw white text
  display.setCursor(0, 0);          // Start at top-left corner
  display.cp437(true);              // Use full 256 char 'Code Page 437' font
  display.setTextWrap(true);        // Toggle text wrap (else clip right).

  /*
  display.drawBitmap( 
    (display.width() - SPLASH_W) / 2, 
    (display.height()- SPLASH_H) / 2,
    splash_scanning,
    SPLASH_W, SPLASH_H, 1
  );
  display.display();
  delay(2000);
  */
  
  while (!Serial.available()) {    
    if ((millis()-T)>1000) {
      GLCD_animate(30,8),
      T = millis(); 
      break; // override while debug
    }     
    GLCD_getBgl();
    //demo(); 
  } 
  buf = Serial.readStringUntil('\n');
  
  ui_mode = UI_READ;
  memset(buf_input, 0, sizeof(buf_input));
  kp_last_press = millis();

  menu(0);
}
// ---------------------------------------------

void loop() {
  while (1){
    unsigned int btn_map = rawKeyPad();
    int nav_btns[5] = {2,8,4,6,5};
    
    if (ui_mode == UI_READ) {
      for (const int& btn : nav_btns) {
        if (btn_map & (1 << btn) ) {
          Serial.println(btn);
          break;
        }
      }
    }
    GLCD_getBgl();
  }
  
  if (ui_mode == UI_READ) {
    KeyMap *obj = readKeyPad();
    
    if (obj != NULL) {
      uint8_t key = obj->key;

      switch(key) {
        case 2:
          --active_entry %= ArrLen(entries1);
          menu();
          break;
        case 8:
          ++active_entry %= ArrLen(entries1);
          menu();
          break;
        case 5:
        case 6:
          paths[menu_level++] = active_entry;
          break;
        case 4:
        case 10:
          menu_level = (menu_level > 0) ? menu_level-1 : 0;
          paths[menu_level] = active_entry = 0;
          break;
        default:
          break;
      }
      delay(30);
    }
  }
  else if (ui_mode == UI_WRITE) {
    if (checkInput()) {
      display.clearDisplay();
      display.setCursor(0,0);
      display.print("> ");
      display.print(buf_input);
      display.write(curSym);
      display.write('\n');
      display.display();
      delay(30);
    }
  }
  GLCD_getBgl();
}

// ---------------------------------------------

void setBit(unsigned int &target, uint16_t x, bool set) {  
  if (set)
    target |= (1 << x);
  else
    target &= ~(1 << x);
    
  target &= 0b0000111111111111; // cut 4 upper bits -> 12 bit
}
// ---------------------------------------------

unsigned int rawKeyPad() {
  unsigned int binary = 0b1000000000000000;
  
  for (uint8_t row = 0; row < 4; row++) {
    digitalWrite(rowPins[row], LOW);
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = matrix[row][col].pin;
      uint8_t key = matrix[row][col].key;
      
      if (digitalRead(col_pin) == LOW) {
        setBit(binary, key-1, 1);
      }
    }
    digitalWrite(rowPins[row], HIGH);
  }
  delay(KP_DEBOUNCE);
  return binary;
}
/* ------------------------------------------------- */

KeyMap *readKeyPad() {
  for (uint8_t row = 0; row < 4; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) { 
      uint8_t col_pin = matrix[row][col].pin;
      uint8_t key = matrix[row][col].key;  
      bool state = digitalRead(col_pin); 
      Serial.print(state); Serial.print(" ");
       
      if (state == LOW) {
        if ((millis()-kp_last_press) > KP_DEBOUNCE) {
          while (digitalRead(col_pin) == LOW); 
          digitalWrite(rowPins[row], HIGH);
          kp_last_press = millis();
          
          return &(matrix[row][col]);
        }
      }
    }
    Serial.println();
    digitalWrite(rowPins[row], HIGH);
  }
  Serial.println("----------------------------\n");
  return nullptr;
}
/* ------------------------------------------------- */

void t9_reset() {
  for (uint8_t x = 0; x < 4; x++) 
    for (uint8_t y = 0; y < 3; y++) 
      matrix[x][y].index = 0;
}
// ---------------------------------------------------------------

void clearBuf() {
  memset(buf_input, 0, sizeof(buf_input));
  buf_index = 0;
  t9_reset();
}
// ---------------------------------------------------------------

bool checkInput() {
  uint8_t key, index;
  char c;
  
  KeyMap *obj = readKeyPad();
  
  if (obj != NULL) {
    key = obj->key;

    if (obj->index < 1) {
      if (buf_input[buf_index] != '\0')
        buf_index = (key != 10 && key != 12) ? buf_index + 1 : buf_index;
      t9_reset();
    } 
    else {
      if (key > 10)  
        buf_index++;
    }
    
    if (key == 10) {
      buf_input[buf_index] = '\0';
      buf_index = (buf_index > 0) ? buf_index - 1 : 0;
    }
      
    index = obj->index % strlen(obj->t9_page);
    
    if (strlen(obj->t9_page) > 0) {
      buf_input[buf_index] = obj->t9_page[index];
      obj->index++;
    }
    return true;
  }
  return false;
}

// ---------------------------------------------



// ---------------------------------------------
