#include <stdint.h>
#include <stdio.h>

//#define DEBUG(...) do { Serial.println("DEBUG: " __VA_ARGS__) } while(0)
#define ArrLen(x)  (sizeof(x)/sizeof(x[0]))
#define prnt        Serial.print
#define prntln      Serial.println

uint8_t rowPins[4] = {2, 5, 7, 8};
uint8_t colPins[5] = {1, 3, 6, 9, 10};

uint8_t matrix[4][3] = {
  {1,4,3},
  {1,4,6},
  {1,4,6},
  {10,4,9}
};

void setup() {
  Serial.begin(9600);
  while(!Serial);
  
  for (int i=0; i<ArrLen(colPins); i++) {
    prnt(F("col pin #")), prnt(i), prnt(" = "), prntln(colPins[i]); 
    pinMode(colPins[i], INPUT);
    //digitalWrite(colPins[i], LOW);
  }
  prntln();
  
  for (int i=0; i<ArrLen(rowPins); i++) {
    prnt(F("row pin #")), prnt(i), prnt(" = "), prntln(rowPins[i]); 
    pinMode(rowPins[i], OUTPUT);
    digitalWrite(rowPins[i], LOW);
  }
  prntln(F("------------------------------------"));
}

void loop() {
  for (int row=0; row<ArrLen(matrix); row++) {
    int rowPin = rowPins[row];
    digitalWrite(rowPin, HIGH); delay(10);

    prnt("row "),prnt(row),prnt(" -> pin "),prnt(rowPin),prntln(":");

    for (int col=0; col<ArrLen(matrix[row]); col++) {
      int colPin = matrix[row][col];
      bool state = digitalRead(colPin);
      prnt("    col "), prnt(col), prnt("-> pin "), prnt(colPin), prnt(" ("), prnt(state), prntln(")");      
    }

    digitalWrite(rowPin, LOW); delay(10);
          
    prntln(F("------------------"));
  }
  prntln(F("__________________________________\n"));
  
  delay(5000);
  //for (;;);
}
