/*
*
KEYPAD     ARDUINO
 pin 1  ->  pin 2 
 pin 2  ->  pin 8
 pin 3  ->  pin 3
 pin 4  ->  pin 4
 pin 5  ->  pin 9
 pin 6  ->  pin 5
 pin 7  ->  pin 10
 pin 8  ->  pin 11
 pin 9  ->  pin 6
 pin 10 ->  pin 7
*
*
uint8_t rowPins[4] = {2, 5, 7, 8};
uint8_t colPins[5] = {1, 3, 6, 9, 10};

uint8_t matrix[4][3] = {
  {1,4,3},
  {1,4,6},
  {1,4,6},
  {10,4,9}
};

*/

#include <stdint.h>
#include <stdio.h>

#define ArrLen(x)  (sizeof(x)/sizeof(x[0]))
#define prnt        Serial.print
#define prntln      Serial.println

const uint8_t row_N = 4; //4 rows
const uint8_t col_N = 6; //6 columns

uint8_t rowPins[row_N] = {8, 9, 10, 11};
uint8_t colPins[col_N] = {2, 3, 4, 5, 6, 7};

// indeces for colPins[n]
uint8_t matrix[4][3] = {
  {0, 2, 1 },
  {0, 2, 3 },
  {0, 2, 3 },
  {2, 4, 5}
};

/*
uint8_t matrix[4][3] = {
  {2, 4, 3 },
  {2, 4, 5 },
  {2, 4, 5 },
  {4, 6, 7}
};
*/

void setup() {
  Serial.begin(9600);
  while(!Serial);

  int i;
  for (i = 0; i < row_N; i++){
    pinMode(rowPins[i], OUTPUT);
    digitalWrite(rowPins[i], HIGH);
  }
  for (i = 0; i < col_N; i++){
    pinMode(colPins[i], INPUT_PULLUP);
  }
  Serial.println("READY.");
}

void loop() {
  for (uint8_t row = 0; row < row_N; row++) {
    digitalWrite(rowPins[row], LOW);
    //prnt(rowPins[row]), prntln(":");

    for (uint8_t col = 0; col < 3; col++){
      uint8_t index = matrix[row][col];
      uint8_t col_pin = colPins[index];
      //prnt("    "),prnt(col_pin), prnt(": "), prntln(digitalRead(col_pin));
      
      if (digitalRead(col_pin) == LOW) 
        prnt("pressed col "),prnt(col),prnt(" in row "),prntln(row),
        delay(100);
    }     
    digitalWrite(rowPins[row], HIGH);
    //prntln();
  }
  //prntln(F("------------------------------------\n"));
  //delay(5000);
}

/*
void setup() {
  Serial.begin(9600);
  while(!Serial);

  for(i = 0; i < keypad->rown; i++){
    pinMode(keypad->rowPins[i], OUTPUT);
    digitalWrite(keypad->rowPins[i], HIGH);
  }
  for(i = 0; i < keypad->coln; i++){
    pinMode(keypad->colPins[i], INPUT_PULLUP);
  }
  
  for (int i=0; i<ArrLen(colPins); i++) {
    prnt(F("col pin #")), prnt(i), prnt(" = "), prntln(colPins[i]); 
    pinMode(colPins[i], INPUT);
    //digitalWrite(colPins[i], LOW);
  }
  prntln();
  
  for (int i=0; i<ArrLen(rowPins); i++) {
    prnt(F("row pin #")), prnt(i), prnt(" = "), prntln(rowPins[i]); 
    pinMode(rowPins[i], OUTPUT);
    digitalWrite(rowPins[i], LOW);
  }
  prntln(F("------------------------------------"));
}

void loop() {
  for (int row=0; row<ArrLen(matrix); row++) {
    int rowPin = rowPins[row];
    digitalWrite(rowPin, HIGH); delay(10);

    prnt("row "),prnt(row),prnt(" -> pin "),prnt(rowPin),prntln(":");

    for (int col=0; col<ArrLen(matrix[row]); col++) {
      int colPin = matrix[row][col];
      bool state = digitalRead(colPin);
      prnt("    col "), prnt(col), prnt("-> pin "), prnt(colPin), prnt(" ("), prnt(state), prntln(")");      
    }

    digitalWrite(rowPin, LOW); delay(10);
          
    prntln(F("------------------"));
  }
  prntln(F("__________________________________\n"));
  
  delay(5000);
  //for (;;);
}
*/