/*


uint8_t rowPins[4] = {2, 5, 7, 8};
uint8_t colPins[5] = {1, 3, 6, 9, 10};

uint8_t matrix[4][3] = {
  {1,4,3},
  {1,4,6},
  {1,4,6},
  {10,4,9}
};

KEYPAD     ARDUINO
 pin 1  ->  pin 12
 pin 2  ->  pin 11
 pin 3  ->  pin 10
 pin 4  ->  pin 9
 pin 5  ->  pin 8
 pin 6  ->  pin 7
 pin 7  ->  pin 6
 pin 8  ->  pin 5
 pin 9  ->  pin 4
 pin 10 ->  pin 3


*/

#include <stdint.h>
#include <stdio.h>

#define ArrLen(x)  (sizeof(x)/sizeof(x[0]))
#define prnt        Serial.print
#define prntln      Serial.println

const uint8_t row_N = 4; //4 rows
const uint8_t col_N = 6; //6 columns

uint8_t rowPins[row_N] = {11, 8, 6, 5};
uint8_t colPins[col_N] = {12, 10, 9, 7, 4, 3};

// indeces for colPins[n]
uint8_t matrix[4][3] = {
  { colPins[0], colPins[2], colPins[1] },
  { colPins[0], colPins[2], colPins[3] },
  { colPins[0], colPins[2], colPins[3] },
  { colPins[2], colPins[5], colPins[4] } 
};

uint8_t colData[3] = {
  0b0000,
  0b0000,
  0b0000
};

void setup() {
  Serial.begin(9600);
  while(!Serial);

  int i;
  for (i = 0; i < row_N; i++){
    pinMode(rowPins[i], OUTPUT);
    digitalWrite(rowPins[i], LOW);
  }
  for (i = 0; i < col_N; i++){
    pinMode(colPins[i], INPUT);
    digitalWrite(colPins[i], LOW);
  }
  Serial.println("READY.");
}

void loop() {
  for (uint8_t row = 0; row < row_N; row++) {
    digitalWrite(rowPins[row], HIGH);
    //prnt(rowPins[row]), prntln(":");

    for (uint8_t col = 0; col < 3; col++){
      /*
      uint8_t data = 0b0000;
      uint8_t index = matrix[row][col];
      uint8_t col_pin = colPins[index];

      */
      uint8_t col_pin = matrix[row][col];
      //prnt("    "),prnt(col_pin), prnt(": "), prntln(digitalRead(col_pin));
      
      if (digitalRead(col_pin) == HIGH) 
        prnt("pressed col "),prnt(col),prnt(" in row "),prntln(row);
        //delay(100);
    }     
    digitalWrite(rowPins[row], LOW);
    //prntln();
  }
  //prntln(F("------------------------------------\n"));
  //delay(5000);
}

/*
void setSetting(int x, bool set) {
  if (set)
    settings |= (1 << x);
  else
    settings &= ~(1 << x);

  settings &= 0b1111;
}

void Send(byte x=0x00, byte addr=0x00, byte data=0x20) { 
  x &= 0b111111;
    
  if ( x & (1 << 0) ) serial(ON);
  if ( x & (1 << 1) ) spi_send( 0x20 | (addr & 0xF) );
  if ( x & (1 << 2) ) spi_send( data ), delayUs(2);
  if ( x & (1 << 3) ) serial(OFF);
  if ( x & (1 << 4) ) Show();   
}
*/
