/*
KEYPAD     ARDUINO
 pin 1  ->  pin 12
 pin 2  ->  pin 11
 pin 3  ->  pin 10
 pin 4  ->  pin 9
 pin 5  ->  pin 8
 pin 6  ->  pin 7
 pin 7  ->  pin 6
 pin 8  ->  pin 5
 pin 9  ->  pin 4
 pin 10 ->  pin 3
*/

#include <stdint.h>
#include <stdio.h>

#define ArrLen(x)  (sizeof(x)/sizeof(x[0]))
#define prnt        Serial.print
#define prntln      Serial.println

const uint8_t row_N = 4;
const uint8_t col_N = 6;


uint8_t rowPins[row_N] = {
  7,    // KP 2
  14,   // KP 5
  10,   // KP 7
  11    // KP 8
};

uint8_t colPins[col_N] = {
  6,    // KP 1
  8,    // KP 3
  9,    // KP 4
  15,   // KP 6
  12,   // KP 9
  13    // KP 10
};

uint8_t matrix[4][3] = {
  { colPins[0], colPins[2], colPins[1] },
  { colPins[0], colPins[2], colPins[3] },
  { colPins[0], colPins[2], colPins[3] },
  { colPins[2], colPins[5], colPins[4] } 
};

char keymap[4][3] = {
  {'7','8','9'},
  {'4','5','6'},
  {'1','2','3'},
  {'0','*','#'}
};

void setup() {
  Serial.begin(9600);
  while(!Serial);

  int i;
  for (i = 0; i < row_N; i++){
    pinMode(rowPins[i], OUTPUT);
    digitalWrite(rowPins[i], HIGH);
  }
  for (i = 0; i < col_N; i++){
    pinMode(colPins[i], INPUT_PULLUP);
    //digitalWrite(colPins[i], LOW);
  }
  Serial.println(F("READY."));
}

void loop() {
  for (uint8_t row = 0; row < row_N; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = matrix[row][col];

      if (digitalRead(col_pin) == LOW) {
        prnt(F("pressing ")), prntln(keymap[row][col]);
        while (digitalRead(col_pin) == LOW); delay(20);
      }
    }
    digitalWrite(rowPins[row], HIGH);
    delay(10);
  }
}

/*

uint8_t colData[3] = {
  0b0000,
  0b0000,
  0b0000
};

void setup() {
  Serial.begin(9600);
  while(!Serial);

  int i;
  for (i = 0; i < row_N; i++){
    pinMode(rowPins[i], OUTPUT);
    digitalWrite(rowPins[i], LOW);
  }
  for (i = 0; i < col_N; i++){
    pinMode(colPins[i], INPUT);
    digitalWrite(colPins[i], LOW);
  }
  Serial.println("READY.");
}

void loop() {
  for (uint8_t row = 0; row < row_N; row++) {
    digitalWrite(rowPins[row], HIGH);
    //prnt(rowPins[row]), prntln(":");

    for (uint8_t col = 0; col < 3; col++){
      uint8_t col_pin = matrix[row][col];
      //prnt("    "),prnt(col_pin), prnt(": "), prntln(digitalRead(col_pin));
      
      if (digitalRead(col_pin) == HIGH) 
        prnt("pressed col "),prnt(col),prnt(" in row "),prntln(row);
        //delay(100);
    }     
    digitalWrite(rowPins[row], LOW);
    //prntln();
  }
  //prntln(F("------------------------------------\n"));
  //delay(5000);
}
*/
/*
void setSetting(int x, bool set) {
  if (set)
    settings |= (1 << x);
  else
    settings &= ~(1 << x);

  settings &= 0b1111;
}

void Send(byte x=0x00, byte addr=0x00, byte data=0x20) { 
  x &= 0b111111;
    
  if ( x & (1 << 0) ) serial(ON);
  if ( x & (1 << 1) ) spi_send( 0x20 | (addr & 0xF) );
  if ( x & (1 << 2) ) spi_send( data ), delayUs(2);
  if ( x & (1 << 3) ) serial(OFF);
  if ( x & (1 << 4) ) Show();   
}
*/
