//#include <Arduino.h>
//#include <stdio.h>
//#include <pico/stdlib.h>
#include <Adafruit_TinyUSB.h>
#include <Adafruit_GFX.h>   // include adafruit GFX library
#include "KS0108_GLCD.h"    // include KS0108 GLCD library


KS0108_GLCD display = KS0108_GLCD(
  22, // -> LCD 4  ( RS )
  20, // -> LCD 6  ( E )
  21, // -> LCD 7  ( D0 )
  19, // -> LCD 8  ( D1 )
  18, // -> LCD 8  ( D2 )
  17, // -> LCD 10 ( D3 )
  16, // -> LCD 11 ( D4 )
  27, // -> LCD 12 ( D5 )
  26, // -> LCD 13 ( D6 )
  5,  // -> LCD 14 ( D7 )
  4,  // -> LCD 15 ( CS1 )
  3,  // -> LCD 16 ( CS2 )
  2   // -> LCD 17 ( RES )
);


void setup() {
  delay(1000);
  Serial.begin(9600);
  pinMode(28, OUTPUT_12MA);
  digitalWrite(28, HIGH);
  // initialize KS0108 GLCD module with active high CS pins
  if ( display.begin(KS0108_CS_ACTIVE_HIGH) == false ) {
    Serial.println( F("display initialization failed!") );    // lack of RAM space
    while(true);  // stay here forever!
  }

  Serial.println( F("display initialized!") );

  display.display();
  delay(2000); // Pause for 2 seconds
  
  display.clearDisplay();           // Clear the buffer
  display.setTextSize(1);           // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON);  // Draw white text
  display.setCursor(0, 0);          // Start at top-left corner
  display.cp437(true);              // Use full 256 char 'Code Page 437' font
  display.setTextWrap(true);        // Set whether text should wrap around (else clip right).

  //display.setFont(&Picopixel);
  display.clearDisplay(); 
  display.setCursor(0, 0); 
  for (int16_t x = 0; x<255; x++) 
    display.write(x);
  display.display();
  delay(5000);
  
}

void loop() {
  if (Serial.available()) {
    display.clearDisplay(); display.setCursor(0, 0); display.display();   
    while (Serial.available()) 
      display.write(Serial.read()),
      display.display(),
      delay(10);
      
    display.write('\n');
    display.display();
    delay(1000);
  }
}
