//#include <Arduino.h>
//#include <stdio.h>
//#include <pico/stdlib.h>
#include <Adafruit_TinyUSB.h>
#include <Adafruit_GFX.h>   // include adafruit GFX library
#include "KS0108_GLCD.h"    // include KS0108 GLCD library

#define DEBOUNCE 30

constexpr uint8_t row_N = 4;
constexpr uint8_t col_N = 6;

KS0108_GLCD display = KS0108_GLCD(
  22, // -> LCD 4  ( RS )
  20, // -> LCD 6  ( E )
  21, // -> LCD 7  ( D0 )
  19, // -> LCD 8  ( D1 )
  18, // -> LCD 8  ( D2 )
  17, // -> LCD 10 ( D3 )
  16, // -> LCD 11 ( D4 )
  27, // -> LCD 12 ( D5 )
  26, // -> LCD 13 ( D6 )
  5,  // -> LCD 14 ( D7 )
  4,  // -> LCD 15 ( CS1 )
  3,  // -> LCD 16 ( CS2 )
  2   // -> LCD 17 ( RES )
);

uint8_t rowPins[row_N] = {
  14, // -> KP 2   ( R1 )
  11, // -> KP 5   ( R2 )
  9,  // -> KP 7   ( R3 )
  8   // -> KP 8   ( R4 )
};

uint8_t colPins[col_N] = {
  15, // -> KP 1   ( C1 )
  13, // -> KP 3   ( C2 )
  12, // -> KP 4   ( C3 )
  10, // -> KP 6   ( C4 )
  7,  // -> KP 9   ( C5 )
  6   // -> KP 10  ( C6 )
};
struct Map {
  uint8_t     pin;
  uint8_t     key;
  int16_t     index;
  const char* t9_page;
};
Map matrix[4][3] = {
  {
    { colPins[0], 1, 0, ".,!?:;_-+=*/'\"%$&#@(){}[]"},
    { colPins[2], 2, 0, "abcABC"},
    { colPins[1], 3, 0, "defDEF"},
  },
  {
    { colPins[0], 4, 0, "ghiGHI"},
    { colPins[2], 5, 0, "jklJKL"},
    { colPins[3], 6, 0, "mnoMNO"}
  },
  {
    { colPins[0], 7, 0, "pqrsPQRS"},
    { colPins[2], 8, 0, "tuvTUV"},
    { colPins[3], 9, 0, "wxyzWXYZ"}
  },
  {
    { colPins[2], 11, 0, ""},
    { colPins[5], 10, 0, "0123456789"},
    { colPins[4], 12, 0, " "}
  },
};


char    buf_input[256];
uint8_t buf_index;
unsigned long  kp_last_press;

void setup() {
  delay(1000);
  Serial.begin(9600);
  pinMode(28, OUTPUT_12MA);
  digitalWrite(28, HIGH);
  // initialize KS0108 GLCD module with active high CS pins
  if ( display.begin(KS0108_CS_ACTIVE_HIGH) == false ) {
    Serial.println( F("display initialization failed!") );    // lack of RAM space
    while(true);  // stay here forever!
  }

  display.display();
  delay(2000); // Pause for 2 seconds
  
  display.clearDisplay();           // Clear the buffer
  display.setTextSize(1);           // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON);  // Draw white text
  display.setCursor(0, 0);          // Start at top-left corner
  display.cp437(true);              // Use full 256 char 'Code Page 437' font
  display.setTextWrap(true);        // Set whether text should wrap around (else clip right).

  
  // - - - - - - - - - - - - - - - - - 
  
  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    gpio_set_slew_rate( 
      rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 
  //display.setFont(&Picopixel);
  display.clearDisplay(); 
  display.setCursor(0, 0); 
  for (int16_t x = 0; x<255; x++) 
    display.write(x);
  display.display();
  delay(5000);


  memset(buf_input, 0, sizeof(buf_input));
  buf_index = 0;

  kp_last_press = millis();
}
// ---------------------------------------------------------------

Map *readKeyPad() {
  uint8_t key = 0;
  
  for (uint8_t row = 0; row < 4; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = matrix[row][col].pin;
        
      if (digitalRead(col_pin) == LOW) {
        if ((millis()-kp_last_press) > DEBOUNCE) {
          digitalWrite(LED_BUILTIN, HIGH);
          key = matrix[row][col].key;
          
          while (digitalRead(col_pin) == LOW); 
          
          digitalWrite(LED_BUILTIN,  LOW);
          digitalWrite(rowPins[row], HIGH);
          kp_last_press = millis();
          
          return &(matrix[row][col]);
        }
      }
    }
    digitalWrite(rowPins[row], HIGH);
  }
  return nullptr;
}
// ---------------------------------------------------------------

void t9_reset() {
  for (uint8_t x = 0; x < 4; x++) 
    for (uint8_t y = 0; y < 3; y++) 
      matrix[x][y].index = 0;
}
// ---------------------------------------------------------------

char kp_last_char = '\0';
int16_t kp_last_index = 0;

void loop() {
  uint8_t key, index;
  char c;
  
  Map *obj = readKeyPad();

  if (obj != NULL) {
    key = obj->key;

    if (obj->index < 1) {
      if (buf_input[buf_index] != '\0' && key < 11) 
        buf_index++;
      t9_reset();
    } else {
      if (key == 12) 
        buf_index++;
    }
    
    if (key == 11) {
      buf_input[buf_index] = '\0';
      if (buf_index > 0) buf_index--;
    }

    index = obj->index % strlen(obj->t9_page);
    
    if (strlen(obj->t9_page) > 0) {
      c = obj->t9_page[index];        
      if (!(key == 12 && obj->index == 0)) 
        buf_input[buf_index] = c;
        
      obj->index++;
    }
    // emulate terminal output
    display.clearDisplay();
    display.print("> "), display.println(buf_input);
    display.display();
    delay(DEBOUNCE);
  }

}
