/*
KEYPAD     PICO
 pin 1  ->  pin 6
 pin 2  ->  pin 7
 pin 3  ->  pin 8
 pin 4  ->  pin 9
 pin 5  ->  pin 14
 pin 6  ->  pin 15
 pin 7  ->  pin 10
 pin 8  ->  pin 11
 pin 9  ->  pin 12
 pin 10 ->  pin 13


KS0108          PICO
 pin 4  (RS)  ->  pin 22
 pin 5  (RW)  ->  pin 27(N/A)
 pin 6  (E)   ->  pin 20
 pin 7  (DB0) ->  pin 21
 pin 8  (DB1) ->  pin 19
 pin 9  (DB2) ->  pin 18
 pin 10 (DB3) ->  pin 17
 pin 11 (DB4) ->  pin 16
 pin 12 (DB5) ->  pin 0
 pin 13 (DB6) ->  pin 1
 pin 14 (DB7) ->  pin 2
 pin 15 (CS1) ->  pin 3 
 pin 16 (CS2) ->  pin 4
 pin 17 (RST) ->  pin 5
 
*/

//#define KS0108_NO_SPLASH


#include <stdio.h>
#include <pico/stdlib.h>
#include <Arduino.h>
#include <LittleFS.h>
//#include <SingleFileDrive.h>


#if defined(USE_TINYUSB)
  #include <Adafruit_TinyUSB.h>
#elif defined(CFG_TUSB_MCU)
  #error Incompatible USB stack. Select Adafruit TinyUSB in Tools menu. 
#endif
  
#include <TinyUSB_Devices.h>
#include <Adafruit_GFX.h>   // include adafruit GFX library
#include "KS0108_GLCD.h"    // include KS0108 GLCD library
#include "includes.h"

/* ------------------------------------------------- */

bool stdin_mode = false;

File file;

void setup() {
  Serial.begin(115200);
  LittleFS.begin();
  
  pinMode(LED_BUILTIN, OUTPUT);
  digitalWrite(LED_BUILTIN, LOW);
  
  pinMode(BGL_PIN, OUTPUT);
  digitalWrite(BGL_PIN, LOW);
  
  for (int i = 0; i < row_N; i++)
    pinMode(rowPins[i], OUTPUT),
    digitalWrite(rowPins[i], HIGH);
  
  for (int i = 0; i < col_N; i++)
    pinMode(colPins[i], INPUT_PULLUP);

  TinyUSBDevice.setManufacturerDescriptor(MANUFACTURER_NAME);
  TinyUSBDevice.setProductDescriptor(DEVICE_NAME);
  TinyUSBDevice.setID(DEVICE_VID, DEVICE_PID);
  
  TinyUSBDevices.begin(2);
  
  while(!USBDevice.mounted()) yield();
  
  Keyboard.releaseAll();
  kp_last_press = millis();

  delay(1000);
}
/* ------------------------------------------------- */



void loop() {
  bool key_held = false;
  
  for (uint8_t row = 0; row < row_N; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = matrix[row][col].pin;
      
      if (digitalRead(col_pin) == LOW) {
        if ((millis()-kp_last_press) > KP_DEBOUNCE) {
          digitalWrite(LED_BUILTIN, HIGH);
          kp_last_press = millis();
          
          while (digitalRead(col_pin) == LOW) {
            if ((millis()-kp_last_press) > KP_HOLD_TIME) {
              digitalWrite(LED_BUILTIN, !digitalRead(LED_BUILTIN)), delay(30);
              key_held = true;
            }
          }
          
          if (key_held)
            keyHeld(&(matrix[row][col]));
          else
            t9_getChar(&(matrix[row][col]));

          digitalWrite(LED_BUILTIN, LOW);     
        }
      }
    }
    digitalWrite(rowPins[row], HIGH);
  }
}
/* ------------------------------------------------- */

void setup1()   {
  display.setTextSize(1);  

  // initialize KS0108 GLCD module with active high CS pins
  if ( display.begin(KS0108_CS_ACTIVE_HIGH) == false ) {
    Serial.println( F("display initialization failed!") );    // lack of RAM space
    while(true);  // stay here forever!
  }

  display.display();
  delay(2000); // Pause for 2 seconds
  
  display.clearDisplay();           // Clear the buffer
  display.setTextSize(1);           // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON);  // Draw white text
  display.setCursor(0, 0);          // Start at top-left corner
  display.cp437(true);              // Use full 256 char 'Code Page 437' font

  /*
  char buf[8][22] = {"","","","","","","",""};
  memset(buf,'x',sizeof(buf));
  buf[7][21] = '\0';
  char* ptr = &(buf[0])[0];
  uint8_t x = 0;

  //do { *ptr++ = x++; } while(ptr != NULL);
  for (uint8_t x = 0; x<168; x++) 
    if (ptr && *ptr) 
      *ptr++ = random(32, 128);

  buf[7][21] = '\0';
  ptr = &(buf[0])[0];
  
  Serial.print("buf: "), Serial.println(ptr);
  */
  /*
  for (int16_t x = 0; x<512; x++) {
    if (x > 0 && ((x % 168) == 0)) 
      break;
      
    display.write(x);
    display.display();
    delay(10);
  }
  //display.println(F("LO-PI PHONE v1.0"));
  display.display();
  delay(2000);
  */
  display.clearDisplay();

  memset(fbuf,'\0',sizeof(fbuf));

  file = LittleFS.open("/stdin.txt", "w");
  if (file)
    file.print("\n"),
    file.close();  
}
/* ------------------------------------------------- */

char c = fbuf[kp_cursor];

void readFile(File *f) {
  if (f) {
    display.clearDisplay();
    display.setCursor(0, 0);
    
    while (f->available()) {
      int x = f->read();
      display.write(x);
      Serial.print((char)x);
      //char ch = f->read(); Serial.print(ch);
    }
    display.display();
    Serial.println();
    f->close();    
  }
}

void writeFile(File *f, String line) {
  if (f) {
    f->printf("%s\n",line.c_str()),
    f->close();
  }
}

void loop1() {

  /*
  while (Serial.available()) 
    display.write(Serial.read());
  display.display();
  */
  
  while (Serial.available()==0) {
    if (fbuf[kp_cursor] != c) {
      c = fbuf[kp_cursor];
      if (c == '\r')
        fbuf[kp_cursor] = '\0',
        sendCmd(fbuf);
      else
        drawCmd(); 
    }
  }
  
  do {
    String line = Serial.readStringUntil('\n');
    
    if (line == "STDIN") {
      stdin_mode = true;
      file = LittleFS.open("/stdin.txt", "w");
      if (file)
        file.print(""),
        file.close();
    }
    else if (line == "EOF") {
      stdin_mode = false;
      file = LittleFS.open("/stdin.txt", "r");
      /*
      if (file) {
        while (file.available()) {
          char ch = file.read(); 
          Serial.print(ch);
        }
        Serial.println();
        file.close();    
      }
      */
      readFile(&file);

      /*
      stdin_mode = false;
      file = LittleFS.open("/stdin.txt", "r");
      if (file) {
        int count = 0;
        display.clearDisplay();
        display.setCursor(0, 0);
        
        while (file.available()) {
          if (count > 0 && ((count++ % 168) == 0)) {
            display.display();
            //while (fbuf[kp_cursor] != '\r');
            delay(2000);
            display.clearDisplay();
            display.setCursor(0, 0);
          }
            
          display.write(file.read());
        }
        display.display();
        file.close();
      }
      */
    }
    else if (stdin_mode) {
      file = LittleFS.open("/stdin.txt", "a");
      /*
      if (file) {
        file.printf("%s\n",line.c_str());
        file.close();
      }
      */
      writeFile(&file, line);
    }
  } while (Serial.available()); 
}

/*

Hello There World!

*/
