/*
KEYPAD     PICO
 pin 1  ->  pin 6
 pin 2  ->  pin 7
 pin 3  ->  pin 8
 pin 4  ->  pin 9
 pin 5  ->  pin 14
 pin 6  ->  pin 15
 pin 7  ->  pin 10
 pin 8  ->  pin 11
 pin 9  ->  pin 12
 pin 10 ->  pin 13


KS0108          PICO
 pin 4  (RS)  ->  pin 22
 pin 5  (RW)  ->  pin 27(N/A)
 pin 6  (E)   ->  pin 20
 pin 7  (DB0) ->  pin 21
 pin 8  (DB1) ->  pin 19
 pin 9  (DB2) ->  pin 18
 pin 10 (DB3) ->  pin 17
 pin 11 (DB4) ->  pin 16
 pin 12 (DB5) ->  pin 0
 pin 13 (DB6) ->  pin 1
 pin 14 (DB7) ->  pin 2
 pin 15 (CS1) ->  pin 3 
 pin 16 (CS2) ->  pin 4
 pin 17 (RST) ->  pin 5
 
*/

#if defined(USE_TINYUSB)
  #include <Adafruit_TinyUSB.h>
#elif defined(CFG_TUSB_MCU)
  #error Incompatible USB stack. Select Adafruit TinyUSB in Tools menu. 
#endif
  
#include <TinyUSB_Devices.h>

#include <Arduino.h>
#include <LittleFS.h>
#include <stdio.h>
#include <pico/stdlib.h>

#include <Adafruit_GFX.h>   // include adafruit GFX library
#include "KS0108_GLCD.h"    // include KS0108 GLCD library
#include "includes.h"

//#include <SingleFileDrive.h>

//#define KS0108_NO_SPLASH

/* __________________________________________________*/

File file;
//char c = fbuf[kp_cursor];
int  pg = 0;
int  indexes[16];
bool stdin_mode = false;
bool GLCD_ON;

/* ------------------------------------------------- */

void setup() {
  Serial.begin(9600);

  TinyUSBDevice.setManufacturerDescriptor(MANUFACTURER_NAME);
  TinyUSBDevice.setProductDescriptor(DEVICE_NAME);
  TinyUSBDevice.setID(DEVICE_VID, DEVICE_PID);
  
  TinyUSBDevices.begin(1);
  
  while(!USBDevice.mounted()) yield();

  pinMode(LED_BUILTIN, OUTPUT);
  digitalWrite(LED_BUILTIN, LOW);
  
  pinMode(BGL_PIN, OUTPUT);
  digitalWrite(BGL_PIN, LOW);
  
  for (int i = 0; i < row_N; i++)
    pinMode(rowPins[i], OUTPUT),
    digitalWrite(rowPins[i], HIGH);
  
  for (int i = 0; i < col_N; i++)
    pinMode(colPins[i], INPUT_PULLUP);
  
  Keyboard.releaseAll();

  display.setTextSize(1);  

  if ( display.begin(KS0108_CS_ACTIVE_HIGH) == false ) {
    Serial.println( F("display initialization failed!") );    // lack of RAM space
    while(true);  // stay here forever!
  }

  display.display(); delay(2000);   // Pause for 2 seconds
  display.clearDisplay();           // Clear the buffer
  display.setTextSize(1);           // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON);  // Draw white text
  display.setCursor(0, 0);          // Start at top-left corner
  display.cp437(true);              // Use full 256 char 'Code Page 437' font

  for (int16_t x = 0; x<512; x++) {
    if (x > 0 && ((x % 168) == 0)) 
      break;
      
    display.write(x); display.display(); delay(10);
  }
  //display.println(F("LO-PI PHONE v1.0"));
  display.display();
  delay(2000);
  
  display.clearDisplay();
  memset(fbuf,'\0',sizeof(fbuf));
  
  file = LittleFS.open("/stdin.txt", "w");
  if (file)
    file.print("\n"),
    file.close();  
  
  kp_last_press = millis();



  delay(1000);
}
/* ------------------------------------------------- */

int readFile(File *f, int start_pos = 0) {
  int
  lns = 0,
  i = 0,
  p = 0;

  display.clearDisplay();
  display.setCursor(0, 0);
        
  if (f) {
    if (start_pos < f->size())
      f->seek(start_pos);
    
    while (f->available()) {
      int x = f->read();

      if (i == 22) x = 10;
      if (x == 10) i = 0, lns++;
      if (p == PIXELS || lns > 7) break;

      display.write(x);
      display.display();
      Serial.print((char)x);
    }
    Serial.println();
    delay(1000);
    display.display();
    fbuf[PIXELS] = '\0';
  }
  return f->position();
}
/* ------------------------------------------------- */

void writeFile(File *f, String line) {
  if (f) {
    f->printf("%s\n",line.c_str()),
    f->close();
  }
}
/* ------------------------------------------------- */

void readSerial() {
  int     pos;
  String line = Serial.readStringUntil('\n');
  
  if (line == "STDIN") { Serial.println("STDIN!");
    stdin_mode = true;
    file = LittleFS.open("/stdin.txt", "w");
    if (file)
      file.print(""),
      file.close();
  }
  else if (line == "EOF") { Serial.println("EOF!");
    stdin_mode = false;
    file = LittleFS.open("/stdin.txt", "r");
    if (file) { Serial.println("file found!");
      display.clearDisplay();
      display.setCursor(0, 0);
      do {
        int x = file.read();
        Serial.print((char)x);
        display.write(x); 
        display.display();
      } while (file.available());
      Serial.println();
      file.close();
    }
  /*
  else if (line == "EOF") {
    stdin_mode = false;
    memset(indexes, 0, sizeof(indexes)); pg = 0;
    
    file = LittleFS.open("/stdin.txt", "r");
    pos = readFile(&file);
    
    if (pos < file.size())
      indexes[++pg] = pos;
      //pos = readFile(&file, pos);
    file.close();

    Serial.println("\n---------------------------\n");
    
    for (int k=pg; k-->0; ) 
      Serial.print("indexes["),
      Serial.print(k),Serial.print("] = "),
      Serial.println(indexes[k]);
  */
  }
  else if (stdin_mode) {
    file = LittleFS.open("/stdin.txt", "a");
    writeFile(&file, line);
  }
  Serial.print("mode: "), Serial.println(stdin_mode);
}
/* ------------------------------------------------- */

void readKeys() {
  bool key_held = false;
  
  for (uint8_t row = 0; row < row_N; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = matrix[row][col].pin;
      
      if (digitalRead(col_pin) == LOW) {
        if ((millis()-kp_last_press) > KP_DEBOUNCE) {
          digitalWrite(LED_BUILTIN, HIGH);
          kp_last_press = millis();
          
          while (digitalRead(col_pin) == LOW) {
            if ((millis()-kp_last_press) > KP_HOLD_TIME) {
              digitalWrite(LED_BUILTIN, !digitalRead(LED_BUILTIN)), delay(30);
              key_held = true;
            }
          }
          
          if (key_held)
            keyHeld(&(matrix[row][col]));
          else {
            char c = t9_getChar( &(matrix[row][col]) );
            if (c == '\r') 
              fbuf[kp_cursor] = '\0',
              sendCmd(fbuf);  
            else
              drawCmd(); 
          }
          digitalWrite(LED_BUILTIN, LOW);     
        }
      }
    }
    digitalWrite(rowPins[row], HIGH);
  }
  digitalWrite(BGL_PIN, ((millis()-kp_last_press) < BGL_TIMEOUT));
}
/* ------------------------------------------------- */

void loop() {    
  while (Serial.available() == 0) 
    readKeys();

  while (Serial.available() > 0) 
    readSerial(); 
    
  /*
  if (Serial.available()) {
    display.clearDisplay();
    display.setCursor(0, 0);
    
    while (Serial.available() > 0) {
      display.write(Serial.read()); 
      display.display();
    }
  }
  
   //while (Serial.available() >  0) 
   // readSerial(); 
  */
}
