/*
KEYPAD     PICO
 pin 1  ->  pin 6
 pin 2  ->  pin 7
 pin 3  ->  pin 8
 pin 4  ->  pin 9
 pin 5  ->  pin 14
 pin 6  ->  pin 15
 pin 7  ->  pin 10
 pin 8  ->  pin 11
 pin 9  ->  pin 12
 pin 10 ->  pin 13


KS0108          PICO
 pin 4  (RS)  ->  pin 22
 pin 5  (RW)  ->  pin 27(N/A)
 pin 6  (E)   ->  pin 20
 pin 7  (DB0) ->  pin 21
 pin 8  (DB1) ->  pin 19
 pin 9  (DB2) ->  pin 18
 pin 10 (DB3) ->  pin 17
 pin 11 (DB4) ->  pin 16
 pin 12 (DB5) ->  pin 0
 pin 13 (DB6) ->  pin 1
 pin 14 (DB7) ->  pin 2
 pin 15 (CS1) ->  pin 3 
 pin 16 (CS2) ->  pin 4
 pin 17 (RST) ->  pin 5
 
*/

#include <Arduino.h>
#include <stdio.h>
#include <pico/stdlib.h>

#if defined(USE_TINYUSB)
  #include <Adafruit_TinyUSB.h>
#elif defined(CFG_TUSB_MCU)
  #error Incompatible USB stack. Select Adafruit TinyUSB in Tools menu. 
#endif
  
#include <TinyUSB_Devices.h>
#include <Adafruit_GFX.h>   // include adafruit GFX library
#include "KS0108_GLCD.h"    // include KS0108 GLCD library
#include "includes.h"

char fbuf[8][21] = {
  {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '},
  {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '},
  {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '},
  {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '},
  {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '},
  {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '},
  {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '},
  {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '}
};

const uint8_t row_N = 4;
const uint8_t col_N = 6;

uint8_t rowPins[row_N] = {7, 14, 10, 11};
uint8_t colPins[col_N] = {6, 8, 9, 15, 12, 13};

enum : int { R1, R2, R3, R4 };
enum : int { C1, C2, C3 };

struct Map {
  uint8_t pin;
  char    symbol;
  uint8_t   key;
}
Matrix[4][3] = {
  {
    { colPins[0], '7', HID_KEY_KEYPAD_7 },
    { colPins[2], '8', HID_KEY_KEYPAD_8 },
    { colPins[1], '9', HID_KEY_KEYPAD_9 },
  },
  {
    { colPins[0], '4', HID_KEY_KEYPAD_4 },
    { colPins[2], '5', HID_KEY_KEYPAD_5 },
    { colPins[3], '6', HID_KEY_KEYPAD_6 },
  },
  {
    { colPins[0], '1', HID_KEY_KEYPAD_1 },
    { colPins[2], '2', HID_KEY_KEYPAD_2 },
    { colPins[3], '3', HID_KEY_KEYPAD_3 },
  },
  {
    { colPins[2], '0', HID_KEY_KEYPAD_0 },
    { colPins[5], 'x', HID_KEY_KEYPAD_MULTIPLY},
    { colPins[4], '#', HID_KEY_EUROPE_2 },
  },
};
/*
char keymap[4][3] = {
  {'7','8','9'}, // R0
  {'4','5','6'}, // R1
  {'1','2','3'}, // R2
  {'0','*','#'}  // R3
};//C1, C2, C3
*/

uint8_t matrix[4][3] = {
  { colPins[0], colPins[2], colPins[1] },
  { colPins[0], colPins[2], colPins[3] },
  { colPins[0], colPins[2], colPins[3] },
  { colPins[2], colPins[5], colPins[4] } 
};


/* ------------------------------------------------- */

void setup() {
  Serial.begin(115200);

  pinMode(LED_BUILTIN, OUTPUT);
  digitalWrite(LED_BUILTIN, LOW);
  
  pinMode(26, OUTPUT);
  digitalWrite(26, LOW);
  
  for (int i = 0; i < row_N; i++)
    pinMode(rowPins[i], OUTPUT),
    digitalWrite(rowPins[i], HIGH);
  
  for (int i = 0; i < col_N; i++)
    pinMode(colPins[i], INPUT_PULLUP);

  TinyUSBDevice.setManufacturerDescriptor(MANUFACTURER_NAME);
  TinyUSBDevice.setProductDescriptor(DEVICE_NAME);
  TinyUSBDevice.setID(DEVICE_VID, DEVICE_PID);
  
  TinyUSBDevices.begin(2);
  
  while(!USBDevice.mounted()) yield();
  
  Keyboard.releaseAll();
  delay(1000);
}

void loop() {
  for (uint8_t row = 0; row < row_N; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = Matrix[row][col].pin;
      
      if (digitalRead(col_pin) == LOW) {
        Keyboard.write(Matrix[row][col].symbol);
        digitalWrite(LED_BUILTIN, HIGH);
        
        while (digitalRead(col_pin) == LOW);
        Keyboard.releaseAll();
        digitalWrite(LED_BUILTIN, LOW);
      }
    }
    digitalWrite(rowPins[row], HIGH);
  }
}

void setup1()   {                
  Serial.begin(9600);
  display.setTextSize(1);  

  // initialize KS0108 GLCD module with active high CS pins
  if ( display.begin(KS0108_CS_ACTIVE_HIGH) == false ) {
    Serial.println( F("display initialization failed!") );    // lack of RAM space
    while(true);  // stay here forever!
  }

  pinMode(BGL_PIN, OUTPUT);

  display.display();
  delay(2000); // Pause for 2 seconds

  // Clear the buffer
  display.clearDisplay();
    
}

void loop1() {
  testdrawchar();
}
