#pragma once

#include <Arduino.h>
#include <stdint.h>

#define MANUFACTURER_NAME "Døgenigt"
#define DEVICE_NAME       "LO-PI Phone v0.1"
#define DEVICE_VID        0x0420
#define DEVICE_PID        0x1986  

#define ArrLen(x)  (sizeof(x)/sizeof(x[0]))
#define prnt        Serial.print
#define prntln      Serial.println

#define BGL_PIN     26

//                                RS, RW, E, D0,  D1, D2, D3, D4, D5, D6, D7, CS1, CS2, RST);
KS0108_GLCD display = KS0108_GLCD(22, 27, 20, 21, 19, 18, 17, 16, 0,  1,  2,  3,   4,   5);

void testdrawchar(void) {
  display.clearDisplay();
  digitalWrite(BGL_PIN, HIGH);
  
  display.setTextSize(1);      // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON); // Draw white text
  display.setCursor(0, 0);     // Start at top-left corner
  display.cp437(true);         // Use full 256 char 'Code Page 437' font

  // Not all the characters will fit on the display. This is normal.
  // Library will draw what it can and the rest will be clipped.
  for(int16_t i=0; i<256; i++) {
    if(i == '\n') display.write(' ');
    else          display.write(i);
    display.display();
    delay(100);
  }

  display.display();
  delay(2000);
  digitalWrite(BGL_PIN, LOW);
}
