/*
KEYPAD     PICO
 pin 1  ->  pin 6
 pin 2  ->  pin 7
 pin 3  ->  pin 8
 pin 4  ->  pin 9
 pin 5  ->  pin 14
 pin 6  ->  pin 15
 pin 7  ->  pin 10
 pin 8  ->  pin 11
 pin 9  ->  pin 12
 pin 10 ->  pin 13


KS0108          PICO
 pin 4  (RS)  ->  pin 22
 pin 5  (RW)  ->  pin 27(N/A)
 pin 6  (E)   ->  pin 20
 pin 7  (DB0) ->  pin 21
 pin 8  (DB1) ->  pin 19
 pin 9  (DB2) ->  pin 18
 pin 10 (DB3) ->  pin 17
 pin 11 (DB4) ->  pin 16
 pin 12 (DB5) ->  pin 0
 pin 13 (DB6) ->  pin 1
 pin 14 (DB7) ->  pin 2
 pin 15 (CS1) ->  pin 3 
 pin 16 (CS2) ->  pin 4
 pin 17 (RST) ->  pin 5
 
*/

#include <Arduino.h>
#include <stdio.h>
#include <pico/stdlib.h>

#if defined(USE_TINYUSB)
  #include <Adafruit_TinyUSB.h>
#elif defined(CFG_TUSB_MCU)
  #error Incompatible USB stack. Select Adafruit TinyUSB in Tools menu. 
#endif
  
#include <TinyUSB_Devices.h>
#include <Adafruit_GFX.h>   // include adafruit GFX library
#include "KS0108_GLCD.h"    // include KS0108 GLCD library
#include "includes.h"

char fbuf[8][21] = {
  "","","","","","","",""
};

/*char fbuf[8][21] = {
  {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '},
  {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '},
  {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '},
  {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '},
  {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '},
  {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '},
  {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '},
  {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '}
};*/

const uint8_t row_N = 4;
const uint8_t col_N = 6;

uint8_t rowPins[row_N] = {7, 14, 10, 11};
uint8_t colPins[col_N] = {6, 8, 9, 15, 12, 13};

enum : int { R1, R2, R3, R4 };
enum : int { C1, C2, C3 };

struct Map {
  uint8_t pin;
  uint8_t key;
  uint8_t t9_index;
  char    t9_dict[8];

}
Matrix[4][3] = {
  {
    { colPins[0], 1, 1, {'1','a','b','c','A','B','C','\0'}},
    { colPins[2], 2, 1, {'2','d','e','f','D','E','F','\0'}},
    { colPins[1], 3, 1, {'3','g','h','i','G','H','I','\0'}}
  },
  {
    { colPins[0], 4, 1, {'4','j','k','l','J','K','L','\0'}},
    { colPins[2], 5, 1, {'5','m','n','o','M','N','O','\0'}},
    { colPins[3], 6, 1, {'6','p','q','r','P','Q','R','\0'}}
  },
  {
    { colPins[0], 7, 1, {'7','s','t','u','S','T','U','\0'}},
    { colPins[2], 8, 1, {'8','v','x','y','V','X','Y','\0'}},
    { colPins[3], 9, 1, {'9','z','.',',','Z','.',',','\0'}}
  },
  {
    { colPins[2], 10, 1, {'0','0','.',',',' ','.',',','\0'}},
    { colPins[5], 11, 1, {'*','*','.',',',' ','.',',','\0'}},
    { colPins[4], 12, 1, {'#','#','.',',',' ','.',',','\0'}}
  },
};
/*
char keymap[4][3] = {
  {'7','8','9'}, // R0
  {'4','5','6'}, // R1
  {'1','2','3'}, // R2
  {'0','*','#'}  // R3
};//C1, C2, C3
*/

uint8_t matrix[4][3] = {
  { colPins[0], colPins[2], colPins[1] },
  { colPins[0], colPins[2], colPins[3] },
  { colPins[0], colPins[2], colPins[3] },
  { colPins[2], colPins[5], colPins[4] } 
};

unsigned long last_press = millis();

/* ------------------------------------------------- */

void setup() {
  Serial.begin(115200);

  pinMode(LED_BUILTIN, OUTPUT);
  digitalWrite(LED_BUILTIN, LOW);
  
  pinMode(26, OUTPUT);
  digitalWrite(26, LOW);
  
  for (int i = 0; i < row_N; i++)
    pinMode(rowPins[i], OUTPUT),
    digitalWrite(rowPins[i], HIGH);
  
  for (int i = 0; i < col_N; i++)
    pinMode(colPins[i], INPUT_PULLUP);

  TinyUSBDevice.setManufacturerDescriptor(MANUFACTURER_NAME);
  TinyUSBDevice.setProductDescriptor(DEVICE_NAME);
  TinyUSBDevice.setID(DEVICE_VID, DEVICE_PID);
  
  TinyUSBDevices.begin(2);
  
  while(!USBDevice.mounted()) yield();
  
  Keyboard.releaseAll();
  last_press = millis();

  delay(1000);
}

void loop() {
  for (uint8_t row = 0; row < row_N; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = Matrix[row][col].pin;
      
      if (digitalRead(col_pin) == LOW) {
        if ((millis()-last_press) > 50) {
          digitalWrite(LED_BUILTIN, HIGH);
          //uint8_t key_num = kp_showchar(Matrix[row][col].symbol);
          uint8_t key = Matrix[row][col].key;
          Serial.print("key pressed: "), Serial.println(key);
          //Keyboard.write(Matrix[row][col].symbol);      
          
          while (digitalRead(col_pin) == LOW);
          digitalWrite(LED_BUILTIN, LOW);
          last_press = millis();
          //Keyboard.releaseAll();          
        }
      }
    }
    digitalWrite(rowPins[row], HIGH);
  }
}

void setup1()   {                
  Serial.begin(9600);
  display.setTextSize(1);  

  // initialize KS0108 GLCD module with active high CS pins
  if ( display.begin(KS0108_CS_ACTIVE_HIGH) == false ) {
    Serial.println( F("display initialization failed!") );    // lack of RAM space
    while(true);  // stay here forever!
  }

  pinMode(BGL_PIN, OUTPUT);
  
  // Clear the buffer
  display.clearDisplay();
    
}

void loop1() {
  testdrawchar();
}
