#pragma once

#include <Arduino.h>
#include <stdint.h>

#define MANUFACTURER_NAME "Døgenigt"
#define DEVICE_NAME       "LO-PI Phone v0.1"
#define DEVICE_VID        0x0420
#define DEVICE_PID        0x1986  

#define ArrLen(x)         (sizeof(x)/sizeof(x[0]))

#define BGL_PIN           26

//                                RS, RW, E, D0,  D1, D2, D3, D4, D5, D6, D7, CS1, CS2, RST);
KS0108_GLCD display = KS0108_GLCD(22, 27, 20, 21, 19, 18, 17, 16, 0,  1,  2,  3,   4,   5);

//-------------------------------------------------------

void testdrawchar(void) {
  display.clearDisplay();
  digitalWrite(BGL_PIN, HIGH);
  
  display.setTextSize(1);      // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON); // Draw white text
  display.setCursor(0, 0);     // Start at top-left corner
  display.cp437(true);         // Use full 256 char 'Code Page 437' font

  // Not all the characters will fit on the display. This is normal.
  // Library will draw what it can and the rest will be clipped.
  for(int16_t i=0; i<256; i++) {
    if(i == '\n') display.write(' ');
    else          display.write(i);
    display.display();
    delay(100);
  }

  display.display();
  delay(2000);
  digitalWrite(BGL_PIN, LOW);
}
//-------------------------------------------------------

uint8_t kp_showchar(char key) {
  //Serial.print("key pressed: "), Serial.println(key);

  uint8_t num;
  
  switch(key) {
    case '7':
      num = 1;
      break;
    case '8':
      num = 2;
      break;
    case '9':
      num = 3;
      break;
    case '4':
      num = 4;
      break;
    case '5':
      num = 5;
      break;
    case '6':
      num = 6;
      break;
    case '1':
      num = 7;
      break;
    case '2':
      num = 8;
      break;
    case '3':
      num = 9;
      break;
    case '0':
      num = 10;
      break;
    case 'x':
      num = 11;
      break;
    case '#':
      num = 12;
      break;
    default:
      num = 0;
      break;
  }
  return num;
}
//-------------------------------------------------------
