#pragma once

#include <Arduino.h>
#include <stdint.h>

#define MANUFACTURER_NAME "Døgenigt"
#define DEVICE_NAME       "LO-PI Phone v0.1"
#define DEVICE_VID        0x0420
#define DEVICE_PID        0x1986  

#define ArrLen(x)         (sizeof(x)/sizeof(x[0]))

#define BGL_PIN           26

// DA_DK keys
#define KEY_A_RING        (136+0x2f)
#define KEY_SLASHED_O     (136+0x34)
#define KEY_ASH           (136+0x33)
#define KEY_UMLAUT        (136+0x30)
#define KEY_ACUTE_ACC     (136+0x2e)

/*
static constexpr unsigned char cp[] = {
  (136+0x34),
  (136+0x33),
  (136+0x30),
  (136+0x2e),
};

char nordic[3] = {cp[0], cp[1], '\0'};
*/

//                                RS, RW, E, D0,  D1, D2, D3, D4, D5, D6, D7, CS1, CS2, RST);
KS0108_GLCD display = KS0108_GLCD(22, 27, 20, 21, 19, 18, 17, 16, 0,  1,  2,  3,   4,   5);

const uint8_t row_N = 4;
const uint8_t col_N = 6;

uint8_t       rowPins[row_N] = {7, 14, 10, 11};
uint8_t       colPins[col_N] = {6, 8, 9, 15, 12, 13};

char          kp_last_char  = '\0';
uint8_t       kp_last_key   = 0;
uint8_t       kp_cursr      = 0;
unsigned long kp_last_press;

struct Map {
  uint8_t     pin;
  uint8_t     key;
  uint8_t     t9_index;
  const char* t9_dict;
};

Map matrix[4][3] = {
  {
    { colPins[0], 1, 0, "\x2F\x34\x33"},
    { colPins[2], 2, 0, "abc"},
    { colPins[1], 3, 0, "def"}
  },
  {
    { colPins[0], 4, 0, "ghi"},
    { colPins[2], 5, 0, "jkl"},
    { colPins[3], 6, 0, "mno"}
  },
  {
    { colPins[0], 7, 0, "pqrs"},
    { colPins[2], 8, 0, "tuv"},
    { colPins[3], 9, 0, "wxyz"}
  },
  {
    { colPins[2], 10, 0, ".,:;-+/"},
    { colPins[5], 11, 0, " "},  
    { colPins[4], 12, 0, ""}
  },
};

char fbuf[8][21] = {
  "","","","","","","",""
};

/*
uint8_t matrix[4][3] = {
  { colPins[0], colPins[2], colPins[1] },
  { colPins[0], colPins[2], colPins[3] },
  { colPins[0], colPins[2], colPins[3] },
  { colPins[2], colPins[5], colPins[4] } 
};
*/

//-------------------------------------------------------

void testdrawchar(void) {
  display.clearDisplay();
  digitalWrite(BGL_PIN, HIGH);
  
  display.setTextSize(1);      // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON); // Draw white text
  display.setCursor(0, 0);     // Start at top-left corner
  display.cp437(true);         // Use full 256 char 'Code Page 437' font

  // Not all the characters will fit on the display. This is normal.
  // Library will draw what it can and the rest will be clipped.
  for(int16_t i=0; i<256; i++) {
    if(i == '\n') display.write(' ');
    else          display.write(i);
    display.display();
    delay(100);
  }

  display.display();
  delay(2000);
  digitalWrite(BGL_PIN, LOW);
}
//-------------------------------------------------------

uint8_t kp_showchar(char key) {
  //Serial.print("key pressed: "), Serial.println(key);

  uint8_t num;
  
  switch(key) {
    case '7':
      num = 1;
      break;
    case '8':
      num = 2;
      break;
    case '9':
      num = 3;
      break;
    case '4':
      num = 4;
      break;
    case '5':
      num = 5;
      break;
    case '6':
      num = 6;
      break;
    case '1':
      num = 7;
      break;
    case '2':
      num = 8;
      break;
    case '3':
      num = 9;
      break;
    case '0':
      num = 10;
      break;
    case 'x':
      num = 11;
      break;
    case '#':
      num = 12;
      break;
    default:
      num = 0;
      break;
  }
  return num;
}
//-------------------------------------------------------

void t9_reset() {
  for (uint8_t x = 0; x < 4; x++) 
    for (uint8_t y = 0; y < 3; y++) 
      matrix[x][y].t9_index = 0;
      
  kp_cursr++;
  fbuf[0][kp_cursr+1] = '\0';
}

char t9_getChar(Map *btn) {
  uint8_t len = strlen(btn->t9_dict);
  uint8_t index, key = btn->key;
  char chr = '\0';
  
  if (len > 0) {
    if (key != kp_last_key)
      t9_reset();

    index = btn->t9_index;
    chr = btn->t9_dict[index];
    fbuf[0][kp_cursr] = chr;
    
    Serial.print("key: "), Serial.println(key);
    Serial.print("str: "), Serial.println(btn->t9_dict);
    Serial.print("len: "), Serial.println(len);
    Serial.print("chr: "), Serial.println(chr);
    Serial.print("idx: "), Serial.println(index);
    btn->t9_index = ++index %= len;
    Serial.print("nxt: "), Serial.println(index);
    Serial.print("crs; "), Serial.println(kp_cursr);
    Serial.println();
  }
  kp_last_char = chr;
  kp_last_key = key;

  return chr;
}
