#pragma once

#include <Arduino.h>
#include <stdint.h>

#define MANUFACTURER_NAME "Døgenigt"
#define DEVICE_NAME       "LO-PI Phone v0.1"
#define DEVICE_VID        0x0420
#define DEVICE_PID        0x1986  

#define ArrLen(x)         (sizeof(x)/sizeof(x[0]))

#define BGL_PIN           26

// DA_DK keys
#define KEY_A_RING        (136+0x2f)
#define KEY_SLASHED_O     (136+0x34)
#define KEY_ASH           (136+0x33)
#define KEY_UMLAUT        (136+0x30)
#define KEY_ACUTE_ACC     (136+0x2e)

/*
static constexpr unsigned char cp[] = {
  (136+0x34),
  (136+0x33),
  (136+0x30),
  (136+0x2e),
};

char nordic[3] = {cp[0], cp[1], '\0'};
*/

//                                RS, RW, E, D0,  D1, D2, D3, D4, D5, D6, D7, CS1, CS2, RST);
KS0108_GLCD display = KS0108_GLCD(22, 27, 20, 21, 19, 18, 17, 16, 0,  1,  2,  3,   4,   5);

const uint8_t row_N = 4;
const uint8_t col_N = 6;

uint8_t       rowPins[row_N] = {7, 14, 10, 11};
uint8_t       colPins[col_N] = {6, 8, 9, 15, 12, 13};

char          kp_last_char  = '\0';
uint8_t       kp_last_key   = 0;
uint8_t       kp_last_index = 0;
uint8_t       kp_cursor     = 0;
unsigned long kp_last_press;

struct Map {
  uint8_t     pin;
  uint8_t     key;
  uint8_t     t9_index;
  const char* t9_dict;
};

Map matrix[4][3] = {
  {
    { colPins[0], 1, 0, ".,:;-+/"},
    { colPins[2], 2, 0, "abc"},
    { colPins[1], 3, 0, "def"}
  },
  {
    { colPins[0], 4, 0, "ghi"},
    { colPins[2], 5, 0, "jkl"},
    { colPins[3], 6, 0, "mno"}
  },
  {
    { colPins[0], 7, 0, "pqrs"},
    { colPins[2], 8, 0, "tuv"},
    { colPins[3], 9, 0, "wxyz"}
  },
  {
    { colPins[2], 10, 0, ""},
    { colPins[5], 11, 0, " "},  
    { colPins[4], 12, 0, ""}
  },
};

char fbuf[8][22] = {'\0'};

/*
uint8_t matrix[4][3] = {
  { colPins[0], colPins[2], colPins[1] },
  { colPins[0], colPins[2], colPins[3] },
  { colPins[0], colPins[2], colPins[3] },
  { colPins[2], colPins[5], colPins[4] } 
};
*/

//-------------------------------------------------------

/*
void testdrawchar(void) {
  display.clearDisplay();
  digitalWrite(BGL_PIN, HIGH);
  
  display.setTextSize(1);      // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON); // Draw white text
  display.setCursor(0, 0);     // Start at top-left corner
  display.cp437(true);         // Use full 256 char 'Code Page 437' font

  // Not all the characters will fit on the display. This is normal.
  // Library will draw what it can and the rest will be clipped.
  for(int16_t i=0; i<256; i++) {
    if(i == '\n') display.write(' ');
    else          display.write(i);
    display.display();
    delay(100);
  }

  display.display();
  delay(2000);
  digitalWrite(BGL_PIN, LOW);
}
*/

void testdrawchar(void) {

  //strcpy(fbuf[0], "Hello there mate");
  
  display.clearDisplay();
  //display.display(); delay(1000);
  
  display.setTextSize(1);      // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON); // Draw white text
  display.setCursor(0, 0);     // Start at top-left corner
  display.cp437(true);         // Use full 256 char 'Code Page 437' font

  for (int i=0; i<=kp_cursor; i++) {
    display.write(fbuf[0][i]);
  }

  //display.println(fbuf[0]);
  display.display();
  //delay(2000);
}

//-------------------------------------------------------

void t9_reset() {
  for (uint8_t x = 0; x < 4; x++) {
    for (uint8_t y = 0; y < 3; y++) 
      matrix[x][y].t9_index = 0;
  }
}

//-------------------------------------------------------

void t9_getChar(Map *btn) {
  uint8_t len = strlen(btn->t9_dict);
  uint8_t key = btn->key;
  uint8_t index;
  char chr;
  
  if (key == 10 || key == 12) {
    if (key == 10) {
      if (strlen(fbuf[0])) {
        fbuf[0][kp_cursor] = '\0';
        kp_cursor = ((kp_cursor > 0) ? kp_cursor-1 : 0); // kp_cursor--;
      }
    }
  } 
  else {
    if (key == kp_last_key) {
      if (len > 0)
        ++btn->t9_index %= len;
    }
    else {
      if (strlen(fbuf[0])) kp_cursor++;
      t9_reset();
    }
    index = btn->t9_index;
    chr   = btn->t9_dict[index];
    fbuf[0][kp_cursor] = chr;
    Serial.print(chr); Serial.print(" @ ");
  }

  Serial.print("cursor "), Serial.println(kp_cursor);


  Serial.print("fbuf: "); 
  for (int i=0; i<22; i++) 
    Serial.print(fbuf[0][i]);
  Serial.println();

  kp_last_key = key;

  /*
  if (key == kp_last_key) {
    if (len > 0)
      ++btn->t9_index %= len;
      
    kp_last_key = key;
    
  } else {
    kp_last_key = ((key == 10 || key == 12) ? 0 : key);
    if (strlen(fbuf[0])) {
      if (key == 10) 
        fbuf[0][kp_cursor] = '\0';
      else
        kp_cursor++;
    }
    //if (kp_cursor > len-1) kp_cursor = len;
      
    t9_reset();
  }
  */
  
  /*
  if (key == 10) {
    fbuf[0][kp_cursor] = '\0';    
    kp_cursor = (
      (kp_cursor > 0) ? 
        ((kp_last_index == 0) ? kp_cursor-1) : 0
    );
  }
  
  if (key == 10) {
    fbuf[0][kp_cursor--] = '\0';
    kp_cursor = ((kp_cursor < 0) ? 0 : kp_cursor);
    t9_reset();
    //kp_cursor = ((kp_cursor > 0) ? kp_cursor-1 : 0);
  }
  else if (key != kp_last_key) {
    if (strlen(fbuf[0])) kp_cursor++;
    t9_reset();
  }
  
  uint8_t index = btn->t9_index;
  char    chr   = btn->t9_dict[index];
  
  fbuf[0][kp_cursor] = chr;
  //fbuf[0][kp_cursr+1] = '\0';

  Serial.print(chr); Serial.print(" @ "), Serial.println(kp_cursor);
  
  Serial.print("fbuf: "); 
  for (int i=0; i<22; i++) 
    Serial.print(fbuf[0][i]);
  Serial.println();
  
  btn->t9_index = ++index %= len;    
  kp_last_key = key;
  */
}

//-------------------------------------------------------

/*
void t9_reset() {
  for (uint8_t x = 0; x < 4; x++) 
    for (uint8_t y = 0; y < 3; y++) 
      matrix[x][y].t9_index = 0;
      
  kp_cursr++;
  fbuf[0][kp_cursr+1] = '\0';
}

char t9_getChar(Map *btn) {
  uint8_t len = strlen(btn->t9_dict);
  uint8_t index, key = btn->key;
  char chr = '\0';
  
  if (len > 0) {
    if (key != kp_last_key)
      t9_reset();

    index = btn->t9_index;
    chr = btn->t9_dict[index];
    fbuf[0][kp_cursr] = chr;
    
    Serial.print("key: "), Serial.println(key);
    Serial.print("str: "), Serial.println(btn->t9_dict);
    Serial.print("len: "), Serial.println(len);
    Serial.print("chr: "), Serial.println(chr);
    Serial.print("idx: "), Serial.println(index);
    btn->t9_index = ++index %= len;
    Serial.print("nxt: "), Serial.println(index);
    Serial.print("crs; "), Serial.println(kp_cursr);
    Serial.println();
  }
  kp_last_char = chr;
  kp_last_key = key;

  return chr;
}
*/
