/*
KEYPAD     PICO
 pin 1  ->  pin 6
 pin 2  ->  pin 7
 pin 3  ->  pin 8
 pin 4  ->  pin 9
 pin 5  ->  pin 14
 pin 6  ->  pin 15
 pin 7  ->  pin 10
 pin 8  ->  pin 11
 pin 9  ->  pin 12
 pin 10 ->  pin 13


KS0108          PICO
 pin 4  (RS)  ->  pin 22
 pin 5  (RW)  ->  pin 27(N/A)
 pin 6  (E)   ->  pin 20
 pin 7  (DB0) ->  pin 21
 pin 8  (DB1) ->  pin 19
 pin 9  (DB2) ->  pin 18
 pin 10 (DB3) ->  pin 17
 pin 11 (DB4) ->  pin 16
 pin 12 (DB5) ->  pin 0
 pin 13 (DB6) ->  pin 1
 pin 14 (DB7) ->  pin 2
 pin 15 (CS1) ->  pin 3 
 pin 16 (CS2) ->  pin 4
 pin 17 (RST) ->  pin 5
 
*/

//#define KS0108_NO_SPLASH

#include <Arduino.h>
#include <stdio.h>
#include <pico/stdlib.h>

#if defined(USE_TINYUSB)
  #include <Adafruit_TinyUSB.h>
#elif defined(CFG_TUSB_MCU)
  #error Incompatible USB stack. Select Adafruit TinyUSB in Tools menu. 
#endif
  
#include <TinyUSB_Devices.h>
#include <Adafruit_GFX.h>   // include adafruit GFX library
#include "KS0108_GLCD.h"    // include KS0108 GLCD library
#include "includes.h"

/* ------------------------------------------------- */

void setup() {
  Serial.begin(115200);

  pinMode(LED_BUILTIN, OUTPUT);
  digitalWrite(LED_BUILTIN, LOW);
  
  pinMode(BGL_PIN, OUTPUT);
  digitalWrite(BGL_PIN, LOW);
  
  for (int i = 0; i < row_N; i++)
    pinMode(rowPins[i], OUTPUT),
    digitalWrite(rowPins[i], HIGH);
  
  for (int i = 0; i < col_N; i++)
    pinMode(colPins[i], INPUT_PULLUP);

  TinyUSBDevice.setManufacturerDescriptor(MANUFACTURER_NAME);
  TinyUSBDevice.setProductDescriptor(DEVICE_NAME);
  TinyUSBDevice.setID(DEVICE_VID, DEVICE_PID);
  
  TinyUSBDevices.begin(2);
  
  while(!USBDevice.mounted()) yield();
  
  Keyboard.releaseAll();
  kp_last_press = millis();

  delay(1000);

  /*
  while (!Serial);
  uint8_t N = 3;
  uint8_t n = 0;
  
  for (int i = 0; i < 5; i++) {
    ++n %= N;
    Serial.print(i), Serial.print(" "), Serial.println(n);
  }
  */
}

void loop() {
  for (uint8_t row = 0; row < row_N; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = matrix[row][col].pin;
      
      if (digitalRead(col_pin) == LOW) {
        if ((millis()-kp_last_press) > 50) {
          digitalWrite(LED_BUILTIN, HIGH);
          //Map *mat = &(matrix[row][col]);
          t9_getChar(&(matrix[row][col]));
          //testdrawchar();
          
          //Keyboard.write(Matrix[row][col].symbol);      
          
          while (digitalRead(col_pin) == LOW);
          digitalWrite(LED_BUILTIN, LOW);
          kp_last_press = millis();
          //Keyboard.releaseAll();          
        }
      }
    }
    digitalWrite(rowPins[row], HIGH);
  }
}

void setup1()   {
  display.setTextSize(1);  

  // initialize KS0108 GLCD module with active high CS pins
  if ( display.begin(KS0108_CS_ACTIVE_HIGH) == false ) {
    Serial.println( F("display initialization failed!") );    // lack of RAM space
    while(true);  // stay here forever!
  }

  display.display();
  delay(2000); // Pause for 2 seconds
  
  display.clearDisplay();           // Clear the buffer
  display.setTextSize(1);           // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON);  // Draw white text
  display.setCursor(0, 0);          // Start at top-left corner
  display.cp437(true);              // Use full 256 char 'Code Page 437' font
  
  display.println(F("LO-PI PHONE v1.0"));
  display.display();
  delay(2000);
  
  display.clearDisplay();

}

char c = fbuf[kp_cursor];

void loop1() {
  //line = fbuf;
  
  if (fbuf[kp_cursor] != c) {
    c = fbuf[kp_cursor];
    testdrawchar(); 
  }
  /*
  for (uint8_t n=0; n<strlen(fbuf); n++) {
    if (cmd[n] != fbuf[n]) {
      testdrawchar();
      cmd = fbuf;
      break;
    }
  }
  */
  /*
  if (strcmp(*cmd, fbuf) != 0) {
    testdrawchar();
    cmd = fbuf;    
  }
  */
  
  /*
  line = fbuf[0];
  //if (strcmp(cmd, (const char*)fbuf[0]) == 0) {
  if (strcmp(cmd, line) != 0) {
    testdrawchar();
    cmd = fbuf[0];
  }
  */

  /*
  if (strlen(fbuf[0]) != cmd_len) {
    testdrawchar();
    cmd_len = strlen(fbuf[0]);
  }*/
}
