#pragma once

#include <Arduino.h>
#include <stdint.h>

#include <Fonts/Picopixel.h>
#include <Fonts/Tiny3x3a2pt7b.h>
#include <Fonts/Org_01.h>

#define MANUFACTURER_NAME "data_dogenigt"
#define DEVICE_NAME       "LoPi-Phone v1.0"
#define DEVICE_VID        0x0920
#define DEVICE_PID        0x1986

#define ArrLen(x)         (sizeof(x)/sizeof(x[0]))

#define PIXELS            168
#define BGL_PIN           26

#define KP_DEBOUNCE       50
#define KP_HOLD_TIME      1000
#define BGL_TIMEOUT       30000UL

//                                RS, RW, E, D0,  D1, D2, D3, D4, D5, D6, D7, CS1, CS2, RST);
KS0108_GLCD display = KS0108_GLCD(22, 27, 20, 21, 19, 18, 17, 16, 0,  1,  2,  3,   4,   5);

const uint8_t ln_cmd = 7;
const uint8_t row_N = 4;
const uint8_t col_N = 6;

uint8_t       rowPins[row_N] = {7, 14, 10, 11};
uint8_t       colPins[col_N] = {6, 8, 9, 15, 12, 13};


// 21 x 8 chars = 168 (+ null byte)
char fbuf[PIXELS+1] = {'\0'};

char          kp_last_char  = '\0';
uint8_t       kp_last_key   = 0;
uint8_t       kp_last_index = 0;
uint8_t       kp_cursor     = 0;
unsigned long kp_last_press;
unsigned long last_bgl_on;

bool stdin_mode = false;
char c = fbuf[kp_cursor];
int pg = 0;
int indexes[16];

enum : int { 
  FONT_MINI   = -2,
  FONT_SMALL  = -1,
  FONT_NORMAL =  0
};

struct _fonts {
  const GFXfont *font;
  uint8_t        width;
  
}
fonts[3] = {
 { &Tiny3x3a2pt7b, 4},
 { &Picopixel,     4},
 { NULL,          8}  
};


struct Map {
  uint8_t     pin;
  uint8_t     key;
  uint8_t     t9_index;
  const char* t9_dict;
  int16_t     symbol;
};


Map matrix[4][3] = {
  {
    { colPins[0], 1, 0, ".,:;-+/",  94},
    { colPins[2], 2, 0, "abcABC",   24},
    { colPins[1], 3, 0, "defDEF",   30}
  },
  {
    { colPins[0], 4, 0, "ghiGHI",   27},
    { colPins[2], 5, 0, "jklJKL",   23},
    { colPins[3], 6, 0, "mnoMNO",   26}
  },
  {
    { colPins[0], 7, 0, "pqrsPQRS", 127},
    { colPins[2], 8, 0, "tuvTUV",   25},
    { colPins[3], 9, 0, "wxyzWXYZ", 31}
  },
  {
    { colPins[2], 10, 0, "",        22},
    { colPins[5], 11, 0, " ",       42},  
    { colPins[4], 12, 0, "",        35}
  },
};

typedef enum : int { 
  mode_nav, 
  mode_read, 
  mode_write 
} 
Mode;

Mode UI = mode_write;



//-------------------------------------------------------

void drawCmd(void) {
  display.clearDisplay();
  
  display.setTextSize(1); 
  display.setTextColor(KS0108_ON);
  display.setCursor(0, 0);
  display.cp437(true);
  
  display.write('>');
  for (int i=0; i<=kp_cursor; i++) {
    if (fbuf[i] != '\0')
      display.write(fbuf[i]);
  }
  display.write(219);
  display.display();
}

//-------------------------------------------------------

void t9_reset() {
  for (uint8_t x = 0; x < 4; x++) {
    for (uint8_t y = 0; y < 3; y++) 
      matrix[x][y].t9_index = 0;
  }
}

//-------------------------------------------------------

void t9_getChar(Map *btn) {
  uint8_t len = strlen(btn->t9_dict);
  uint8_t key = btn->key;
  uint8_t index;
  char chr;
  
  if (key == 10 || key == 12) {
    if (key == 10) {
      if (strlen(fbuf)) {
        fbuf[kp_cursor] = '\0';
        kp_cursor = ((kp_cursor > 0) ? kp_cursor-1 : 0);
      }
    }
    else if (key == 12) {
      if (strlen(fbuf) > 0 && (strlen(fbuf) < sizeof(fbuf)-1))
        fbuf[++kp_cursor] = '\r';
        return;
    }
  } 
  else {
    if (key == kp_last_key && key != 11) {
      if (len > 0)
        ++btn->t9_index %= len;
    }
    else {
      if (strlen(fbuf) > 0 && (strlen(fbuf) < sizeof(fbuf)-1))
        kp_cursor++;
      t9_reset();
    }

    index = btn->t9_index;
    chr = btn->t9_dict[index];
    fbuf[kp_cursor] = chr;
  }

  if (key == 11 && kp_last_key != 11) {
    if (strlen(fbuf)) {
      fbuf[kp_cursor] = '\0';
      kp_cursor = ((kp_cursor > 0) ? kp_cursor-1 : 0);
    }
  }

  kp_last_key = key;
}

//------------------------------------------------------- 

void sendCmd(const char* cmd) {
  Keyboard.println(cmd); 
  delay(100);
  Keyboard.releaseAll();
  
  memset(fbuf,'\0',sizeof(fbuf));
  kp_cursor = 0;
  kp_last_key = 0;
  t9_reset();
}

//-------------------------------------------------------

void menu() {
  UI = mode_nav;
  display.clearDisplay();
  
  display.setTextSize(1); 
  display.setTextColor(KS0108_ON);
  display.cp437(true);
  display.setCursor(0, 0);
    
  display.println("MENU");
  display.write(219);
  display.display();    
}

void cmd_line() {
  UI = mode_write;
  display.clearDisplay();
  
  display.setTextSize(1); 
  display.setTextColor(KS0108_ON);
  display.cp437(true);
  display.setCursor(0, 0);

  display.write('>');
  display.write(219);
  display.display();
}



//-------------------------------------------------------

void keyHeld(Map *btn) {
  uint8_t key = btn->key;

  switch(key) {
    case 1:
      break;
      
    case 10:
      if (UI != mode_nav)
        cmd_line();
      break;
      
    case 11:
      break;
      
    case 12:
      break;
      
    default:
      break;
  }
}
