#include <Arduino.h> 
#include <stdio.h>
#include <pico/stdlib.h>
#include <Adafruit_GFX.h>   // include adafruit GFX library
#include "KS0108_GLCD.h"    // include KS0108 GLCD library
#include <Fonts/Picopixel.h>
//#include "customKeyPad.h"

#define DEBOUNCE      50
//#define DEBUG

KS0108_GLCD display = KS0108_GLCD(22, 20, 21, 19, 18, 17, 16, 26, 27, 5,  4,  3,  2 ); /*
                                  RS  E   D0  D1  D2  D3  D4  D5  D6  D7  CS1 CS2 RST  */


const uint8_t row_N = 4;
const uint8_t col_N = 6;
unsigned long kp_last_press;

uint8_t rowPins[row_N] = {
  7,    // KP 2
  15,   // KP 5
  10,   // KP 7
  11    // KP 8
};

uint8_t colPins[col_N] = {
  6,    // KP 1
  8,    // KP 3
  9,    // KP 4
  14,   // KP 6
  12,   // KP 9
  13    // KP 10
};


char    c_last;
char    buf_input[256];
uint8_t buf_index;

struct Map {
  uint8_t     pin;
  uint8_t     key;
  int16_t     index;
  const char* t9_page;
};

Map matrix[4][3] = {
  {
    { colPins[0], 1, 0, ".,!?:;_-+=*/'\"%$&#@(){}[]"},
    { colPins[2], 2, 0, "abcABC"},
    { colPins[1], 3, 0, "defDEF"},
  },
  {
    { colPins[0], 4, 0, "ghiGHI"},
    { colPins[2], 5, 0, "jklJKL"},
    { colPins[3], 6, 0, "mnoMNO"}
  },
  {
    { colPins[0], 7, 0, "pqrsPQRS"},
    { colPins[2], 8, 0, "tuvTUV"},
    { colPins[3], 9, 0, "wxyzWXYZ"}
  },
  {
    { colPins[2], 11, 0, ""},
    { colPins[5], 10, 0, " "},
    { colPins[4], 12, 0, "0123456789"}
  },
};

void setup() {
  Serial.begin(9600);
  //pinMode(LED_BUILTIN, OUTPUT);
  
  #ifdef DEBUG
    while (!Serial);
  #endif

  // initialize KS0108 GLCD module with active high CS pins
  if ( display.begin(KS0108_CS_ACTIVE_HIGH) == false ) {
    Serial.println( F("display initialization failed!") );    // lack of RAM space
    while (1);
  }

  //display.display();
  //delay(2000);
  
  display.clearDisplay();           // Clear the buffer
  display.setTextSize(1);           // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON);  // Draw white text
  display.setCursor(0, 0);          // Start at top-left corner
  display.cp437(true);              // Use full 256 char 'Code Page 437' font
  display.setTextWrap(true);        // Set whether text should wrap around (else clip right).
  //display.setFont(&Picopixel);

  for (int i = 0; i < row_N; i++)
    pinMode(rowPins[i], OUTPUT),
    digitalWrite(rowPins[i], HIGH);
  
  for (int i = 0; i < col_N; i++)
    pinMode(colPins[i], INPUT_PULLUP);

  memset(buf_input, 0, sizeof(buf_input));
  kp_last_press = millis();
  //initKeypad();  

  /*
  for (int i= 0; i<30; i++) {
    display.printf("text %d\n", random(0, 255));
    if (display.getCursorY() >= display.height()) { 
      display.pushUp(8); display.display(); 
      display.setCursor(0, (display.height()-8)); 
    }
    delay(500);
  }
  */
}
// ---------------------------------------------------------------



Map *readKeyPad() {
  for (uint8_t row = 0; row < 4; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = matrix[row][col].pin;
      uint8_t key = matrix[row][col].key;  
      
      if (digitalRead(col_pin) == LOW) {
        if ((millis()-kp_last_press) > DEBOUNCE && key != 12) {
          while (digitalRead(col_pin) == LOW); 
          digitalWrite(rowPins[row], HIGH);
          kp_last_press = millis();
          
          return &(matrix[row][col]);
        }
      }
    }
    digitalWrite(rowPins[row], HIGH);
  }
  return nullptr;
}
// ---------------------------------------------------------------

void t9_reset() {
  for (uint8_t x = 0; x < 4; x++) 
    for (uint8_t y = 0; y < 3; y++) 
      matrix[x][y].index = 0;
}
// ---------------------------------------------------------------

void checkInput() {
  int16_t curSym = 219;
  uint8_t key, index;
  char c;
  
  Map *obj = readKeyPad();
  
  if (obj != NULL) {
    key = obj->key;

    if (obj->index < 1) {
      if (buf_input[buf_index] != '\0' && key < 10)
        buf_index++;
      else if (key == 10) 
        curSym = 177;
        
      t9_reset();
    } else {
      if (key == 10) 
        buf_index++;
    }
    
    if (key == 11) {
      buf_input[buf_index] = '\0';
      if (buf_index > 0) buf_index--;
    }

    index = obj->index % strlen(obj->t9_page);
    
    if (strlen(obj->t9_page) > 0) {
      c = obj->t9_page[index];        
      if (!(key == 10 && obj->index == 0)) 
        buf_input[buf_index] = c;
        
      obj->index++;
    }

    Serial.print("> "), Serial.println(buf_input);
    
    display.clearDisplay();
    display.setCursor(0,0);
    display.print("> ");
    display.print(buf_input);
    display.write(curSym);
    display.write('\n');
    display.display();
    delay(100);
  }
}
// ---------------------------------------------------------------

void loop()  {
  //readKeyPad();
  if (BOOTSEL) { 
    while (BOOTSEL);

    if (strlen(buf_input) > 0) {
      Serial.print("SENDING '"), Serial.print(buf_input), Serial.println("'");

      display.clearDisplay(); display.setCursor(0,0); 
      display.println("Command:"); display.display();
      display.setFont(&Picopixel);
      display.print("'"); display.print(buf_input); display.println("'"); display.display();
      delay(1000);
      display.setFont(NULL);
     
    }
    memset(buf_input, 0, sizeof(buf_input));
    t9_reset();
    buf_index = 0;
  }
  else {
    checkInput();
  }  
}
