#pragma once

#define DEBOUNCE      50

extern KS0108_GLCD display;

const uint8_t row_N = 4;
const uint8_t col_N = 6;
unsigned long kp_last_press;

uint8_t rowPins[row_N] = {
  7,    // KP 2
  15,   // KP 5
  10,   // KP 7
  11    // KP 8
};

uint8_t colPins[col_N] = {
  6,    // KP 1
  8,    // KP 3
  9,    // KP 4
  14,   // KP 6
  12,   // KP 9
  13    // KP 10
};


char    c_last;
char    buf_input[256];
uint8_t buf_index;

struct Map {
  uint8_t     pin;
  uint8_t     key;
  int16_t     index;
  const char* t9_page;
};

Map matrix[4][3] = {
  {
    { colPins[0], 1, 0, ".,!?:;_-+=*/'\"%$&#@(){}[]"},
    { colPins[2], 2, 0, "abcABC"},
    { colPins[1], 3, 0, "defDEF"},
  },
  {
    { colPins[0], 4, 0, "ghiGHI"},
    { colPins[2], 5, 0, "jklJKL"},
    { colPins[3], 6, 0, "mnoMNO"}
  },
  {
    { colPins[0], 7, 0, "pqrsPQRS"},
    { colPins[2], 8, 0, "tuvTUV"},
    { colPins[3], 9, 0, "wxyzWXYZ"}
  },
  {
    { colPins[2], 11, 0, ""},
    { colPins[5], 10, 0, "0123456789"},
    { colPins[4], 12, 0, " "}
  },
};
// ---------------------------------------------------------------


void initKeypad() {
  Serial.println(F("initializing keypad."));
  
  for (int i = 0; i < row_N; i++)
    pinMode(rowPins[i], OUTPUT),
    digitalWrite(rowPins[i], HIGH);
  
  for (int i = 0; i < col_N; i++)
    pinMode(colPins[i], INPUT_PULLUP);

  kp_last_press = millis();
}
// ---------------------------------------------------------------

Map *readKeyPad() {
  uint8_t key = 0;
  
  for (uint8_t row = 0; row < 4; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = matrix[row][col].pin;
        
      if (digitalRead(col_pin) == LOW && col_pin != 13) {
        if ((millis()-kp_last_press) > DEBOUNCE) {
          digitalWrite(LED_BUILTIN, HIGH);
          key = matrix[row][col].key;
          Serial.println(key);
          while (digitalRead(col_pin) == LOW); 
          
          digitalWrite(LED_BUILTIN,  LOW);
          digitalWrite(rowPins[row], HIGH);
          kp_last_press = millis();
          
          return &(matrix[row][col]);
        }
      }
    }
    digitalWrite(rowPins[row], HIGH);
  }
  return nullptr;
}
// ---------------------------------------------------------------

void t9_reset() {
  for (uint8_t x = 0; x < 4; x++) 
    for (uint8_t y = 0; y < 3; y++) 
      matrix[x][y].index = 0;
}
// ---------------------------------------------------------------

void checkInput() {
  uint8_t key, index;
  char c;
  
  Map *obj = readKeyPad();
  
  if (obj != NULL) {
    key = obj->key;

    if (obj->index < 1) {
      if (buf_input[buf_index] != '\0' && key < 11) 
        buf_index++;
      t9_reset();
    } else {
      if (key == 12) 
        buf_index++;
    }
    
    if (key == 11) {
      buf_input[buf_index] = '\0';
      if (buf_index > 0) buf_index--;
    }

    index = obj->index % strlen(obj->t9_page);
    
    if (strlen(obj->t9_page) > 0) {
      c = obj->t9_page[index];        
      if (!(key == 12 && obj->index == 0)) 
        buf_input[buf_index] = c;
        
      obj->index++;
    }

    Serial.print("> "), Serial.println(buf_input);
    
    display.clearDisplay();
    display.setCursor(0,0);
    display.print("> ");
    display.println(buf_input);
    display.display();
    delay(100);
    
  }
}
