//#include <Arduino.h> 
#include <stdio.h>
#include <pico/stdlib.h>
#include <hardware/gpio.h>
#include <hardware/uart.h>
#include <Adafruit_GFX.h>   // include adafruit GFX library
#include "KS0108_GLCD.h"    // include KS0108 GLCD library
#include <Fonts/Picopixel.h>
//#include "customKeyPad.h"

//#define DEBUG
#define USE_MODEM
#define USE_DISPLAY

#define Modem         Serial1
#define DEBOUNCE      50


bool online;
bool glcd_on;

const uint8_t row_N = 4;
const uint8_t col_N = 6;
unsigned long kp_last_press;

KS0108_GLCD display = KS0108_GLCD(
  22, // -> LCD 4  ( RS )
  20, // -> LCD 6  ( E )
  21, // -> LCD 7  ( D0 )
  19, // -> LCD 8  ( D1 )
  18, // -> LCD 8  ( D2 )
  17, // -> LCD 10 ( D3 )
  16, // -> LCD 11 ( D4 )
  27, // -> LCD 12 ( D5 )
  26, // -> LCD 13 ( D6 )
  5,  // -> LCD 14 ( D7 )
  4,  // -> LCD 15 ( CS1 )
  3,  // -> LCD 16 ( CS2 )
  2   // -> LCD 17 ( RES )
);


uint8_t rowPins[row_N] = {
  6,  // -> KP 2 (R1)
  8,  // -> KP 5 (R2)
  7,  // -> KP 7 (R3)
  9   // -> KP 8 (R4)
};

uint8_t colPins[col_N] = {
  13, // -> KP 1  ( C1 )
  12, // -> KP 3  ( C2 )
  14, // -> KP 4  ( C3 )
  15, // -> KP 6  ( C4 )
  11, // -> KP 9  ( C5 )
  10  // -> KP 10 ( C6 )
}; 


char    c_last;
char    buf_input[256];
uint8_t buf_index;

struct Map {
  uint8_t     pin;
  uint8_t     key;
  int16_t     index;
  const char* t9_page;
};

Map matrix[4][3] = {
  {
    { colPins[0], 1, 0, ".,!?:;_-+=*/'\"%$&#@(){}[]"},
    { colPins[2], 2, 0, "abcABC"},
    { colPins[1], 3, 0, "defDEF"},
  },
  {
    { colPins[0], 4, 0, "ghiGHI"},
    { colPins[2], 5, 0, "jklJKL"},
    { colPins[3], 6, 0, "mnoMNO"}
  },
  {
    { colPins[0], 7, 0, "pqrsPQRS"},
    { colPins[2], 8, 0, "tuvTUV"},
    { colPins[3], 9, 0, "wxyzWXYZ"}
  },
  {
    { colPins[2], 11, 0, ""},
    { colPins[5], 10, 0, " "},
    { colPins[4], 12, 0, "0123456789"}
  },
};
// ---------------------------------------------------------------

bool ModemTest();

// ---------------------------------------------------------------

bool initGLCD() {  
  if ( display.begin(KS0108_CS_ACTIVE_HIGH) == false ) {
    Serial.println( F("display initialization failed!") );    // lack of RAM space
    return false;
  }  
  
  display.clearDisplay();           // Clear the buffer
  display.setTextSize(1);           // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON);  // Draw white text
  display.setCursor(0, 0);          // Start at top-left corner
  display.cp437(true);              // Use full 256 char 'Code Page 437' font
  display.setTextWrap(true);        // Set whether text should wrap around (else clip right).
  //display.setFont(&Picopixel);
  display.display();
  delay(1000);
  
  display.println("READY.");
  display.display();
  delay(1000);
  
  return true;
}
// ---------------------------------------------------------------


void setup() {
  
  for (int i = 0; i < row_N; i++)
    pinMode(rowPins[i], OUTPUT),
    gpio_set_slew_rate( rowPins[i], GPIO_SLEW_RATE_SLOW ),
    digitalWrite(rowPins[i], HIGH);
  
  for (int i = 0; i < col_N; i++)
    pinMode(colPins[i], INPUT_PULLUP);

  // - - - - - - - - - - - - - - - - - 

  delay(1000);
  Serial.begin(9600);
  
  #ifdef DEBUG
    while (!Serial);
  #endif
  
  #ifdef USE_DISPLAY
    for (int i = 26; i < 28; i++)
      gpio_init(i), 
      gpio_set_dir(i, GPIO_OUT),
      gpio_put(i, 0);

    glcd_on = initGLCD();
    Serial.print("GLCD: "), Serial.println(glcd_on);
  #endif

  #ifdef USE_MODEM
    Modem.setTX(0);
    Modem.setRX(1);
    Modem.begin(9600);
    //Modem.setTimeout(10000);
    //while (!Modem && millis()<5000);
    delay(2000);

    //online = ModemTest(); delay(2000);
    //Serial.print("online: "),Serial.println(online);
  
  #endif

  memset(buf_input, 0, sizeof(buf_input));
  
  kp_last_press = millis();


  /*
  while (1) {
    display.clearDisplay(); 
    display.setCursor(0, 0); 
    
    for (int i= 0; i<30; i++) {
      display.printf("text %d\n", random(0, 255));
      //if (display.getCursorY() >= display.height()) display.pushUp(8), display.display(), display.setCursor(0, (display.height()-8)); 
      delay(500);
    }
    delay(2000);
  }
  */
}
// ---------------------------------------------------------------

bool ModemTest() {
  unsigned long T;
  uint8_t i = 0;
  char resp[32];
    
  memset(resp, 0, sizeof(resp));
    
  Modem.println("AT");
  T = millis();
  
  while ((millis()-T)<5000) {
    if (Modem.available()) {
      char c = Modem.read();
      
      if (c == '\n' || c == '\r') {
        if (strcmp(resp, "OK") == 0) 
            return true;

        memset(resp, 0, sizeof(resp)), i = 0;
      } 
      else if (i < (sizeof(resp)-1)) {
          resp[i++] = c;
      }
      T = millis();
    }
  }
  return false;
}
// ---------------------------------------------------------------

Map *readKeyPad() {
  for (uint8_t row = 0; row < 4; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = matrix[row][col].pin;
      uint8_t key = matrix[row][col].key;  
      
      if (digitalRead(col_pin) == LOW) {
        if ((millis()-kp_last_press) > DEBOUNCE && key != 12) {
          while (digitalRead(col_pin) == LOW); 
          digitalWrite(rowPins[row], HIGH);
          kp_last_press = millis();
          
          return &(matrix[row][col]);
        }
      }
    }
    digitalWrite(rowPins[row], HIGH);
  }
  return nullptr;
}
// ---------------------------------------------------------------

void t9_reset() {
  for (uint8_t x = 0; x < 4; x++) 
    for (uint8_t y = 0; y < 3; y++) 
      matrix[x][y].index = 0;
}
// ---------------------------------------------------------------

void checkInput() {
  int16_t curSym = 219;
  uint8_t key, index;
  char c;
  
  Map *obj = readKeyPad();
  
  if (obj != NULL) {
    key = obj->key;

    if (obj->index < 1) {
      if (buf_input[buf_index] != '\0' && key < 10)
        buf_index++;
      else if (key == 10) 
        curSym = 177;
        
      t9_reset();
    } else {
      if (key == 10) 
        buf_index++;
    }
    
    if (key == 11) {
      buf_input[buf_index] = '\0';
      if (buf_index > 0) buf_index--;
    }

    index = obj->index % strlen(obj->t9_page);
    
    if (strlen(obj->t9_page) > 0) {
      c = obj->t9_page[index];        
      if (!(key == 10 && obj->index == 0)) 
        buf_input[buf_index] = c;
        
      obj->index++;
    }

    Serial.print("> "), Serial.println(buf_input);
    
    display.clearDisplay();
    display.setCursor(0,0);
    display.print("> ");
    display.print(buf_input);
    display.write(curSym);
    display.write('\n');
    display.display();
    delay(100);
  }
}
// ---------------------------------------------------------------

void ModemSend(const char* cmd) {
  unsigned long T = millis();
    
  Modem.println(cmd);
  
  while ((millis()-T)<5000) {
    if (Modem.available()) {
      char c = Modem.read();
      Serial.print(c);
      display.write(c); display.display();

      /*
      if (display.getCursorY() >= display.height()) { 
        display.pushUp(8); display.display(); 
        display.setCursor(0, (display.height()-8)); 
      }
      */
      T = millis();
    }
  }
}

void loop()  {
  unsigned long bs_timer;
  
  if (BOOTSEL) {
    bs_timer = millis();
    
    while (BOOTSEL); //yield();
      //if ((millis()-bs_timer)>3000) rp2040.reboot();

    if (strlen(buf_input) > 0) {
      Serial.print("Sending command: '"), Serial.print(buf_input), Serial.println("'");

      display.clearDisplay();
      display.setCursor(0,0);

      if (strcmp(buf_input, "DIAL") == 0 || strcmp(buf_input, "dial") == 0) {
        display.println("Dialing.."); display.display(); delay(2000);
        online = ModemTest();
        display.println((online)?"Modem responded!":"No answer..."); display.display();
      }
      else
      if (strcmp(buf_input, "REBOOT") == 0 || strcmp(buf_input, "reboot") == 0) {
        display.println("Rebooting."); display.display(); delay(2000);
        rp2040.reboot();
      } 
      else {
        display.println("Sending command.."); display.display(); delay(1000);

        //if (ModemTest())
        ModemSend(buf_input);
        
        delay(2000);
      }
    }
    memset(buf_input, 0, sizeof(buf_input));
    t9_reset();
    buf_index = 0;
  }
  else {
    checkInput();
  }  
}
