#include <Arduino.h> 
#include <stdio.h>
#include <pico/stdlib.h>
#include "pico/multicore.h"
#include <hardware/gpio.h>
#include <hardware/uart.h>
#include <Adafruit_GFX.h>   // include adafruit GFX library
#include "KS0108_GLCD.h"    // include KS0108 GLCD library
#include <Fonts/Picopixel.h>

#include "LoPiPhone.h"

#define DEBUG
//#define USE_MODEM

//#define Modem         Serial1
#define DEBOUNCE      50


bool online;
bool glcd_on;

const uint8_t row_N = 4;
const uint8_t col_N = 6;
unsigned long kp_last_press;

KS0108_GLCD display = KS0108_GLCD(
  22, // -> LCD 4  ( RS )
  20, // -> LCD 6  ( E )
  21, // -> LCD 7  ( D0 )
  19, // -> LCD 8  ( D1 )
  18, // -> LCD 8  ( D2 )
  17, // -> LCD 10 ( D3 )
  16, // -> LCD 11 ( D4 )
  27, // -> LCD 12 ( D5 )
  26, // -> LCD 13 ( D6 )
  5,  // -> LCD 14 ( D7 )
  4,  // -> LCD 15 ( CS1 )
  3,  // -> LCD 16 ( CS2 )
  2   // -> LCD 17 ( RES )
);

uint8_t rowPins[row_N] = {
  14, // -> KP 2  ( R1 )
  11, // -> KP 5  ( R2 )
  9,  // -> KP 7  ( R3 )
  8   // -> KP 8  ( R4 )
};

uint8_t colPins[col_N] = {
  15, // -> KP 1  ( C1 )
  13, // -> KP 3  ( C2 )
  12, // -> KP 4  ( C3 )
  10, // -> KP 6  ( C4 )
  7,  // -> KP 9  ( C5 )
  6   // -> KP 10 ( C6 )
}; 


char    c_last;
char    buf_input[256];
uint8_t buf_index;

struct Map {
  uint8_t     pin;
  uint8_t     key;
  int16_t     index;
  const char* t9_page;
};

Map matrix[4][3] = {
  {
    { colPins[0], 1, 0, ".,!?:;_-+=*/'\"%$&#@(){}[]"},
    { colPins[2], 2, 0, "abcABC"},
    { colPins[1], 3, 0, "defDEF"},
  },
  {
    { colPins[0], 4, 0, "ghiGHI"},
    { colPins[2], 5, 0, "jklJKL"},
    { colPins[3], 6, 0, "mnoMNO"}
  },
  {
    { colPins[0], 7, 0, "pqrsPQRS"},
    { colPins[2], 8, 0, "tuvTUV"},
    { colPins[3], 9, 0, "wxyzWXYZ"}
  },
  {
    { colPins[2], 10, 0, ""},
    { colPins[5], 11, 0, " "},
    { colPins[4], 12, 0, ""}
  },
};
// ---------------------------------------------------------------

bool ModemTest();
bool initGLCD();
bool WaitForResponse();

// ---------------------------------------------------------------

const char *number = "+4592906275";
const char *number2 = "+4560559273";
int MemoryWriteLocation = 1;

// ---------------------------------------------------------------

void setup() {
  pinMode(modemResetPin, OUTPUT);

  for (int i = 0; i < row_N; i++)
    pinMode(rowPins[i], OUTPUT),
    gpio_set_slew_rate( rowPins[i], GPIO_SLEW_RATE_SLOW ),
    digitalWrite(rowPins[i], HIGH);
  
  for (int i = 0; i < col_N; i++)
    pinMode(colPins[i], INPUT_PULLUP);

  // - - - - - - - - - - - - - - - - - 
    
  delay(1000);
  Serial.begin(9600);
  
  #ifdef DEBUG
    while (!Serial);
  #endif
  
  // - - - - - - - - - - - - - - - - - 

  glcd_on = initGLCD();

  display.clearDisplay(); 
  display.setCursor(0, 0); 
  display.display();
  
  // - - - - - - - - - - - - - - - - - 

  Modem::init();
  
  bool online = Modem::handshake(true);
  Serial.print("online: "), Serial.println(online);

  Modem::T = millis();
  while ((millis()-Modem::T) < 5000) {
    if (modemPort.available())
      Serial.print("INFO :"),
      Serial.println(modemPort.readStringUntil('\n')),
      Modem::T = millis();
  }
  
  display.print("MODEM ");
  display.println((online)?"ONLINE":"OFFLINE");
  display.display();
  
  SIMSignal signal = Modem::signal();
  Serial.print("rssi:       "), Serial.println(signal.rssi);
  Serial.print("error rate: "), Serial.println(signal.bit_error_rate);


  //String sms = Modem::readSMS(); Serial.println("\nSMS: "), Serial.println(sms);
  
  memset(buf_input, 0, sizeof(buf_input));
  kp_last_press = millis();
}
// ---------------------------------------------------------------

bool initGLCD() {  
  if ( display.begin(KS0108_CS_ACTIVE_HIGH) == false ) 
    return false;
  
  display.clearDisplay();           // Clear the buffer
  display.setTextSize(1);           // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON);  // Draw white text
  display.setCursor(0, 0);          // Start at top-left corner
  display.cp437(true);              // Use full 256 char 'Code Page 437' font
  display.setTextWrap(true);        // Set whether text should wrap around (else clip right).
  //display.setFont(&Picopixel);
  display.display();
  delay(1000);

  /*
  display.println("READY.");
  display.display();
  delay(1000);*/
  
  return true;
}
// ---------------------------------------------------------------

Map *readKeyPad() {
  for (uint8_t row = 0; row < 4; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = matrix[row][col].pin;
      uint8_t key = matrix[row][col].key;  
      
      if (digitalRead(col_pin) == LOW) {
        //if ((millis()-kp_last_press) > DEBOUNCE && key != 12) {
        if (millis()-kp_last_press) {
          while (digitalRead(col_pin) == LOW); 
          digitalWrite(rowPins[row], HIGH);
          kp_last_press = millis();
          
          return &(matrix[row][col]);
        }
      }
    }
    digitalWrite(rowPins[row], HIGH);
  }
  return nullptr;
}
// ---------------------------------------------------------------

void t9_reset() {
  for (uint8_t x = 0; x < 4; x++) 
    for (uint8_t y = 0; y < 3; y++) 
      matrix[x][y].index = 0;
}
// ---------------------------------------------------------------

void checkInput() {
  int16_t curSym = 219;
  uint8_t key, index;
  char c;
  
  Map *obj = readKeyPad();
  
  if (obj != NULL) {
    key = obj->key;

    if (obj->index < 1) {
      if (buf_input[buf_index] != '\0')
        buf_index = (key != 10 && key != 12) ? buf_index + 1 : buf_index;
      t9_reset();
    } 
    else {
      if (key > 10)  
        buf_index++;
    }
    
    if (key == 10) {
      buf_input[buf_index] = '\0';
      buf_index = (buf_index > 0) ? buf_index - 1 : 0;
    }
    //if (key == 12) buf_index++;
      
    index = obj->index % strlen(obj->t9_page);
    
    if (strlen(obj->t9_page) > 0) {
      buf_input[buf_index] = obj->t9_page[index];
      obj->index++;
    }

    display.clearDisplay();
    display.setCursor(0,0);
    display.print("> ");
    display.print(buf_input);
    display.write(curSym);
    display.write('\n');
    display.display();
    delay(100);
  }
}
// ---------------------------------------------------------------

char *str_parts(char *str, bool last=1, const char* delim = " ") {
  return (last) ? ( strchr(str,delim[0]) ? strchr(str,delim[0])+1 : str ) : strtok(str, delim);
}
// ---------------------------------------------------------------

void loop()  {
  unsigned long bs_timer;
  
  if (BOOTSEL) {
    bs_timer = millis();
    
    while (BOOTSEL); //yield();
      //if ((millis()-bs_timer)>3000) rp2040.reboot();

    if (strlen(buf_input) > 0) {
      char *val = str_parts(buf_input, 1, " ");
      char *key = str_parts(buf_input, 0, " ");

      if (strcmp(key, "AT") == 0 || strcmp(key, "at") == 0) {
        display.println("Dialing.."); 
        display.display(); 
        delay(2000);    
      }
      else {
        display.println("Sending command.."); 
        display.display(); 
        delay(3000);
      }
      
      display.clearDisplay(); 
      display.setCursor(0, 0); 
      display.print("> ");
      display.display();
    }
    memset(buf_input, 0, sizeof(buf_input));
    t9_reset();
    buf_index = 0;
  }
  else {
    checkInput();
    Modem::comm();
    /*
    if ((millis()-Modem::T) > 5000) {
      modemPort.print("AT+CMGS=\"+4592906275\"\rHELLO THERE FOOKIN!");
      modemPort.write(26);
      WaitForResponse();
      Modem::T = millis();
    }
    */
  }  
}
// ---------------------------------------------------------------

bool WaitForResponse()
{
  unsigned long startTime = millis();
  while (millis() - startTime < 5000)
  {
    String reply = modemPort.readStringUntil('\n');
    if (reply.length() > 0)
    {
      Serial.print("Received: \"");
      Serial.print(reply);
      Serial.println("\"");
      if (reply.startsWith("+CMGW:"))
      {
        reply.remove(0, 6); // Strip off "+CMGW:"
        MemoryWriteLocation = reply.toInt();
      }
      if (reply.startsWith("OK"))
        return true;
      if (reply.startsWith("ERROR"))
        return false;
    }
  }
  Serial.println("Did not receive OK.");
  return false;
}
