// When the Pico is running in single core mode, core 0 has the full 8KB of stack space available to it. 
// When using multicore setup1/loop1 the 8KB is split into two 4K stacks, one per core. 
// It is possible for core 0’s stack to overwrite core 1’s stack in this case, if you go beyond the 4K limitation.
//
// To allocate a separate 8K stack for core 1, resulting in 8K stacks being available for both cores, 
// simply define the following variable in your sketch and set it to true
bool core1_separate_stack = true;

//Multicore functions
//Pause Other Core
void pauseOtherCore(){
  rp2040.idleOtherCore();
}
//Resume Other Core
void resumeTheOtherCore(){
  rp2040.resumeOtherCore();
}
//Restart Core1
void restartCore(){
  rp2040.restartCore1();
}
//Send data to other core via FIFO
bool sendToOtherCore(uint32_t data){
  return rp2040.fifo.push_nb(data);
}


#include <coreCommunication.h>

//Multicore functions
//Pause Other Core
void coreCommunication::pauseOtherCore(){
  rp2040.idleOtherCore();
}
//Resume Other Core
void coreCommunication::resumeTheOtherCore(){
  rp2040.resumeOtherCore();
}
//Restart Core1
void coreCommunication::restartCore(){
  rp2040.restartCore1();
}
//Send data to other core via FIFO
bool coreCommunication::sendToOtherCore(uint32_t data){
  return rp2040.fifo.push_nb(data);
}

#define DEBUG       // DEBUG allows for debugging information to be printed

#ifdef DEBUG
  #define VERBOSE   // If VERBOSE, DEBUG information includes 'Starting function()' and 'function() completed'
#endif


// heartBeat flashes onboard LED to show Pico W is operating
unsigned long heartBeatTime = millis(); // Time to make onboard LED flash when running
bool heartBeatState = true; // Onboard LED state


#ifdef DEBUG
  int countCore0 = 0;
  int countCore1 = 0;
  String stringCore0;
  String stringCore1;
#endif


void setup()
{
  #ifdef DEBUG
    Serial.begin(115200); // For communications to PC
    rp2040.idleOtherCore(); // Allow delay to affect both cores, to ensure stable synchronisation from start
    delay(10000);
    rp2040.resumeOtherCore();
  #endif
  
  #ifdef VERBOSE
    stringCore0 += "\n\r*** setup() started!";
  #endif

  pinMode(LED_BUILTIN, OUTPUT); // for heartBeat

  #ifdef VERBOSE
    stringCore0 += "\n\r*** setup() completed!";
  #endif
}

void setup1()
{
  #ifdef VERBOSE
    stringCore1 += "\n\r*** setup1() started!";
  #endif

  #ifdef VERBOSE
    stringCore1 += "\n\r*** setup1() completed!";
  #endif
}

void loop()
{
  #ifdef VERBOSE
    stringCore0 += "\n\rStarting loop()";
    countCore0++;
    stringCore0 += "\n\r   loop() count = " + String(countCore0);
  #endif

  heartBeat();

  #ifdef DEBUG
    printData();
  #endif

  #ifdef VERBOSE
    stringCore0 += "\n\rloop() completed!\n\r";
  #endif
}

void loop1()
{
  #ifdef VERBOSE
    stringCore1 += "\n\rStarting loop1()";
  #endif
  
  countCore1++;
  stringCore1 += "\n\r   loop1() count = " + String(countCore1);

  #ifdef VERBOSE
    stringCore1 += "\n\rloop1() completed!\n\r";
  #endif
}

void heartBeat()
{
  digitalWrite(LED_BUILTIN, heartBeatState);
  if (heartBeatTime < millis())
  {
    heartBeatState = !heartBeatState; // Change state
    heartBeatTime = millis() + 1000; // Update to 1 second from now
  }
}


void printData() // Called from Core0
{
  // Pause the other core (Core 1), copy stringCore1, clear stringCore1, then resume other core (Core 1)
  //rp2040.idleOtherCore();
  String copyOfstringCore1 = stringCore1;
  stringCore1 = "";
  //rp2040.resumeOtherCore();

  Serial.print(stringCore0);
  stringCore0 = "";
  Serial.print(copyOfstringCore1);
  copyOfstringCore1 = "";
}
