
#include <Arduino.h>
#include <stdio.h>
#include <pico/stdlib.h>
#include <hardware/gpio.h>

//#include <LittleFS.h>

#if defined(USE_TINYUSB)
  #include <Adafruit_TinyUSB.h>
#elif defined(CFG_TUSB_MCU)
  #error Incompatible USB stack. Select Adafruit TinyUSB in Tools menu. 
#endif
  
#include <TinyUSB_Devices.h>
#include <Adafruit_GFX.h>   // include adafruit GFX library
#include "KS0108_GLCD.h"    // include KS0108 GLCD library
#include <Fonts/Picopixel.h>
#include <Fonts/Tiny3x3a2pt7b.h>
#include <Fonts/Org_01.h>

//#define DEBUG
#define DEBOUNCE        50

#define MANUFACTURER    "data_dogenigt"
#define DEVICE_NAME     "LoPi-Phone v1.0"
#define DEVICE_VID      0x0920
#define DEVICE_PID      0x1986

#define ArrLen(x)       (sizeof(x)/sizeof(x[0]))

bool online;
bool glcd_on;

const uint8_t row_N = 4;
const uint8_t col_N = 6;
unsigned long kp_last_press;

KS0108_GLCD display = KS0108_GLCD(
  22, // -> LCD 4  ( RS )
  20, // -> LCD 6  ( E )
  21, // -> LCD 7  ( D0 )
  19, // -> LCD 8  ( D1 )
  18, // -> LCD 8  ( D2 )
  17, // -> LCD 10 ( D3 )
  16, // -> LCD 11 ( D4 )
  27, // -> LCD 12 ( D5 )
  26, // -> LCD 13 ( D6 )
  5,  // -> LCD 14 ( D7 )
  4,  // -> LCD 15 ( CS1 )
  3,  // -> LCD 16 ( CS2 )
  2   // -> LCD 17 ( RES )
);

uint8_t rowPins[row_N] = {
  14, // -> KP 2  ( R1 )
  11, // -> KP 5  ( R2 )
  9,  // -> KP 7  ( R3 )
  8   // -> KP 8  ( R4 )
};

uint8_t colPins[col_N] = {
  15, // -> KP 1  ( C1 )
  13, // -> KP 3  ( C2 )
  12, // -> KP 4  ( C3 )
  10, // -> KP 6  ( C4 )
  7,  // -> KP 9  ( C5 )
  6   // -> KP 10 ( C6 )
}; 

char    buf_input[256];
uint8_t buf_index;

struct Map {
  uint8_t     pin;
  uint8_t     key;
  int16_t     index;
  const char* t9_page;
};

Map matrix[4][3] = {
  {
    { colPins[0], 1, 0, ".,!?:;_-+=*/'\"%$&#@(){}[]"},
    { colPins[2], 2, 0, "abcABC"},
    { colPins[1], 3, 0, "defDEF"},
  },
  {
    { colPins[0], 4, 0, "ghiGHI"},
    { colPins[2], 5, 0, "jklJKL"},
    { colPins[3], 6, 0, "mnoMNO"}
  },
  {
    { colPins[0], 7, 0, "pqrsPQRS"},
    { colPins[2], 8, 0, "tuvTUV"},
    { colPins[3], 9, 0, "wxyzWXYZ"}
  },
  {
    { colPins[2], 10, 0, ""},
    { colPins[5], 11, 0, " "},
    { colPins[4], 12, 0, ""}
  },
};

//File file;

/* ------------------------------------------------- */

bool initGLCD() {  
  if ( display.begin(KS0108_CS_ACTIVE_HIGH) == false ) 
    return false;
  
  display.clearDisplay();           // Clear the buffer
  display.setTextSize(1);           // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON);  // Draw white text
  display.setCursor(0, 0);          // Start at top-left corner
  display.cp437(true);              // Use full 256 char 'Code Page 437' font
  display.setTextWrap(true);        // Set whether text should wrap around (else clip right).
  //display.setFont(&Picopixel);
  display.display();
  
  return true;
}
/* ------------------------------------------------- */

void setup() {
  delay(1000);
  Serial.begin(9600);
  //LittleFS.begin();

  #ifdef DEBUG
    while (!Serial);
  #endif
  Serial.println("READY");

  // - - - - - - - - - - - - - - - - - - - - - - - - - -

  for (int i = 0; i < row_N; i++)
    pinMode(rowPins[i], OUTPUT),
    gpio_set_slew_rate( rowPins[i], GPIO_SLEW_RATE_SLOW ),
    digitalWrite(rowPins[i], HIGH);
  
  for (int i = 0; i < col_N; i++)
    pinMode(colPins[i], INPUT_PULLUP);

  // - - - - - - - - - - - - - - - - - - - - - - - - - -
  
  glcd_on = initGLCD();

  
  // - - - - - - - - - - - - - - - - - - - - - - - - - -

  TinyUSBDevice.setManufacturerDescriptor(MANUFACTURER);
  TinyUSBDevice.setProductDescriptor(DEVICE_NAME);
  TinyUSBDevice.setID(DEVICE_VID, DEVICE_PID);
  
  TinyUSBDevices.begin(1);
  delay(1000);
  //while(!USBDevice.mounted()) yield();
  Keyboard.releaseAll();
  delay(1);

  // - - - - - - - - - - - - - - - - - - - - - - - - - -


  display.println("BOOTING..");
  display.display();

  // - - - - - - - - - - - - - - - - - - - - - - - - - -
  
  memset(buf_input, 0, sizeof(buf_input));
  kp_last_press = millis();
}
/* ------------------------------------------------- */

void loop() {
  if (BOOTSEL) {
    if (strlen(buf_input) > 0) 
      sendCmd(buf_input);
  }
  else {
    checkInput();
  }
}

// --------------------------------------------------------------- hej


void sendCmd(const char* cmd) {
  #ifdef DEBUG
    Serial.print("cmd: ");
    Serial.println(cmd);
  #endif
  
  Keyboard.println(cmd); 
  delay(100);
  Keyboard.releaseAll();
  
  memset(buf_input, 0, sizeof(buf_input));
  buf_index = 0;
  t9_reset();

  display.clearDisplay();
  display.setCursor(0, 0);
  display.print("> ");
  display.display();
    
  delay(100);
  
  kp_last_press = millis();  
}
// ---------------------------------------------------------------

Map *readKeyPad() {
  for (uint8_t row = 0; row < 4; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = matrix[row][col].pin;
      uint8_t key = matrix[row][col].key;  
      
      if (digitalRead(col_pin) == LOW) {
        if (millis()-kp_last_press) {
          while (digitalRead(col_pin) == LOW); 
          digitalWrite(rowPins[row], HIGH);
          kp_last_press = millis();
          
          return &(matrix[row][col]);
        }
      }
    }
    digitalWrite(rowPins[row], HIGH);
  }
  return nullptr;
}
// ---------------------------------------------------------------

void t9_reset() {
  for (uint8_t x = 0; x < 4; x++) 
    for (uint8_t y = 0; y < 3; y++) 
      matrix[x][y].index = 0;
}
// ---------------------------------------------------------------

void checkInput() {
  int16_t curSym = 219;
  uint8_t key, index;
  char c;
  
  Map *obj = readKeyPad();
  
  if (obj != NULL) {
    key = obj->key;

    if (obj->index < 1) {
      if (buf_input[buf_index] != '\0')
        buf_index = (key != 10 && key != 12) ? buf_index + 1 : buf_index;
      t9_reset();
    } 
    else {
      if (key > 10)  
        buf_index++;
    }
    
    if (key == 10) {
      buf_input[buf_index] = '\0';
      buf_index = (buf_index > 0) ? buf_index - 1 : 0;
    }

    index = obj->index % strlen(obj->t9_page);
    
    if (strlen(obj->t9_page) > 0) {
      buf_input[buf_index] = obj->t9_page[index];
      obj->index++;
    }

    display.clearDisplay();
    display.setCursor(0,0);
    display.print("> ");
    display.display();
      
    //display.print(buf_input);
    //display.write(curSym);
    //display.write('\n');
    //display.display();
    delay(100);
  }
}
// ---------------------------------------------------------------


/*
void loop() {
  bool key_held = false;
  
  for (uint8_t row = 0; row < row_N; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = matrix[row][col].pin;
      
      if (digitalRead(col_pin) == LOW) {
        if ((millis()-kp_last_press) > KP_DEBOUNCE) {
          digitalWrite(LED_BUILTIN, HIGH);
          
          Serial.println(matrix[row][col].key);
            
          kp_last_press = millis();
          last_bgl_on   = millis();

          while (digitalRead(col_pin) == LOW) {
            if ((millis()-kp_last_press) > KP_HOLD_TIME) {
              digitalWrite(LED_BUILTIN, !digitalRead(LED_BUILTIN)), delay(30);
              key_held = true;
            }
          }
          
          if (key_held)
            keyHeld(&(matrix[row][col]));
          else {
            if (UI == mode_write)
               t9_getChar(&(matrix[row][col]));
            if (UI == mode_read)
              kp_last_key = matrix[row][col].key;
          }
           

          digitalWrite(LED_BUILTIN, LOW);     
        }
      }
    }
    digitalWrite(rowPins[row], HIGH);
  }
  digitalWrite(BGL_PIN, ((millis()-last_bgl_on) < BGL_TIMEOUT));
}
*/

/* ------------------------------------------------- */
