/*
KEYPAD     ARDUINO
 pin 1  ->  pin 6
 pin 2  ->  pin 7
 pin 3  ->  pin 8
 pin 4  ->  pin 9
 pin 5  ->  pin 14
 pin 6  ->  pin 15
 pin 7  ->  pin 10
 pin 8  ->  pin 11
 pin 9  ->  pin 12
 pin 10 ->  pin 13
 
*/

#include <Arduino.h>
#include <stdio.h>
#include <pico/stdlib.h>

#if defined(USE_TINYUSB)
  #include <Adafruit_TinyUSB.h>
#elif defined(CFG_TUSB_MCU)
  #error Incompatible USB stack. Select Adafruit TinyUSB in Tools menu. 
#endif
  
#include <TinyUSB_Devices.h>
#include "includes.h"



#define ArrLen(x)  (sizeof(x)/sizeof(x[0]))
#define prnt        Serial.print
#define prntln      Serial.println

const uint8_t row_N = 4;
const uint8_t col_N = 6;

uint8_t rowPins[row_N] = {7, 14, 10, 11};
uint8_t colPins[col_N] = {6, 8, 9, 15, 12, 13};

enum : int { R1, R2, R3, R4 };
enum : int { C1, C2, C3 };

struct Map {
  uint8_t pin;
  char    symbol;
  short   key;
}
Matrix[4][3] = {
  {
    { colPins[0], '7', HID_KEY_KEYPAD_7 },
    { colPins[2], '8', HID_KEY_KEYPAD_8 },
    { colPins[1], '9', HID_KEY_KEYPAD_9 },
  },
  {
    { colPins[0], '4', HID_KEY_KEYPAD_4 },
    { colPins[2], '5', HID_KEY_KEYPAD_5 },
    { colPins[3], '6', HID_KEY_KEYPAD_6 },
  },
  {
    { colPins[0], '1', HID_KEY_KEYPAD_1 },
    { colPins[2], '2', HID_KEY_KEYPAD_2 },
    { colPins[3], '3', HID_KEY_KEYPAD_3 },
  },
  {
    { colPins[2], '0', HID_KEY_BACKSPACE },
    { colPins[5], '*', HID_KEY_SPACE },
    { colPins[4], '#', HID_KEY_ENTER },
  },
};
/*
Matrix[4][3] = {
  {'7','8','9'}, // R0
  {'4','5','6'}, // R1
  {'1','2','3'}, // R2
  {'0','*','#'}  // R3
};//C1, C2, C3
*/

uint8_t matrix[4][3] = {
  { colPins[0], colPins[2], colPins[1] },
  { colPins[0], colPins[2], colPins[3] },
  { colPins[0], colPins[2], colPins[3] },
  { colPins[2], colPins[5], colPins[4] } 
};

char keymap[4][3] = {
  {'7','8','9'},
  {'4','5','6'},
  {'1','2','3'},
  {'0','*','#'}
};

/* ------------------------------------------------- */

void setup() {
  Serial.begin(9600);

  TinyUSBDevice.setManufacturerDescriptor(MANUFACTURER_NAME);
  TinyUSBDevice.setProductDescriptor(DEVICE_NAME);
  TinyUSBDevice.setID(DEVICE_VID, DEVICE_PID);
  
  TinyUSBDevices.begin(2);
  
  while(!USBDevice.mounted()) yield();
  
  Keyboard.releaseAll(); delay(1);

  delay(1000);
}

/*
void loop() {
  while (!Serial.available());
  String msg = Serial.readStringUntil('\n');
  Serial.print("received: "), Serial.println(msg);
  Keyboard.press(HID_KEY_A); delay(250);
  Keyboard.release(HID_KEY_A);
}
*/
void loop() {
  // check for incoming serial data:
  if (Serial.available() > 0) {
    // read incoming serial data:
    char inChar = Serial.read();
    // Type the next ASCII value from what you received:
    Keyboard.write(inChar + 1);
  }
}

void setup1() {
  int i;

  pinMode(LED_BUILTIN, OUTPUT);
  digitalWrite(LED_BUILTIN, LOW);
  
  for (i = 0; i < row_N; i++)
    pinMode(rowPins[i], OUTPUT),
    digitalWrite(rowPins[i], HIGH);
  
  for (i = 0; i < col_N; i++)
    pinMode(colPins[i], INPUT_PULLUP);

  delay(2000);
  Serial.println("READY.");
}


void loop1() {
  for (uint8_t row = 0; row < row_N; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = matrix[row][col];

      if (digitalRead(col_pin) == LOW) {
        Serial.print(F("pressing ")), Serial.println(keymap[row][col]);
        while (digitalRead(col_pin) == LOW); delay(20);
      }
    }
    digitalWrite(rowPins[row], HIGH);
    delay(10);
  }
}
