#include <Arduino.h>

#define DEBUG true

#if defined(USE_TINYUSB)
  #include <Adafruit_TinyUSB.h>
#elif defined(CFG_TUSB_MCU)
  #error Incompatible USB stack. Use Adafruit TinyUSB.
#endif

#include <TinyUSB_Devices.h>

#define MANUFACTURER    "data_dogenigt"
#define DEVICE_NAME     "LoPi-Phone v1.0"
#define DEVICE_VID      0x0920
#define DEVICE_PID      0x1986


void setup() {
  //delay(1000);
  Serial.begin(9600);

  TinyUSBDevice.setManufacturerDescriptor(MANUFACTURER);
  TinyUSBDevice.setProductDescriptor(DEVICE_NAME);
  TinyUSBDevice.setID(DEVICE_VID, DEVICE_PID);
  TinyUSBDevices.begin(2);

  while(!USBDevice.mounted()) { yield(); }
  
  Keyboard.releaseAll();
  delay(1);
  
}

void setup1() {
  pinMode(LED_BUILTIN, OUTPUT);
  
  #if DEBUG
    while (!Serial && millis()<10000UL) 
      digitalWrite(LED_BUILTIN, !digitalRead(LED_BUILTIN)),
      delay(250);
  #endif
}

void loop() {
  yield();
}

void loop1() {
   if (Serial.available() > 0) {
    String s = Serial.readStringUntil('\n');
    Keyboard.println(s);
   }
}
