#include <Arduino.h>
#include <stdio.h>
#include <pico/stdlib.h>
#include <hardware/gpio.h>

#define DEBUG true

#if defined(USE_TINYUSB)
  #include <Adafruit_TinyUSB.h>
#elif defined(CFG_TUSB_MCU)
  #error Incompatible USB stack. Use Adafruit TinyUSB.
#endif

#include <TinyUSB_Devices.h>
#include <Adafruit_GFX.h>   // include adafruit GFX library
#include "KS0108_GLCD.h"    // include KS0108 GLCD library
//#include <Fonts/Picopixel.h>
//#include <Fonts/Tiny3x3a2pt7b.h>
//#include <Fonts/Org_01.h>

#define MANUFACTURER    "data_dogenigt"
#define DEVICE_NAME     "LoPi-Phone v1.0"
#define DEVICE_VID      0x0920
#define DEVICE_PID      0x1986

KS0108_GLCD display = KS0108_GLCD(
  22, // -> LCD 4  ( RS )
  20, // -> LCD 6  ( E )
  21, // -> LCD 7  ( D0 )
  19, // -> LCD 8  ( D1 )
  18, // -> LCD 8  ( D2 )
  17, // -> LCD 10 ( D3 )
  16, // -> LCD 11 ( D4 )
  27, // -> LCD 12 ( D5 )
  26, // -> LCD 13 ( D6 )
  5,  // -> LCD 14 ( D7 )
  4,  // -> LCD 15 ( CS1 )
  3,  // -> LCD 16 ( CS2 )
  2   // -> LCD 17 ( RES )
);

void setup() {
  //delay(1000);
  Serial.begin(9600);

  TinyUSBDevice.setManufacturerDescriptor(MANUFACTURER);
  TinyUSBDevice.setProductDescriptor(DEVICE_NAME);
  TinyUSBDevice.setID(DEVICE_VID, DEVICE_PID);
  TinyUSBDevices.begin(2);

  while(!USBDevice.mounted()) { yield(); }
  
  Keyboard.releaseAll();
  delay(1);
  
}
// ---------------------------------------------------------

void loop() {
   if (Serial.available() > 0) {
    String s = Serial.readStringUntil('\n');
    Serial.print("writing '"); Serial.print(s); Serial.println("'");
    delay(1000);
    Keyboard.println(s);
   }
}
// ---------------------------------------------------------


bool initGLCD() {  
  if ( display.begin(KS0108_CS_ACTIVE_HIGH) == false ) 
    return false;
  
  display.clearDisplay();           // Clear the buffer
  display.setTextSize(1);           // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON);  // Draw white text
  display.setCursor(0, 0);          // Start at top-left corner
  display.cp437(true);              // Use full 256 char 'Code Page 437' font
  display.setTextWrap(true);        // Set whether text should wrap around (else clip right).
  //display.setFont(&Picopixel);
  display.display();
  delay(1000);

  display.println("READY");
  display.display();
  
  return true;
}
/* ------------------------------------------------- */

volatile int count;
volatile bool glcd_timer;

void setup1() {
  pinMode(LED_BUILTIN, OUTPUT);

  initGLCD();
  glcd_timer = millis();
}
// ---------------------------------------------------------

void loop1() {
  if ((millis()-glcd_timer)>10000L) {
    if (++count > (21*8)) 
      display.clearDisplay(),
      display.setCursor(0,0),
      count = 0;
      
    display.write(random(32,255));
    display.display();
    
    glcd_timer = millis();
  }
}
