#include <Arduino.h>
#include <stdio.h>
#include <pico/stdlib.h>
#include <hardware/gpio.h>

#if defined(USE_TINYUSB)
  #include <Adafruit_TinyUSB.h>
#elif defined(CFG_TUSB_MCU)
  #error Incompatible USB stack. Use Adafruit TinyUSB.
#endif

#include <TinyUSB_Devices.h>
#include <Adafruit_GFX.h>   // include adafruit GFX library
#include "KS0108_GLCD.h"    // include KS0108 GLCD library
#include "include.h"

// _________________________________________________________

void setup() {
  //delay(1000);
  Serial.begin(9600);

  TinyUSBDevice.setManufacturerDescriptor(MANUFACTURER);
  TinyUSBDevice.setProductDescriptor(DEVICE_NAME);
  TinyUSBDevice.setID(DEVICE_VID, DEVICE_PID);
  TinyUSBDevices.begin(2);

  while(!USBDevice.mounted()) { yield(); }
  
  Keyboard.releaseAll(); delay(1);
  delay(2000);
  
  rp2040.fifo.push_nb(FIFO_READY);
}
// ---------------------------------------------------------

void loop() {
  yield();
}
// _________________________________________________________


void setup1() {
  pinMode(LED_BUILTIN, OUTPUT);

  initGLCD();
  
  while (rp2040.fifo.available() == 0)
    if (rp2040.fifo.pop_nb(&fifo_msg) && fifo_msg == FIFO_READY)
      break;
  
  display.clearDisplay();
  display.setCursor(0,0);
  display.println("READY"); 
  display.display();
}
// ---------------------------------------------------------

void loop1() {
  if (Serial.available() > 0) {
    String s = Serial.readStringUntil('\n');
    Serial.print("writing '"); Serial.print(s); Serial.println("'");
    delay(1000);
    Keyboard.println(s);
  }
  else if (rp2040.fifo.available()) {
    bool received = rp2040.fifo.pop_nb(&fifo_msg);
    
    if (received) 
      Serial.print("FIFO: "),
      Serial.println(String( fifo_msg ));
  }
}
