#pragma once

//#include <Fonts/Picopixel.h>
//#include <Fonts/Tiny3x3a2pt7b.h>
//#include <Fonts/Org_01.h>

#define MANUFACTURER    "data_dogenigt"
#define DEVICE_NAME     "LoPi-Phone v1.0"
#define DEVICE_VID      0x0920
#define DEVICE_PID      0x1986

// ___________________________________________________

KS0108_GLCD display = KS0108_GLCD(
  22, // -> LCD 4  ( RS )
  20, // -> LCD 6  ( E )
  21, // -> LCD 7  ( D0 )
  19, // -> LCD 8  ( D1 )
  18, // -> LCD 8  ( D2 )
  17, // -> LCD 10 ( D3 )
  16, // -> LCD 11 ( D4 )
  27, // -> LCD 12 ( D5 )
  26, // -> LCD 13 ( D6 )
  5,  // -> LCD 14 ( D7 )
  4,  // -> LCD 15 ( CS1 )
  3,  // -> LCD 16 ( CS2 )
  2   // -> LCD 17 ( RES )
);

enum : uint32_t {
  FIFO_IDLE,
  FIFO_READY,
  FIFO_INCOMING
};

uint32_t fifo_msg;

// ___________________________________________________

bool initGLCD() {  
  if ( display.begin(KS0108_CS_ACTIVE_HIGH) == false ) 
    return false;
  
  display.clearDisplay();           // Clear the buffer
  display.setTextSize(1);           // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON);  // Draw white text
  display.setCursor(0, 0);          // Start at top-left corner
  display.cp437(true);              // Use full 256 char 'Code Page 437' font
  display.setTextWrap(true);        // Set whether text should wrap around (else clip right).
  //display.setFont(&Picopixel);
  display.display();
  delay(1000);

  display.println("BOOTING.");
  display.display();
  
  return true;
}
/* ------------------------------------------------- */
