/*
#include <Arduino.h>
#include <stdio.h>
#include <pico/stdlib.h>
#include <hardware/gpio.h>
*/
/*
#if defined(USE_TINYUSB)
  #include <Adafruit_TinyUSB.h>
#elif defined(CFG_TUSB_MCU)
  #error Incompatible USB stack. Use Adafruit TinyUSB.
#endif
#include <TinyUSB_Devices.h>
*/

#include <Adafruit_TinyUSB.h>
//#include <Adafruit_GFX.h>   // include adafruit GFX library
#include "KS0108_GLCD.h"    // include KS0108 GLCD library
#include "include.h"

// _________________________________________________________

void setup() {
  delay(1000);
  Serial.begin(9600);
  /*
  TinyUSBDevice.setManufacturerDescriptor(MANUFACTURER);
  TinyUSBDevice.setProductDescriptor(DEVICE_NAME);
  TinyUSBDevice.setID(DEVICE_VID, DEVICE_PID);
  TinyUSBDevices.begin(2);
  */
  
  pinMode(LED_BUILTIN, OUTPUT);

  for (int i = 0; i < row_N; i++)
    pinMode(rowPins[i], OUTPUT),
    gpio_set_slew_rate( rowPins[i], GPIO_SLEW_RATE_SLOW ),
    digitalWrite(rowPins[i], HIGH);
  
  for (int i = 0; i < col_N; i++)
    pinMode(colPins[i], INPUT_PULLUP);

  // - - - - - - - - - - - - - - - - - 

  initGLCD();

  //while(!USBDevice.mounted()) { yield(); }
  
  //Keyboard.releaseAll(); delay(1);
  delay(2000);
  
  rp2040.fifo.push_nb(FIFO_READY);
}
// ---------------------------------------------------------

void loop() {
  if (Serial.available() > 0) {
    buf = Serial.readStringUntil('\n'); buf.trim();
    
    if (!zero_booted) {
      zero_booted = true;
      return;
    }
    if (buf == "STDIN") {
        display.clearDisplay();
        display.setCursor(0,0);
        display.display();
        ui_mode = UI_READ;
        return;
    }
    else if (buf == "EOF") {
      delay(1000);
      checkDisplay();
      display.println("> PRESS KEY TO RETURN");
      display.display();
      ui_mode = UI_READ_DONE;
      return;
    }
    // - - - - - - - - - - - -
    
    if (ui_mode == UI_READ) {
      checkDisplay(),
      display.println(buf),
      display.display();
      delay(READ_DEL);
    }
  }
  /*
  else
  if (rp2040.fifo.available() && rp2040.fifo.pop_nb(&fifo_msg)) {
    if (fifo_msg == FIFO_SEND && strlen(buf_input)) {
      Keyboard.println(buf_input);
      memset(buf_input, 0, sizeof(buf_input));
      buf_index = 0;
      t9_reset();
    }
  }
  */
}
// _________________________________________________________


void setup1() {

  
  while (rp2040.fifo.available() == 0)
    if (rp2040.fifo.pop_nb(&fifo_msg) && fifo_msg == FIFO_READY)
      break;
  
  // - - - - - - - - - - - - - - - - - 
  
  while (!zero_booted) {
    animateGLCD(); T = millis();
    while ((millis()-T)<2000)
      if (zero_booted)
        break;
  }
  
  display.clearDisplay();
  display.setCursor(0,0);
  display.println("READY!"); 
  display.display();
  delay(2000);
  
  display.clearDisplay();
  display.setCursor(0,0);
  display.print("> "); 
  display.display();

  ui_mode = UI_READ;

  memset(buf_input, 0, sizeof(buf_input));
  kp_last_press = millis();
  
}
// ---------------------------------------------------------

void loop1() {
  if (BOOTSEL) {
    while (BOOTSEL);

    if (strlen(buf_input) > 0) {
      //Keyboard.print("run ");
      //Keyboard.println(buf_input);

      display.clearDisplay();
      display.setCursor(0,0);
      display.print("> "); 
      display.display();
      
      clearBuf();
    }
    
    /*
    if (strlen(buf_input) > 0) {
      rp2040.fifo.push_nb(FIFO_SEND);
      display.clearDisplay();
      display.setCursor(0,0);
      display.print("> "); 
      display.display();
      delay(1000);
    }
    */
  }
  else {
    if (checkInput()) {
      if (ui_mode == UI_READ_DONE) {
        ui_mode = UI_WRITE;
        clearBuf();
      }
      else {
        display.clearDisplay();
        display.setCursor(0,0);
        display.print("> ");
        display.print(buf_input);
        display.write(curSym);
        display.write('\n');
        display.display();
        delay(100);
      }
    }
  }
}
