#pragma once

#define LED_PIN         LED_BUILTIN
#define BGL_PIN         28
#define BGL_TIMEOUT     5000
#define READ_DEL        500

#define MANUFACTURER    "data_dogenigt"
#define DEVICE_NAME     "LoPi-Phone v1.0"
#define DEVICE_VID      0x0920
#define DEVICE_PID      0x1986

#ifdef USE_FONTS
  #include <Fonts/Picopixel.h>
  #include <Fonts/Tiny3x3a2pt7b.h>
  #include <Fonts/Org_01.h>
#endif

// ___________________________________________________

unsigned long bgl_timer;
unsigned long kp_last_press, T;
const uint8_t row_N = 4;
const uint8_t col_N = 6;
volatile bool zero_booted;
int16_t       curSym = 219;
String        buf;
File          file;

KS0108_GLCD display = KS0108_GLCD(
  22, // -> LCD 4  ( RS )
  20, // -> LCD 6  ( E )
  21, // -> LCD 7  ( D0 )
  19, // -> LCD 8  ( D1 )
  18, // -> LCD 8  ( D2 )
  17, // -> LCD 10 ( D3 )
  16, // -> LCD 11 ( D4 )
  27, // -> LCD 12 ( D5 )
  26, // -> LCD 13 ( D6 )
  5,  // -> LCD 14 ( D7 )
  4,  // -> LCD 15 ( CS1 )
  3,  // -> LCD 16 ( CS2 )
  2   // -> LCD 17 ( RES )
);

uint8_t rowPins[row_N] = {
  14, // -> KP 2  ( R1 )
  11, // -> KP 5  ( R2 )
  9,  // -> KP 7  ( R3 )
  8   // -> KP 8  ( R4 )
};

uint8_t colPins[col_N] = {
  15, // -> KP 1  ( C1 )
  13, // -> KP 3  ( C2 )
  12, // -> KP 4  ( C3 )
  10, // -> KP 6  ( C4 )
  7,  // -> KP 9  ( C5 )
  6   // -> KP 10 ( C6 )
}; 

char      buf_input[256];
uint8_t   buf_index;
uint8_t   ui_mode;
uint32_t  fifo_msg;

enum : boolean {
  OFF, ON
};

enum : uint32_t {
  FIFO_IDLE,
  FIFO_READY,
  FIFO_BOOTED,
  FIFO_SEND
};

enum : uint8_t {
  UI_READ,
  UI_WRITE,
  UI_STDIN,
  UI_STDIN_DONE
};

struct Map {
  uint8_t     pin;
  uint8_t     key;
  int16_t     index;
  const char* t9_page;
};

Map matrix[4][3] = {
  {
    { colPins[0], 1, 0, ".,!?:;_-+=*/'\"%$&#@(){}[]"},
    { colPins[2], 2, 0, "abcABC"},
    { colPins[1], 3, 0, "defDEF"},
  },
  {
    { colPins[0], 4, 0, "ghiGHI"},
    { colPins[2], 5, 0, "jklJKL"},
    { colPins[3], 6, 0, "mnoMNO"}
  },
  {
    { colPins[0], 7, 0, "pqrsPQRS"},
    { colPins[2], 8, 0, "tuvTUV"},
    { colPins[3], 9, 0, "wxyzWXYZ"}
  },
  {
    { colPins[2], 10, 0, ""},
    { colPins[5], 11, 0, " "},
    { colPins[4], 12, 0, ""}
  },
};
// ___________________________________________________

void GLCD_bgl(bool state, int bgl_pin=BGL_PIN) {
  bgl_timer = (state) ? millis() : bgl_timer;
  digitalWrite(bgl_pin, state);
}
/* ------------------------------------------------- */

bool GLCD_Init() {  
  if ( display.begin(KS0108_CS_ACTIVE_HIGH) == false ) 
    return false;
  
  display.clearDisplay();           // Clear the buffer
  display.setTextSize(1);           // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON);  // Draw white text
  display.setCursor(0, 0);          // Start at top-left corner
  display.cp437(true);              // Use full 256 char 'Code Page 437' font
  display.setTextWrap(true);        // Set whether text should wrap around (else clip right).
  //display.setFont(&Picopixel);
  display.display();
  delay(1000);

  display.println("BOOTING.");
  display.display();
  
  GLCD_bgl(ON);
  
  return true;
}
/* ------------------------------------------------- */

void GLCD_animate(int del=20, int ripl=2) {
  int16_t i;

  display.clearDisplay();
  display.display();

  for(i=0; i<max(display.width(),display.height())/2; i+=2) {
    if (i >= ripl)
      display.drawCircle(display.width()/2, display.height()/2, i-ripl, KS0108_OFF);
    display.drawCircle(display.width()/2, display.height()/2, i, KS0108_ON);
    display.display();
    delay( (i<ripl) ? (del*4)/3 : del);
  }
  
  for(; i < (max(display.width(),display.height())/2)+(10+ripl); i+=2) {
    display.drawCircle(display.width()/2, display.height()/2, i-ripl, KS0108_OFF);
    display.drawCircle(display.width()/2, display.height()/2, i, KS0108_ON);
    display.display();
    delay(del);
  }

  delay(200);
  
  /*
  for(int16_t i=0; i<max(display.width(),display.height())/2; i+=2) {
    display.drawCircle(display.width()/2, display.height()/2, i, KS0108_ON);
    display.display();
    delay(del);
  }
  for(int16_t i=0; i<max(display.width(),display.height())/2; i+=2) {
    display.drawCircle(display.width()/2, display.height()/2, i, KS0108_OFF);
    display.display();
    delay(del);
  }
  */
  /*
  for (int16_t i=0; i<max(display.width(), display.height()); i+=2) {
    int cnt = 0;
    
    if (i < max(display.width(), display.height())/2) {
      display.drawCircle( display.width()/2, display.height()/2, i, KS0108_ON );
      if (i >= max( display.width()/2, display.height())/4 )
        display.drawCircle( display.width()/2, display.height()/2, cnt, KS0108_OFF ),
        cnt += 2;
    }
    else {
      display.drawCircle( display.width()/2, display.height()/2, cnt, KS0108_OFF ),
      cnt += 2;
    }
    display.display();
    delay(del);
  }
  */
  
}
/* ------------------------------------------------- */

Map *readKeyPad() {
  for (uint8_t row = 0; row < 4; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = matrix[row][col].pin;
      uint8_t key = matrix[row][col].key;  
      
      if (digitalRead(col_pin) == LOW) {
        if (millis()-kp_last_press) {
          while (digitalRead(col_pin) == LOW); 
          digitalWrite(rowPins[row], HIGH);
          kp_last_press = millis();
          
          return &(matrix[row][col]);
        }
      }
    }
    digitalWrite(rowPins[row], HIGH);
  }
  return nullptr;
}
/* ------------------------------------------------- */

void t9_reset() {
  for (uint8_t x = 0; x < 4; x++) 
    for (uint8_t y = 0; y < 3; y++) 
      matrix[x][y].index = 0;
}
// ---------------------------------------------------------------

void clearBuf() {
  memset(buf_input, 0, sizeof(buf_input));
  buf_index = 0;
  t9_reset();
}
// ---------------------------------------------------------------

bool checkInput() {
  uint8_t key, index;
  char c;
  
  Map *obj = readKeyPad();
  
  if (obj != NULL) {
    key = obj->key;

    if (obj->index < 1) {
      if (buf_input[buf_index] != '\0')
        buf_index = (key != 10 && key != 12) ? buf_index + 1 : buf_index;
      t9_reset();
    } 
    else {
      if (key > 10)  
        buf_index++;
    }
    
    if (key == 10) {
      buf_input[buf_index] = '\0';
      buf_index = (buf_index > 0) ? buf_index - 1 : 0;
    }
      
    index = obj->index % strlen(obj->t9_page);
    
    if (strlen(obj->t9_page) > 0) {
      buf_input[buf_index] = obj->t9_page[index];
      obj->index++;
    }
    return true;
  }
  return false;
}

// ---------------------------------------------------------------

void checkDisplay(int maxY = 56) {
  if (display.getCursorY() > maxY)
    display.pushUp(8),
    display.setCursor(0, maxY);
}
// ---------------------------------------------------------------

bool checkSerial() {
  return (bool)(Serial.available() > 0);
}
// ---------------------------------------------------------------

void checkHeader(String header) {
  delay(1);
}

// ---------------------------------------------------------------

void fsWrite(File& f, String line, const char* mode="w", bool nl=true) {
  if (f) {
    f = LittleFS.open(f.fullName(), "w");
    f.printf(
      ((nl) ? "%s\n" : "%s"),
      line.c_str()
    );
    f.close();
  }
}

int fsRead(File* f, int start_pos = 0) {
  if (f) {
    if (start_pos < f->size())
      f->seek(start_pos);
    
    while (f->available()) {
      int x = f->read();

      display.write(x);
      display.display();
    }
  }
  return f->position();
}
