#include <Arduino.h>
#include <stdio.h>
#include <pico/stdlib.h>
#include <hardware/pwm.h>
#include <hardware/gpio.h>

#include <LittleFS.h>

#if defined(USE_TINYUSB)
  #include <Adafruit_TinyUSB.h>
#elif defined(CFG_TUSB_MCU)
  #error Incompatible USB stack. Use Adafruit TinyUSB.
#endif

#include <TinyUSB_Devices.h>
#include <Adafruit_GFX.h>   // include adafruit GFX library
#include "KS0108_GLCD.h"    // include KS0108 GLCD library
#include "include.h"

//static Print* print_instance = &Serial;
//static Print* Lcd = &display;

//void LcdPrint(const char* msg, Print& lcd = display) { lcd.println(msg); }
/*
void LcdPrint(const char* data, KS0108_GLCD& Lcd = display) {
  Lcd.clearDisplay();
  Lcd.setCursor(0, 0); 
  Lcd.println(data);
  Lcd.display();
}
*/
/*
class ext : public KS0108_GLCD {
  public:
    ext();
    ~ext();
    float returnVal(float);
};
*/
// _________________________________________________________

void setup() {
  //delay(1000);
  Serial.begin(9600);
  LittleFS.begin();
    
  TinyUSBDevice.setManufacturerDescriptor(MANUFACTURER);
  TinyUSBDevice.setProductDescriptor(DEVICE_NAME);
  TinyUSBDevice.setID(DEVICE_VID, DEVICE_PID);
  TinyUSBDevices.begin(2);

  while(!USBDevice.mounted()) { yield(); }
  
  Keyboard.releaseAll();
  delay(2000);

  /*
  file = LittleFS.open("/stdin.txt", "w+");
  
  if (file) 
    fsWrite(file, "", "w", false);
  */
  zero_booted = false;
  rp2040.fifo.push_nb(FIFO_READY);

}
// ---------------------------------------------------------

/*
void loop() {
  if (Serial.available() > 0) {
    buf = Serial.readStringUntil('\n'); buf.trim();
    if (!zero_booted) {
      zero_booted = true;
      return;
    }

    GLCD_print(buf,LCD_PRINTLN,true);
  }
}
*/
/* DONT DELETE !
 * - REUSE PARTS?
 * 
*/
void loop() {
  if (Serial.available() > 0) {
    buf = Serial.readStringUntil('\n'); buf.trim();

    if (!zero_booted) {
      zero_booted = true;
      return;
    }
    
    if (buf.length())
      GLCD_print(buf, LCD_PRINTLN, true);
      

    if (buf == "#STDIN") {
        display.clearDisplay();
        display.setCursor(0,0);
        display.display();

        file = LittleFS.open("/stdin.txt", "w+");
        if (file) 
          file.seek(0),
          file.printf(""),
          file.close();
        
        ui_mode = UI_STDIN;
        return;
    }
    else if ((buf.substring(0, buf.indexOf(' ')) == "#HEAD") || (buf.startsWith("#HEAD"))) {
        checkHeader( buf.substring(buf.indexOf(' ')+1, buf.length()) );
        return;
    }
    else if (buf == "#EOF") {
      display.clearDisplay();
      display.setCursor(0,0);
      
      ui_mode = UI_STDIN_DONE;
      return;
    }
    // - - - - - - - - - - - -

    if (ui_mode == UI_STDIN) {
      file = LittleFS.open("/stdin.txt", "a");

      if (file) 
        file.printf("%s\n", buf.c_str()),
        file.close();

      delay(READ_DEL);
    }
  }
}

// _________________________________________________________


void setup1() {
  pinMode( LED_PIN, OUTPUT );
  //pinMode( BGL_PIN, OUTPUT_12MA );
  
  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    gpio_set_slew_rate( 
      rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );

  digitalWrite( LED_PIN, LOW  );

  PWM_Init();
  
  // - - - - - - - - - - - - - - - - - 

  GLCD_Init();
  GLCD_print("Initializing..", LCD_PRINTLN, true);

  // - - - - - - - - - - - - - - - - - 
  
  T = millis();
  
  GLCD_setBgl(ON, 30000);
  
  while(!core_ready || !zero_booted) {
    if (rp2040.fifo.pop_nb(&fifo_msg) && fifo_msg == FIFO_READY)
      core_ready = true;
  
    if ((millis()-T)>1000)
      GLCD_animate(30,8),
      T = millis();    

    GLCD_getBgl();
  }
  delay(1000);
  
  GLCD_print("Ready!",LCD_PRINTLN, true);
  //GLCD_setBgl(ON);
  
  /*
  while (rp2040.fifo.available() == 0) {
    if (rp2040.fifo.pop_nb(&fifo_msg)) //&& fifo_msg == FIFO_READY)
      break;
    GLCD_getBgl();
  }

  GLCD_setBgl(ON);
  
  while (!zero_booted) {
    GLCD_getBgl();
    GLCD_animate(30,8);
    
    T = millis();
    
    while ((millis()-T)<1000)
      if (zero_booted)
        break;
  }

  GLCD_print("HELLO");
  delay(2000);
  GLCD_setBgl(ON);
  */
  ui_mode = UI_READ;

  memset(buf_input, 0, sizeof(buf_input));
  kp_last_press = millis();
}
// ---------------------------------------------------------

void loop1() {
  if (BOOTSEL) {
    while (BOOTSEL);

    if (strlen(buf_input) > 0) {
      //Keyboard.print("run ");
      Keyboard.println(buf_input);

      display.clearDisplay();
      display.setCursor(0,0);
      display.print("> "); 
      display.display();
      
      clearBuf();
    }
  }
  else {
    if (checkInput()) {

      display.clearDisplay();
      display.setCursor(0,0);
      display.print("> ");
      
      if (ui_mode == UI_STDIN_DONE) {
        ui_mode = UI_WRITE;
        clearBuf();
      }
      else {
        display.print(buf_input);
        display.write(curSym);
        display.write('\n');
        display.display();
      }
      delay(30);
    }
  }
  GLCD_getBgl();
}
