

#include "Adafruit_TinyUSB.h"
#include "ramdisk.h"
#include "Adafruit_GFX.h"
#include "KS0108_GLCD.h"
#include "include.h"

// _________________________________________________________

void setup() {
  delay(1000);
  
  RamDiskBegin();
  Serial.begin(115200);
  
  pinMode( LED_PIN, OUTPUT );
  pinMode( BGL_PIN, OUTPUT_12MA );

  digitalWrite( LED_PIN, LOW  );
  digitalWrite( BGL_PIN, HIGH );

  while (!GLCD_Init() && (millis()<5000));
  
  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    gpio_set_slew_rate( 
      rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  PWM_Init();
 
  GLCD_print("Initializing..", LCD_PRINTLN, true); T = millis();  
  GLCD_setBgl(ON, 30000);
  
  zero_booted = false;
 
  while (!Serial.available()) {    
    if ((millis()-T)>1000)
      GLCD_animate(30,8),
      T = millis();  
          
    GLCD_getBgl();
  }
  delay(1000);
  
  GLCD_print("Ready!",LCD_PRINTLN, true);

  ui_mode = UI_READ;

  memset(buf_input, 0, sizeof(buf_input));
  kp_last_press = millis();
}
// ---------------------------------------------------------


void loop() {
  if (Serial.available() > 0) {
    
    buf = Serial.readStringUntil('\n'); buf.trim();
    if (!zero_booted) {
      zero_booted = true;
      return;
    }
    
    if (buf.length())
      GLCD_print(buf, LCD_PRINTLN, false);
      
    //usb_msc.setUnitReady(2, false); delay(5000);
    //usb_msc.setUnitReady(2, true); 
  }
  GLCD_getBgl();
}
/*
void loop() {
  if (BOOTSEL) {
    while (BOOTSEL);

    if (strlen(buf_input) > 0) {
      //Keyboard.print("run ");
      //Keyboard.println(buf_input);
      Serial.println(buf_input);
      display.clearDisplay();
      display.setCursor(0,0);
      display.print("> "); 
      display.display();
      
      clearBuf();
    }
  }
  else {
    if (checkInput()) {

      display.clearDisplay();
      display.setCursor(0,0);
      display.print("> ");
      
      if (ui_mode == UI_STDIN_DONE) {
        ui_mode = UI_WRITE;
        clearBuf();
      }
      else {
        display.print(buf_input);
        display.write(curSym);
        display.write('\n');
        display.display();
      }
      delay(30);
    }
  }
  GLCD_getBgl();
}
*/
/*
void loop() {
  if (Serial.available() > 0) {
    buf = Serial.readStringUntil('\n'); buf.trim();
    
    if (!zero_booted) {
      zero_booted = true;
      return;
    }
    
    if (buf.length())
      GLCD_print(buf, LCD_PRINTLN, true);
      

    if (buf == "#STDIN") {
        display.clearDisplay();
        display.setCursor(0,0);
        display.display();
        
        file = LittleFS.open("/stdin.txt", "w+");
        if (file) 
          file.seek(0),
          file.printf(""),
          file.close();
        
        ui_mode = UI_STDIN;
        return;
    }
    else if ((buf.substring(0, buf.indexOf(' ')) == "#HEAD") || (buf.startsWith("#HEAD"))) {
        checkHeader( buf.substring(buf.indexOf(' ')+1, buf.length()) );
        return;
    }
    else if (buf == "#EOF") {
      display.clearDisplay();
      display.setCursor(0,0);
      
      ui_mode = UI_STDIN_DONE;
      return;
    }
    // - - - - - - - - - - - -

    if (ui_mode == UI_STDIN) {
      
      file = LittleFS.open("/stdin.txt", "a");

      if (file) 
        file.printf("%s\n", buf.c_str()),
        file.close();
      
      delay(READ_DEL);
    }
  }
}
*/
// _________________________________________________________
