/* ____________________________________________________________________________________________________________________________________ */

#include <Adafruit_TinyUSB.h>
#include "ramdisk.h"

Adafruit_USBD_MSC usb_msc;

uint8_t message[DISK_BLOCK_SIZE];
bool msc_ready = false;
char buf[8192] = {'\0'};

void checkString(const char* data, uint32_t lba, uint32_t bufsize,  uint8_t mode);

void usb_msc_enable(bool enable=true) {
  // Set device descriptors
  usb_msc.setID(
    "Data Dogenigt", 
    "Mass Storage", 
    "1.0"
  ); 
  // Set disk size
  usb_msc.setCapacity( 
    DISK_BLOCK_NUM, 
    DISK_BLOCK_SIZE
  );
  // Set callbacks
  usb_msc.setReadWriteCallback(
    msc_read_callback,
    msc_write_callback,
    msc_flush_callback
  );
  // Set callback for toggle
  usb_msc.setReadyCallback(
    msc_ready_callback
  );
  // Set disk ready
  usb_msc.setUnitReady(enable);
}
// ----------------------------------------

void setup() { 
  usb_msc_enable(true);
  usb_msc.begin();  
  
  Serial.begin(115200);

  memset(buf, 0, sizeof(buf));
}
// ----------------------------------------

void loop() {
  if (Serial.available()) {
    memset(message, '\0', sizeof(message));
    int n = Serial.readBytesUntil('\n', message, sizeof(message)-1); message[n] = '\0';
  }
}
// ----------------------------------------

void checkString(const char* data, uint32_t lba, uint32_t bufsize,  uint8_t mode) {  
  if (strlen(data)) {
    if (strcmp(data, "ready") == 0) {
      if (!msc_ready) {
        Serial.println("READY!");
        msc_ready = true;
      }
    }
    else if (msc_ready && isAscii(data[0])) {      
      if ( strcmp(data, "TinyUSB MSC") != 0 ) {
        Serial.print("'");
        Serial.print(data);
        Serial.println("'");
      }
    }
  }
}
// ----------------------------------------

// Callback invoked when received READ10 command.
int32_t msc_read_callback (uint32_t lba, void* buffer, uint32_t bufsize) {
  const char* data;
  uint8_t const* addr = msc_disk[lba];

  memcpy(buffer, addr, bufsize);
  data = (const char*)msc_disk[lba];
  checkString(data, lba, bufsize, 0);
  return bufsize;
}
// ----------------------------------------

// Callback invoked when received WRITE10 command.
int32_t msc_write_callback (uint32_t lba, uint8_t* buffer, uint32_t bufsize) {
  const char* data;
  uint8_t* addr = msc_disk[lba];

  memcpy(addr, buffer, bufsize);
  data = (const char*)msc_disk[lba];
  checkString(data, lba, bufsize, 1);

  return bufsize;
}
// ----------------------------------------

// Callback invoked when WRITE10 command is completed (status received and accepted by host).
void msc_flush_callback (void) { ; }
// ----------------------------------------

bool msc_ready_callback(void) {
  if (BOOTSEL)
    return false;
  return true;
}
// ----------------------------------------
