#include <Adafruit_TinyUSB.h>
#include <TinyUSB_Mouse_and_Keyboard.h>
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include "ramdisk.h"
#include "include.h"

//#include <TinyUSB_Devices.h>


// ----------------------------------------

void setup() { 
  usb_msc_enable(true);
  usb_msc.begin();  
  
  Keyboard.begin();

  Serial.begin(115200);
  while (!Serial && millis()<3000);
  
  Keyboard.releaseAll(); 
  
  /*
  Serial.ignoreFlowControl(true);
  Serial.begin(9600);
  
  TinyUSBDevice.setManufacturerDescriptor(MANUFACTURER_NAME);
  TinyUSBDevice.setProductDescriptor(DEVICE_NAME);
  TinyUSBDevice.setID(DEVICE_VID, DEVICE_PID);
  
  TinyUSBDevices.begin(2);

  while(!USBDevice.mounted()) yield();
  */

  
  pinMode( LED_PIN, OUTPUT );
  pinMode( BGL_PIN, OUTPUT_12MA );

  digitalWrite( LED_PIN, LOW  );
  digitalWrite( BGL_PIN, HIGH );

  delay(1000);
  while (!GLCD_Init() && (millis()<5000));
  
  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    gpio_set_slew_rate( 
      rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  PWM_Init();
  GLCD_setBgl(ON, 30000);
  
  zero_booted = false;
 
  while (!Serial.available()) {    
    if ((millis()-T)>1000) {
      GLCD_animate(30,8);
      T = millis();  
      break;
    }          
    GLCD_getBgl();
  }
  delay(1000);
  
  GLCD_print("Ready!", LCD_PRINTLN, true);

  ui_mode = UI_READ;

  memset(buf_input, 0, sizeof(buf_input));
  kp_last_press = millis();
}
// ---------------------------------------------------------

void loop() {
  if (BOOTSEL) { kp_last_press = millis();
    while (BOOTSEL) { 
      if ((millis()-kp_last_press)>2000) {
        GLCD_animate(30,12);
        bootsel_held = true;
      }
    }
    if (bootsel_held) {
      ui_mode = (ui_mode == UI_WRITE) ? UI_READ : UI_WRITE;
      GLCD_print( ((ui_mode == UI_READ) ? "UI: READ MODE" : "UI: WRITE MODE"), LCD_PRINTLN, true);
      bootsel_held = false;
    }
  }
  
  else if (Serial.available() > 0) {
    buf = Serial.readStringUntil('\n'); buf.trim();
    if (!zero_booted) {
      zero_booted = true;
      return;
    }
    
    if (buf.length())
      GLCD_print(buf.c_str(), LCD_PRINTLN, false);      
  }
  else if (ui_mode == UI_STDIN || ui_mode == UI_STDIN_DONE) { T = millis();
    GLCD_print("Waiting for STDIN..", LCD_PRINTLN, true);
    while (ui_mode == UI_STDIN) {
      if ((millis()-T)>1000)
        GLCD_animate(30,8),
        T = millis();   
    }
    delay(1000);
    ui_mode = UI_READ;

    display.clearDisplay();
    
    for (uint32_t i=0; i<strlen(stdin_buf); i++) {
      if (display.getCursorY() > 56) {
        while (!BOOTSEL) yield();
        display.clearDisplay();
      }
      display.write(stdin_buf[i]);
      display.display();
      delay(5);
    } 
  }
  GLCD_getBgl();
}
/*
void loop() {
  if (BOOTSEL) {
    while (BOOTSEL);

    if (strlen(buf_input) > 0) {
      //Keyboard.print("run ");
      //Keyboard.println(buf_input);
      Serial.println(buf_input);
      display.clearDisplay();
      display.setCursor(0,0);
      display.print("> "); 
      display.display();
      
      clearBuf();
    }
  }
  else {
    if (checkInput()) {

      display.clearDisplay();
      display.setCursor(0,0);
      display.print("> ");
      
      if (ui_mode == UI_STDIN_DONE) {
        ui_mode = UI_WRITE;
        clearBuf();
      }
      else {
        display.print(buf_input);
        display.write(curSym);
        display.write('\n');
        display.display();
      }
      delay(30);
    }
  }
  GLCD_getBgl();
}
*/
/*
void loop() {
  if (Serial.available() > 0) {
    buf = Serial.readStringUntil('\n'); buf.trim();
    
    if (!zero_booted) {
      zero_booted = true;
      return;
    }
    
    if (buf.length())
      GLCD_print(buf, LCD_PRINTLN, true);
      

    if (buf == "#STDIN") {
        display.clearDisplay();
        display.setCursor(0,0);
        display.display();
        
        file = LittleFS.open("/stdin.txt", "w+");
        if (file) 
          file.seek(0),
          file.printf(""),
          file.close();
        
        ui_mode = UI_STDIN;
        return;
    }
    else if ((buf.substring(0, buf.indexOf(' ')) == "#HEAD") || (buf.startsWith("#HEAD"))) {
        checkHeader( buf.substring(buf.indexOf(' ')+1, buf.length()) );
        return;
    }
    else if (buf == "#EOF") {
      display.clearDisplay();
      display.setCursor(0,0);
      
      ui_mode = UI_STDIN_DONE;
      return;
    }
    // - - - - - - - - - - - -

    if (ui_mode == UI_STDIN) {
      
      file = LittleFS.open("/stdin.txt", "a");

      if (file) 
        file.printf("%s\n", buf.c_str()),
        file.close();
      
      delay(READ_DEL);
    }
  }
}
*/
// _________________________________________________________
