
#include "ramdisk.h"
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include <TinyUSB_Mouse_and_Keyboard.h>

#include "tree.h"
#include "include.h"

// ----------------------------------------

/*_  _  _ 
 |1  4  3|
 |1  4  6|
 |1  4  6|
 |4  10 9|

 - start med col 4! ( har både op, ned, enter og back )
   --> aktiver col 4, så hvert af de 4 rows

 - så col 10, 9
   --> kun row 8

 - så col 1
   --> rows 7,5,2

 - så col 6
   --> row 7 og 5

 - til sidst col 3
   --> kun row 2   
*/
/*
colPin  N   list---------->     */
uint8_t cols_ordered[col_N][6] = {
  {12,  4,  8,  9,  11, 14}, // KP4
  {6,   1,  8,  0,  0,   0}, // KP10
  {7,   1,  8,  0,  0,   0}, // KP9
  {15,  3,  9,  11, 14,  0}, // KP1
  {10,  2,  9,  11, 0,   0}, // KP6
  {13,  1,  14, 0,  0,   0}, // KP3
};

void dumpKeyPad(bool all=true) {
  for (uint8_t col = 0; col < col_N; col++) {
    uint8_t *arr = &(cols_ordered[col][0]);
    uint8_t colPin = arr[0];
    uint8_t rows = arr[1];

    Serial.print(colPin); Serial.print("\t: ");
    Serial.print("["); Serial.print(rows); Serial.print("]{ ");
    
    for (uint8_t row = 0; row < rows; row++) 
       Serial.print(arr[row+2]), Serial.print(",");
    Serial.println(" }");
  }
  Serial.println("\n-----------------\n");
}
// -----------------------------------------------------------

void testKeyPad(bool all=true) {
  for (uint8_t col = 0; col < col_N; col++) {
    uint8_t *data = &(cols_ordered[col][0]);
    uint8_t colPin = data[0];
    uint8_t rows = data[1];

    digitalWrite(colPin, LOW);
    
    for (uint8_t row = 0; row < rows; row++) {
      uint8_t rowPin = data[row+2];
      Serial.print(digitalRead(rowPin)); Serial.print(" ");
      //delay(50);
    }
    digitalWrite(colPin, HIGH);

    Serial.println();
  }
  Serial.println("\n-----------------------------------\n");
  delay(50);
}

  
  
  //unsigned int binary = 0b1000000000000000;
  /*
  for (uint8_t row = 0; row < 4; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = matrix[row][col].pin;
      uint8_t key = matrix[row][col].key; 
      
      if (digitalRead(col_pin) == LOW) {
        setBit(binary, key-1, 1);
        
        if (break_on_press) {
          digitalWrite(rowPins[row], HIGH);
          return binary;
        }
      }
    }
    digitalWrite(rowPins[row], HIGH);
  }
  delay(KP_DEBOUNCE);
  return binary;
  */


void setup() {   
  usb_msc_enable(true);
  usb_msc.begin();  
  
  Serial.begin(9600);
  Keyboard.begin();
  Keyboard.releaseAll(); 

  // - - - - - - - - - - - - - - - - - 
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i],      OUTPUT ),
    digitalWrite( colPins[i], HIGH   ),
    
    gpio_set_slew_rate( 
      colPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i], INPUT_PULLUP );

  // - - - - - - - - - - - - - - - - - 

  while (!Serial) yield();
  //dumpKeyPad();
  
  while(1) {
    readKeyPad2(&(matrix[0][0]));
    //testKeyPad();
    //rawKeyPad();
    //delay(500);
    //Serial.println("\n\n___________________________________________________\n\n");
  }
  
  pinMode( BGL_PIN, OUTPUT_12MA );
  digitalWrite( BGL_PIN, HIGH );

  GLCD_Init();
  //PWM_Init();

  // - - - - - - - - - - - - - - - - - 

  while (!zero_booted) {
    if (Serial.available() || BOOTSEL) break;
    if ((millis()-T) > 2000) 
      GLCD_animate(30,6),
      T = millis();
    GLCD_getBgl();
  }
  while (Serial.available()) 
    Serial.read();

  zero_booted = true;

  ui_mode = UI_READ;
  memset(buf_input, 0, sizeof(buf_input));
  kp_last_press = millis();
   
  Menu();
  
  GLCD_overwrite("Device Ready.");
  delay(2000);
  
  for (int i=0; i<display.width(); i++)
    display.scrollLineLeft(1, 7),
    display.display(),
    delay(100);
  //tree::Debug(&menuTree);
}
// ---------------------------------------------------------

void Menu() {
  ui_mode = UI_READ;

  if (!menu_init) 
    //GLCD_setBgl(ON, 30000),
    menu_init = tree::Init(&menuTree, menu_init);

  tree::Render();
}
// ---------------------------------------------------------

void loop() {
  if (ui_mode == UI_READ) {
    KeyMap *KP = readKeyPad();
    
    if (KP != NULL)
      tree::Navigate(KP->key);
  }
  else if (ui_mode == UI_WRITE) {
    unsigned int btn_map = rawKeyPad(false);
  }
  /*
  
  
  if (ui_mode == UI_READ) {
    btn_map = rawKeyPad();
    
    if (btn_map) 
      tree::Navigate(btn_map);
    */
    /*
    if (btn_map) {
      display.clearDisplay();
      for (int& btn : nav_btns) {
        if (btn_map & (1 << btn-1) ) {
          display.write((int)btn + '0'); display.write(' ');
          display.display();
          //break;
        }
      }
    }
    }
    */
  //else if (ui_mode == UI_WRITE) {}
}

/*
void loop() {
  unsigned int btn_map;
  
  if (BOOTSEL) { kp_last_press = millis();
    while (BOOTSEL) { 
      if ((millis()-kp_last_press)>2000) {
        GLCD_animate(30,12);
        bootsel_held = true;
      }
    }
    if (bootsel_held) {
      ui_mode = (ui_mode == UI_WRITE) ? UI_READ : UI_WRITE;
      GLCD_print( ((ui_mode == UI_READ) ? "UI: READ MODE" : "UI: WRITE MODE"), LCD_PRINTLN, true);
      bootsel_held = false;
    }
  }
  else if (Serial.available() > 0) {
    buf = Serial.readStringUntil('\n'); buf.trim();
    if (!zero_booted) {
      zero_booted = true;
      return;
    }
    
    if (buf.length()) {
      GLCD_print(buf.c_str(), LCD_PRINTLN, true);
      
      if (buf == "reset") {
        pwm_set_gpio_level( bgl_data.pin, 0 );
        pwm_set_enabled( bgl_data.slice, false);
        delay(1000);
        display.resetDisplay();
        delay(1000);
        pwm_set_gpio_level( bgl_data.pin, 255 );
        pwm_set_enabled( bgl_data.slice, true);
        
      }
    }    
  }
  else if (ui_mode == UI_STDIN || ui_mode == UI_STDIN_DONE) { T = millis();
    GLCD_print("Waiting for STDIN..", LCD_PRINTLN, true);
    while (ui_mode == UI_STDIN) {
      if ((millis()-T)>1000)
        GLCD_animate(30,8),
        T = millis();   
    }
    delay(1000);
    ui_mode = UI_READ;

    display.clearDisplay();
    
    for (uint32_t i=0; i<strlen(stdin_buf); i++) {
      if (display.getCursorY() > 56) {
        while (!BOOTSEL) yield();
        display.clearDisplay();
      }
      display.write(stdin_buf[i]);
      display.display();
      delay(5);
    } 
  }
  else if (ui_mode == UI_WRITE) {
    btn_map = rawKeyPad();
    bool mod_pressed = (btn_map & (1 << 11) ) ? true : false;
  }
  else if (ui_mode == UI_READ) {
    btn_map = rawKeyPad();
    int i=0;

    if (btn_map) {
      display.clearDisplay();
      for (int& btn : nav_btns) {
        if (btn_map & (1 << btn-1) ) {
          display.write((int)btn + '0'); display.write(' ');
          display.display();
          //break;
        }
      }
    }
  }
  GLCD_getBgl();
}
*/
/*
void loop() {
  if (BOOTSEL) {
    while (BOOTSEL);

    if (strlen(buf_input) > 0) {
      //Keyboard.print("run ");
      //Keyboard.println(buf_input);
      Serial.println(buf_input);
      display.clearDisplay();
      display.setCursor(0,0);
      display.print("> "); 
      display.display();
      
      clearBuf();
    }
  }
  else {
    if (checkInput()) {

      display.clearDisplay();
      display.setCursor(0,0);
      display.print("> ");
      
      if (ui_mode == UI_STDIN_DONE) {
        ui_mode = UI_WRITE;
        clearBuf();
      }
      else {
        display.print(buf_input);
        display.write(curSym);
        display.write('\n');
        display.display();
      }
      delay(30);
    }
  }
  GLCD_getBgl();
}
*/
/*
void loop() {
  if (Serial.available() > 0) {
    buf = Serial.readStringUntil('\n'); buf.trim();
    
    if (!zero_booted) {
      zero_booted = true;
      return;
    }
    
    if (buf.length())
      GLCD_print(buf, LCD_PRINTLN, true);
      

    if (buf == "#STDIN") {
        display.clearDisplay();
        display.setCursor(0,0);
        display.display();
        
        file = LittleFS.open("/stdin.txt", "w+");
        if (file) 
          file.seek(0),
          file.printf(""),
          file.close();
        
        ui_mode = UI_STDIN;
        return;
    }
    else if ((buf.substring(0, buf.indexOf(' ')) == "#HEAD") || (buf.startsWith("#HEAD"))) {
        checkHeader( buf.substring(buf.indexOf(' ')+1, buf.length()) );
        return;
    }
    else if (buf == "#EOF") {
      display.clearDisplay();
      display.setCursor(0,0);
      
      ui_mode = UI_STDIN_DONE;
      return;
    }
    // - - - - - - - - - - - -

    if (ui_mode == UI_STDIN) {
      
      file = LittleFS.open("/stdin.txt", "a");

      if (file) 
        file.printf("%s\n", buf.c_str()),
        file.close();
      
      delay(READ_DEL);
    }
  }
}
*/
// _________________________________________________________
