#include <Adafruit_TinyUSB.h>
#include "ramdisk.h"
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include <TinyUSB_Mouse_and_Keyboard.h>

#include "tree.h"
#include "include.h"

// ----------------------------------------

int16_t penX, penY;
/*
void serial2canvas() {
  x = 0; y = 0;
  inString = "";
  display.clearDisplay();
  display.display();
  
  while (1) {
    while (Serial.available()) {
      char c = Serial.read();
  
      if (isPrintable(c)) {
        if (isdigit(c))
          inString += (char)c;
      }
      if (c == '\n') {
        Serial.print("int: "); Serial.println(inString.toInt());
        if (x == 0)
          x = inString.toInt(),
          Serial.print("x: "),
          Serial.println(x);
        else if (x > 0 && y == 0) {
          y = inString.toInt();
          Serial.print("y: "),
          Serial.println(y);
          display.drawPixel(x, y, KS0108_ON);
          display.display();
          x = 0;
          y = 0;
        }
        inString = "";
      }
    }
  }
}
*/

void drawCanvas() {
  penX = 64;
  penY = 32;

  display.drawPixel(20, 20, 1);
  display.display();
  
}

void setup() {   
  usb_msc_enable(true);
  usb_msc.begin();  
  
  Serial.begin(9600);
  Keyboard.begin();
  Keyboard.releaseAll(); 
  
  pinMode( BGL_PIN, OUTPUT_12MA );
  digitalWrite( BGL_PIN, HIGH );

  GLCD_Init();
  //PWM_Init();

  // - - - - - - - - - - - - - - - - - 
  
  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    gpio_set_slew_rate( 
      rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  while (!zero_booted) {
    if (Serial.available() || BOOTSEL) break;
    if ((millis()-T) > 2000) 
      GLCD_animate(30,6),
      T = millis();
    GLCD_getBgl();
  }
  while (Serial.available()) 
    Serial.read();

  zero_booted = true;

  ui_mode = UI_READ;
  memset(buf_input, 0, sizeof(buf_input));
  kp_last_press = millis();
   
  Menu();
}
// ---------------------------------------------------------

void Menu() {
  ui_mode = UI_READ;

  if (!menu_init) 
    //GLCD_setBgl(ON, 30000),
    menu_init = tree::Init(&menuTree, menu_init);

  tree::Render();

  GLCD_overwrite("Device Ready.");
}
// ---------------------------------------------------------

void checkSerial() {
  //String line;
  int pos = 0;
  /*
  if (stdin_available) {
    while (Serial.available())
      line = Serial.readStringUntil('\n');
    return;
  }
  */
  while (Serial.available()) {
    String line = Serial.readStringUntil('\n');
    Serial.println(line);

    line.trim();

    
    if (line == "#STDIN") {
      Serial.println("STDIN!");
      stdin_available = true;
      memset(stdin_buf, '\0', BUF_SIZE);
    }
    //if (stdin_available) {
      for (int i=0; i<line.length(); i++) {
        stdin_buf[pos++] = line[i];
      }
      //strcat(stdin_buf, line);
      Serial.println("\nBUF:");
      Serial.println(stdin_buf);
    //}
  }
  /*
  if (line == "#STDIN") {
    stdin_available = true;
    memset(stdin_buf, '\0', BUF_SIZE);

    while (Serial.available()) {
      line = Serial.readStringUntil('\n');
      Serial.println(line);
      if (line == "#EOF") 
        stdin_available = false;
      if (stdin_available) 
        strcat(stdin_buf, line.c_str());
       //strncat(stdin_buf, line.c_str(), line.length()); 
    }
    
    display.clearDisplay();
    display.display();
    delay(500);
    
    for (int i=0; i<BUF_SIZE; i++) 
      display.write(stdin_buf[i]);  
    display.display();
    Serial.println(stdin_buf);
    stdin_available = false;
  }
  */
}

// ---------------------------------------------------------

void loop() {
  if (ui_mode == UI_READ) {
    KeyMap *KP = readKeyPad();
    
    if (KP != NULL)
      tree::Navigate(KP->key);
  }
  else if (ui_mode == UI_WRITE) {
    unsigned int btn_map = rawKeyPad(false);
  }

  if (stdin_available) {
    display.clearDisplay();
    display.display();
    delay(500);
    
    for (int i=0; i<BUF_SIZE; i++) 
      display.write(stdin_buf[i]);  
    display.display();
    stdin_available = false;
  }
  else if (Serial.available()) {
    buf = Serial.readStringUntil('\n');
    buf.trim();
    
    if (buf == "#STDIN") {
      serial_busy = true;

      display.clearDisplay();
      display.display();
      delay(500); 
      
      while (serial_busy) {
        if (Serial.available() > 0) {
          buf = Serial.readStringUntil('\n');
          display.println(buf); 
          display.display();  
          
          if (buf.startsWith("#EOF")) serial_busy = false;
        }
      }
      display.println("DONE!"); 
      display.display();  
    }
  }
  /*
  else if (Serial.available()) {
    buf = Serial.readStringUntil('\n');
    buf.trim();
    
    //if (!stdin_available) {
      if (buf == "#STDIN") { Serial.println("STDIN!");
        stdin_available = true;
        memset(stdin_buf, '\0', BUF_SIZE);
        int pos=0;
        
        while (stdin_available) {
        //while (Serial.available()) {
          buf = Serial.readStringUntil('\n');
          if (buf.startsWith("#EOF")) break;
          //Serial.println(buf);
          //stdin_buf[pos++] = Serial.read();
        }
        Serial.println(stdin_buf);
        stdin_available = false;
      }
    //}
    
    else {
      while (Serial.available()) {
        buf = Serial.readStringUntil('\n');
        strcat(stdin_buf, buf.c_str());
        buf.trim();
        if (buf == "#EOF") break;
      }
      stdin_available = false;
      Serial.println(stdin_buf);
    }
    checkSerial();
    
  }
  /*
  
  
  if (ui_mode == UI_READ) {
    btn_map = rawKeyPad();
    
    if (btn_map) 
      tree::Navigate(btn_map);
    */
    /*
    if (btn_map) {
      display.clearDisplay();
      for (int& btn : nav_btns) {
        if (btn_map & (1 << btn-1) ) {
          display.write((int)btn + '0'); display.write(' ');
          display.display();
          //break;
        }
      }
    }
    }
    */
  //else if (ui_mode == UI_WRITE) {}
}

/*
void loop() {
  unsigned int btn_map;
  
  if (BOOTSEL) { kp_last_press = millis();
    while (BOOTSEL) { 
      if ((millis()-kp_last_press)>2000) {
        GLCD_animate(30,12);
        bootsel_held = true;
      }
    }
    if (bootsel_held) {
      ui_mode = (ui_mode == UI_WRITE) ? UI_READ : UI_WRITE;
      GLCD_print( ((ui_mode == UI_READ) ? "UI: READ MODE" : "UI: WRITE MODE"), LCD_PRINTLN, true);
      bootsel_held = false;
    }
  }
  else if (Serial.available() > 0) {
    buf = Serial.readStringUntil('\n'); buf.trim();
    if (!zero_booted) {
      zero_booted = true;
      return;
    }
    
    if (buf.length()) {
      GLCD_print(buf.c_str(), LCD_PRINTLN, true);
      
      if (buf == "reset") {
        pwm_set_gpio_level( bgl_data.pin, 0 );
        pwm_set_enabled( bgl_data.slice, false);
        delay(1000);
        display.resetDisplay();
        delay(1000);
        pwm_set_gpio_level( bgl_data.pin, 255 );
        pwm_set_enabled( bgl_data.slice, true);
        
      }
    }    
  }
  else if (ui_mode == UI_STDIN || ui_mode == UI_STDIN_DONE) { T = millis();
    GLCD_print("Waiting for STDIN..", LCD_PRINTLN, true);
    while (ui_mode == UI_STDIN) {
      if ((millis()-T)>1000)
        GLCD_animate(30,8),
        T = millis();   
    }
    delay(1000);
    ui_mode = UI_READ;

    display.clearDisplay();
    
    for (uint32_t i=0; i<strlen(stdin_buf); i++) {
      if (display.getCursorY() > 56) {
        while (!BOOTSEL) yield();
        display.clearDisplay();
      }
      display.write(stdin_buf[i]);
      display.display();
      delay(5);
    } 
  }
  else if (ui_mode == UI_WRITE) {
    btn_map = rawKeyPad();
    bool mod_pressed = (btn_map & (1 << 11) ) ? true : false;
  }
  else if (ui_mode == UI_READ) {
    btn_map = rawKeyPad();
    int i=0;

    if (btn_map) {
      display.clearDisplay();
      for (int& btn : nav_btns) {
        if (btn_map & (1 << btn-1) ) {
          display.write((int)btn + '0'); display.write(' ');
          display.display();
          //break;
        }
      }
    }
  }
  GLCD_getBgl();
}
*/
/*
void loop() {
  if (BOOTSEL) {
    while (BOOTSEL);

    if (strlen(buf_input) > 0) {
      //Keyboard.print("run ");
      //Keyboard.println(buf_input);
      Serial.println(buf_input);
      display.clearDisplay();
      display.setCursor(0,0);
      display.print("> "); 
      display.display();
      
      clearBuf();
    }
  }
  else {
    if (checkInput()) {

      display.clearDisplay();
      display.setCursor(0,0);
      display.print("> ");
      
      if (ui_mode == UI_STDIN_DONE) {
        ui_mode = UI_WRITE;
        clearBuf();
      }
      else {
        display.print(buf_input);
        display.write(curSym);
        display.write('\n');
        display.display();
      }
      delay(30);
    }
  }
  GLCD_getBgl();
}
*/
/*
void loop() {
  if (Serial.available() > 0) {
    buf = Serial.readStringUntil('\n'); buf.trim();
    
    if (!zero_booted) {
      zero_booted = true;
      return;
    }
    
    if (buf.length())
      GLCD_print(buf, LCD_PRINTLN, true);
      

    if (buf == "#STDIN") {
        display.clearDisplay();
        display.setCursor(0,0);
        display.display();
        
        file = LittleFS.open("/stdin.txt", "w+");
        if (file) 
          file.seek(0),
          file.printf(""),
          file.close();
        
        ui_mode = UI_STDIN;
        return;
    }
    else if ((buf.substring(0, buf.indexOf(' ')) == "#HEAD") || (buf.startsWith("#HEAD"))) {
        checkHeader( buf.substring(buf.indexOf(' ')+1, buf.length()) );
        return;
    }
    else if (buf == "#EOF") {
      display.clearDisplay();
      display.setCursor(0,0);
      
      ui_mode = UI_STDIN_DONE;
      return;
    }
    // - - - - - - - - - - - -

    if (ui_mode == UI_STDIN) {
      
      file = LittleFS.open("/stdin.txt", "a");

      if (file) 
        file.printf("%s\n", buf.c_str()),
        file.close();
      
      delay(READ_DEL);
    }
  }
}
*/
// _________________________________________________________
