#include <Adafruit_TinyUSB.h>
#include "ramdisk.h"
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include <TinyUSB_Mouse_and_Keyboard.h>

#include "tree.h"
#include "include.h"

typedef enum : int8_t {
  OTHER = -1,
  BOOTING,
  BOOTED,
  MENU_INIT,
  STDIN_MSC,
  STDIN_SER,
  READER
} state_enum;

struct _systatus {
  state_enum  id;
  const char *txt;
};
_systatus sys_states[] = {
  {BOOTING,   "Booting."},
  {BOOTED,    "System ready."},
  {MENU_INIT, "Menu launched."},
  {STDIN_MSC, "Reading MSC in."},
  {STDIN_SER, "Reading Serial in."},
  {READER,    "File reader."}
};

_systatus
sys_status_prev,
sys_status = sys_states[BOOTING];

// ----------------------------------------

void setState(int8_t state, const char* custom_txt = NULL) {
  sys_status_prev = sys_status;
  sys_status = sys_states[state];
}
// ----------------------------------------

void setup() {   
  usb_msc_enable(true);
  usb_msc.begin();  
  
  Serial.begin(9600);
  Keyboard.begin();
  Keyboard.releaseAll(); 
  
  pinMode( BGL_PIN, OUTPUT_12MA );
  digitalWrite( BGL_PIN, HIGH );

  GLCD_Init();
  //PWM_Init();

  setState(BOOTING);
  
  // - - - - - - - - - - - - - - - - - 
  
  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    gpio_set_slew_rate( 
      rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  while (!msc_ready) yield();
  setState(BOOTED);
  
  while (!zero_booted) {
    if (Serial.available() || BOOTSEL) break;
    if ((millis()-T) > 2000) 
      GLCD_animate(30,6),
      T = millis();
    GLCD_getBgl();
  }
  while (Serial.available()) 
    Serial.read();

  zero_booted = true;
  clearBuf();
  Menu();
}
// ---------------------------------------------------------

void Menu() {
  ui_mode = UI_READ;
  setState(MENU_INIT);
  
  if (!menu_init) 
    //GLCD_setBgl(ON, 30000),
    menu_init = tree::Init(&menuTree, menu_init);

  tree::Render();

  GLCD_overwrite("Device Ready.", 56, "> ");
}
// ---------------------------------------------------------

void GLCD_blinkCursor(bool state, int16_t x=0, int16_t y=56, int16_t c=219) {
  //int16_t xpos = display.getCursorX();
  //int16_t ypos = display.getCursorY();
  
  display.setCursor(x,y);
  display.setTextColor((state)? KS0108_ON : KS0108_OFF);
  display.write(c);
  display.display();
  display.setTextColor(KS0108_ON);
  //display.setCursor(xpos, ypos);
}

void Reader() {
  const char  *txt_buf;
  uint16_t    last, index = 0;
  uint8_t     key;
  bool        valid, curstate = false;
  KeyMap      *KP;
  
  txt_buf = (sys_status.id == STDIN_MSC) ? stdin_buf : ((sys_status.id == STDIN_SER) ? buf_input : nullptr);
  
  if (txt_buf != NULL && strlen(txt_buf)) {
    setState(READER);

    display.clearDisplay();

    while (index < strlen(txt_buf)-1) {
      display.write(txt_buf[index++]);
      display.display();
      delay(10);
      
      if (display.getCursorY() > 56) {
        last  = index;
        valid = false;
        key   = 0;
        
        while (!valid) {
          KP = readKeyPad();
          if (KP != NULL) {
            key = KP->key;
            if (key == 2 || key == 8)
              valid = true;
            else if (key == 7)
              break;
          }
          if ( !(millis() % 200) ) 
            GLCD_blinkCursor((curstate = !curstate), (20*6), 56, 25);
        }
        GLCD_blinkCursor(false, (20*6), 56, 25);

        if (key == 8) 
          display.pushUp(8);
        
        //display.setTextColor(KS0108_ON);
        //display.pushUp(8);
        display.setCursor(0, 56);
        display.display();
        delay(100);
        /*
        while (!BOOTSEL) {
          if ( !(millis() % 200) ) {
            curstate = !curstate;
            display.setCursor((20*6), 56);
            display.setTextColor((curstate)? KS0108_ON : KS0108_OFF);
            display.write(25);
            display.display();
            delay(200);
          }
        }
        display.setCursor((20*6), 56);
        display.setTextColor(KS0108_OFF);
        display.write(25);
        display.setTextColor(KS0108_ON);
        
        
        while (BOOTSEL) yield();
        display.pushUp(8);
        display.setCursor(0, 56);
        display.display();
        delay(100);
        */
      }
    }

    /*
        // test start
        display.display();
        if ( !((millis()-kp_last_press) % 200)) {
          curstate = !curstate;
          GLCD_overwrite(" ", 56);
          display.write(25);
          display.display();
        }
        // test end
     */
    
    /*
    while (txt_buf && (display.getCursorY() < 64)) {
      display.write(txt_buf[index++]);
      display.display();
      delay(20);
    }
    //if (txt_buf) display.pushUp(8), display.display();

    while (txt_buf) {
      //GLCD_overflow(56); display.display();
        
      while (1) {
        if ( !((millis()-kp_last_press) % 100)) {
          curstate = !curstate;
          display.setCursor((20*6),56);
          display.setTextColor((curstate)? KS0108_ON : KS0108_OFF);
          display.write(25);
          display.display();
        }
        if (BOOTSEL && ((millis()-kp_last_press) > KP_DEBOUNCE)) 
          break;
      }
      while (BOOTSEL) yield();
      kp_last_press = millis();

      if (display.getCursorY() >= 56)
        display.pushUp(8);

      display.setCursor((20*6),56);
      display.setTextColor(KS0108_OFF);
      display.write(25);
      display.display();
      
      display.setTextColor(KS0108_ON);
      display.setCursor(0, 56);
      display.display();
      
      while (display.getCursorY() <= 56) {
        if (txt_buf[index] == '\0') break;
        display.write(txt_buf[index++]);
        display.display();
        delay(20);
      }
    }*/
    delay(2000);
    GLCD_print("DONE!", LCD_PRINTLN, true);
  } 
}

/*
void Reader() {
  const char* txt_buf;
  uint16_t    last, index = 0;
  bool        curstate = false;
  
  txt_buf = (sys_status.id == STDIN_MSC) ? stdin_buf : ((sys_status.id == STDIN_SER) ? buf_input : nullptr);
  
  if (txt_buf != NULL && strlen(txt_buf)) {
    setState(READER);

    display.clearDisplay();
    
    while (txt_buf && (display.getCursorY() < 64)) {
      display.write(txt_buf[index++]);
      display.display();
      delay(20);
    }
    //if (txt_buf) display.pushUp(8), display.display();

    while (txt_buf) {
      //GLCD_overflow(56); display.display();
        
      while (1) {
        if ( !((millis()-kp_last_press) % 100)) {
          curstate = !curstate;
          display.setCursor((20*6),56);
          display.setTextColor((curstate)? KS0108_ON : KS0108_OFF);
          display.write(25);
          display.display();
        }
        if (BOOTSEL && ((millis()-kp_last_press) > KP_DEBOUNCE)) 
          break;
      }
      while (BOOTSEL) yield();
      kp_last_press = millis();

      if (display.getCursorY() >= 56)
        display.pushUp(8);

      display.setCursor((20*6),56);
      display.setTextColor(KS0108_OFF);
      display.write(25);
      display.display();
      
      display.setTextColor(KS0108_ON);
      display.setCursor(0, 56);
      display.display();
      
      while (display.getCursorY() <= 56) {
        if (txt_buf[index] == '\0') break;
        display.write(txt_buf[index++]);
        display.display();
        delay(20);
      }
    }
    GLCD_print("DONE!", LCD_PRINTLN, true);
    
//    while (txt_buf) {
//      last = index;
//      display.clearDisplay();
//      display.setCursor(0, 0);
//      display.display();
//      delay(500);
//      while (display.getCursorY() < 64)
//        display.write(txt_buf[index++]),
//        display.display(),
//        delay(20);
//      while (!BOOTSEL);
//      
//    }
  } 
}
*/
void loop() {
  KeyMap *KP;
  if (ui_mode == UI_READ) {
    KP = readKeyPad();
    if (KP != NULL)
      tree::Navigate(KP->key);
  }
  else if (ui_mode == UI_WRITE) {
    unsigned int btn_map = rawKeyPad(false);
  }

  if (stdin_available) {
    setState(STDIN_MSC);
    Reader();
    /*
    display.clearDisplay();
    display.display();
    delay(500);
    
    for (int i=0; i<BUF_SIZE; i++) 
      display.write(stdin_buf[i]);  
    display.display();
    */
    stdin_available = false;
  }
  else if (Serial.available()) {
    if (Serial.find("#STDIN\n")) {
      int n = 0; T = millis();
      memset(buf_input, 0, sizeof(buf_input));
      serial_busy = true;
      setState(STDIN_SER);
      
      while (serial_busy) {
        if (Serial.available() > 0) { 
          char *eof, c = Serial.read();
          buf_input[n++] = c;
          eof = strstr(buf_input, "#EOF\n");
          T = millis();
          
          if (eof) {
            *eof = '\0';
            serial_busy = false;
          }
        }
        else if ((millis()-T) > 5000)
          serial_busy = false;
      }
      Reader();
    }
  }
}

/*
void loop() {
  unsigned int btn_map;
  
  if (BOOTSEL) { kp_last_press = millis();
    while (BOOTSEL) { 
      if ((millis()-kp_last_press)>2000) {
        GLCD_animate(30,12);
        bootsel_held = true;
      }
    }
    if (bootsel_held) {
      ui_mode = (ui_mode == UI_WRITE) ? UI_READ : UI_WRITE;
      GLCD_print( ((ui_mode == UI_READ) ? "UI: READ MODE" : "UI: WRITE MODE"), LCD_PRINTLN, true);
      bootsel_held = false;
    }
  }
  else if (Serial.available() > 0) {
    buf = Serial.readStringUntil('\n'); buf.trim();
    if (!zero_booted) {
      zero_booted = true;
      return;
    }
    
    if (buf.length()) {
      GLCD_print(buf.c_str(), LCD_PRINTLN, true);
      
      if (buf == "reset") {
        pwm_set_gpio_level( bgl_data.pin, 0 );
        pwm_set_enabled( bgl_data.slice, false);
        delay(1000);
        display.resetDisplay();
        delay(1000);
        pwm_set_gpio_level( bgl_data.pin, 255 );
        pwm_set_enabled( bgl_data.slice, true);
        
      }
    }    
  }
  else if (ui_mode == UI_STDIN || ui_mode == UI_STDIN_DONE) { T = millis();
    GLCD_print("Waiting for STDIN..", LCD_PRINTLN, true);
    while (ui_mode == UI_STDIN) {
      if ((millis()-T)>1000)
        GLCD_animate(30,8),
        T = millis();   
    }
    delay(1000);
    ui_mode = UI_READ;

    display.clearDisplay();
    
    for (uint32_t i=0; i<strlen(stdin_buf); i++) {
      if (display.getCursorY() > 56) {
        while (!BOOTSEL) yield();
        display.clearDisplay();
      }
      display.write(stdin_buf[i]);
      display.display();
      delay(5);
    } 
  }
  else if (ui_mode == UI_WRITE) {
    btn_map = rawKeyPad();
    bool mod_pressed = (btn_map & (1 << 11) ) ? true : false;
  }
  else if (ui_mode == UI_READ) {
    btn_map = rawKeyPad();
    int i=0;

    if (btn_map) {
      display.clearDisplay();
      for (int& btn : nav_btns) {
        if (btn_map & (1 << btn-1) ) {
          display.write((int)btn + '0'); display.write(' ');
          display.display();
          //break;
        }
      }
    }
  }
  GLCD_getBgl();
}
*/
/*
void loop() {
  if (BOOTSEL) {
    while (BOOTSEL);

    if (strlen(buf_input) > 0) {
      //Keyboard.print("run ");
      //Keyboard.println(buf_input);
      Serial.println(buf_input);
      display.clearDisplay();
      display.setCursor(0,0);
      display.print("> "); 
      display.display();
      
      clearBuf();
    }
  }
  else {
    if (checkInput()) {

      display.clearDisplay();
      display.setCursor(0,0);
      display.print("> ");
      
      if (ui_mode == UI_STDIN_DONE) {
        ui_mode = UI_WRITE;
        clearBuf();
      }
      else {
        display.print(buf_input);
        display.write(curSym);
        display.write('\n');
        display.display();
      }
      delay(30);
    }
  }
  GLCD_getBgl();
}
*/
/*
void loop() {
  if (Serial.available() > 0) {
    buf = Serial.readStringUntil('\n'); buf.trim();
    
    if (!zero_booted) {
      zero_booted = true;
      return;
    }
    
    if (buf.length())
      GLCD_print(buf, LCD_PRINTLN, true);
      

    if (buf == "#STDIN") {
        display.clearDisplay();
        display.setCursor(0,0);
        display.display();
        
        file = LittleFS.open("/stdin.txt", "w+");
        if (file) 
          file.seek(0),
          file.printf(""),
          file.close();
        
        ui_mode = UI_STDIN;
        return;
    }
    else if ((buf.substring(0, buf.indexOf(' ')) == "#HEAD") || (buf.startsWith("#HEAD"))) {
        checkHeader( buf.substring(buf.indexOf(' ')+1, buf.length()) );
        return;
    }
    else if (buf == "#EOF") {
      display.clearDisplay();
      display.setCursor(0,0);
      
      ui_mode = UI_STDIN_DONE;
      return;
    }
    // - - - - - - - - - - - -

    if (ui_mode == UI_STDIN) {
      
      file = LittleFS.open("/stdin.txt", "a");

      if (file) 
        file.printf("%s\n", buf.c_str()),
        file.close();
      
      delay(READ_DEL);
    }
  }
}
*/
// _________________________________________________________
