#include <Adafruit_TinyUSB.h>
#include "ramdisk.h"
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include <TinyUSB_Mouse_and_Keyboard.h>

#include "tree.h"
#include "graphics.h"
#include "include.h"

// ----------------------------------------

void setup() { 
  // mount usb drive
  usb_msc_enable(true);
  usb_msc.begin();  

  // open serial port /dev/ttyACM0
  Serial.begin(9600);

  // start HID keyboard device
  Keyboard.begin();
  Keyboard.releaseAll(); 
  
  pinMode( BGL_PIN, OUTPUT_12MA );
  digitalWrite( BGL_PIN, HIGH );

  GLCD_Init();
  //PWM_Init();
  
  // - - - - - - - - - - - - - - - - - 
  // initialize keypad pins
  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    // to prevent voltage fluctuations
    gpio_set_slew_rate( 
      rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  setState(BOOTING);
  
  // wait for usb drive to mount
  while (!msc_ready) yield();

  // wait for RPi Zero to either send Serial
  // or pipe "online" to msc
  while (!zero_booted) {
    if (Serial.available() || BOOTSEL) break;
    if ((millis()-T) > 1000) 
      GLCD_animate(30,6),
      T = millis();
    GLCD_getBgl();
    break; // REM
  }
  while (Serial.available()) 
    Serial.read();

  setState(BOOTED);
  zero_booted = true;

  clearBuf();
  Menu();
}
// ---------------------------------------------------------

void Menu() {
  ui_mode = UI_READ;
  setState(MENU_ON);
  
  if (!menu_init) 
    //GLCD_setBgl(ON, 30000),
    menu_init = tree::Init(&menuTree, menu_init);

  tree::Render();
}
// ---------------------------------------------------------

void textInput() {
  setState(TXT_INPUT);
  ui_mode = UI_WRITE;
  clearBuf();
  mod_mode = 0;
  GLCD_print("> ", LCD_PRINT, true);
}

// --------------------------------------------------------- 

void awaitResponse() {
  // show graphic
  GLCD_showBitmap(cat_bmp);
  
  setState(AWAIT_RESP);
  ui_mode = UI_READ;
  await_response = true;
  resp_timer = millis();
}
// ---------------------------------------------------------

void sendCommand() {
  KeyMap      *KP;
  
  GLCD_msgBox("\n  SEND COMMAND?\n\n    PRESS 5", false);

  // confirm before sending
  while (1) {
    KP = readKeyPad();
    if (KP != NULL) break;
  }
  
  if (KP->key == 5) {
    display.clearDisplay(); 
    display.display();
    delay(1000);
    
    // type command with HID keyboard
    Keyboard.println(buf_input);
    awaitResponse();
  }
  else // return to menu
    Menu(); 
}
// ---------------------------------------------------------

void loop() {
  // if mode is text input
  if (ui_mode == UI_WRITE) {
    
    // if keypad pressed, update display
    if (checkInput()) { 
      display.clearDisplay();
      display.print("> ");
      display.println(buf_input);
      display.display();
    }
    // if BOOTSEL pressed
    else if (BOOTSEL) { 
      kp_last_press = millis();
      while (BOOTSEL) {
        if ((millis()-kp_last_press) > 2000) 
          break;
      }
      // if BOOTSEL held (abort)
      if ((millis()-kp_last_press) > 2000) 
        Menu();
      else
        sendCommand(); // send text input
    }
  }
  else if (ui_mode == UI_READ) {
    
    // if menu active, read keypad
    if (getState() == MENU_ON) {
      KeyMap *KP = readKeyPad();  
      if (KP != NULL)
        tree::Navigate(KP->key);
    }
    // if waiting for response
    else if (getState() == AWAIT_RESP) {
      if ((millis()-resp_timer) > RESP_TIMEOUT) {
        GLCD_msgBox("\n  RESPONSE\n  TIMEOUT\n", false);
        delay(2000);
        
        stdin_available = false,
        await_response = false,
        Menu();
      }
      else {
        // Blink pixel on starfield
        if ( !((millis()-resp_timer)%500) )
          display.drawPixel(85, 35, KS0108_INVERSE),
          display.display();
      }
    }
    // if stdin on usb drive received
    if (stdin_available) {
      setState(STDIN_MSC);
      
      // run reader if we're expecting stdin
      if (await_response)
        Reader(),
        await_response = false;
        
      stdin_available = false;
      Menu();
    }
    // if serial available
    else if (Serial.available()) {

      // if STDIN header, write input
      if (Serial.find("#STDIN\n")) {
        int n = 0; T = millis();
        
        memset(buf_input, 0, sizeof(buf_input));
        serial_busy = true;
        setState(STDIN_SER);
        
        while (serial_busy) {
          if (Serial.available() > 0) { 
            char *eof, c = Serial.read();
            buf_input[n++] = c;
            eof = strstr(buf_input, "#EOF\n");
            T = millis();

            // if line matches EOF syntax
            if (eof) {
              *eof = '\0';
              serial_busy = false;
            }
          }
          else if ((millis()-T) > 5000)
            serial_busy = false;
        }
        // run reader if we're expecting stdin
        if (await_response)
          Reader(),
          await_response = false;
      }
      Menu();
    }
  }
}
// _________________________________________________________
