#include <Adafruit_TinyUSB.h>
#include "ramdisk.h"
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include <TinyUSB_Mouse_and_Keyboard.h>

#include "tree.h"
#include "graphics.h"
#include "include.h"

// ---------------------------------------- hel


void setup() { 
  // mount usb drive
  usb_msc_enable(true);
  usb_msc.begin();  

  // open serial port /dev/ttyACM0
  Serial.begin(9600);

  // start HID keyboard device
  Keyboard.begin();
  Keyboard.releaseAll(); 
  
  pinMode( BGL_PIN, OUTPUT_12MA );
  digitalWrite( BGL_PIN, HIGH );

  GLCD_Init();
  //PWM_Init();
  
  // - - - - - - - - - - - - - - - - - 
  // initialize keypad pins
  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    // to prevent voltage fluctuations
    gpio_set_slew_rate( 
      rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  setState(BOOTING);
  
  // wait for usb drive to mount
  while (!msc_ready) yield();

  // wait for Pi to send Serial or write to msc
  while (!zero_booted) {
    if (Serial.available() || BOOTSEL) break;
    if ((millis()-T) > 1000) 
      GLCD_intro_anim(),
      T = millis();
    GLCD_getBgl();
    break; // REM
  }
  while (Serial.available()) 
    Serial.read();

  setState(BOOTED);
  zero_booted = true;

  clearBuf();
  Menu();
}
// ---------------------------------------------------------

void loop() {
  // if mode is text input
  if (ui_mode == UI_WRITE) {
    
    if (KP_checkInput()) {
      display.clearDisplay();
      KP_showIcon(false);
      
      display.setCursor(0,0);
      display.print("> ");

      for (int i=0; i<strlen(buf_input); i++) {
        int hx = (unsigned char)buf_input[i];
        if (hx==197||hx==198||hx==216 ||
            hx==229||hx==230||hx==248)
            display.write(ascii2lcd(hx));
        else
            display.write(buf_input[i]);
      }
      
      display.write(curSym);
      display.display();
    }

    // if BOOTSEL pressed
    if (BOOTSEL) {
      kp_last_press = millis();
      while (BOOTSEL) {
        if ((millis()-kp_last_press) > 2000) 
          break;
      }
      // if BOOTSEL held (abort)
      if ((millis()-kp_last_press) > 2000) 
        Menu();
      else
        sendCommand(); // send text input
    }
  }
  else if (ui_mode == UI_READ) {
    
    // if menu active, read keypad
    if (getState() == MENU_ON) {
      KeyMap *KP = readKeyPad();  
      if (KP != NULL)
        tree::Navigate(KP->key);
    }
    // if waiting for response
    else if (getState() == AWAIT_RESP) {
      if ((millis()-resp_timer) > RESP_TIMEOUT) {
        GLCD_msgBox("\n    RESPONSE\n    TIMEOUT\n", false);
        delay(2000);
        
        stdin_available = false,
        await_response = false,
        Menu();
      }
      else {
        GLCD_intro_anim();
        /*
        // Blink pixel on starfield
        if ( !((millis()-resp_timer)%500) )
          display.drawPixel(85, 35, KS0108_INVERSE),
          display.display();
        */
      }
    }
    // if stdin on usb drive received
    if (stdin_available) {
      setState(STDIN_MSC);
      
      // run reader if we're expecting stdin
      if (await_response)
        Reader(),
        await_response = false;
        
      stdin_available = false;
      Menu();
    }
    // if serial available
    else if (Serial.available()) {

      // if STDIN header, write input
      if (Serial.find("#STDIN\n")) {
        int n = 0; T = millis();
        
        memset(buf_input, 0, sizeof(buf_input));
        serial_busy = true;
        setState(STDIN_SER);
        
        while (serial_busy) {
          if (Serial.available() > 0) { 
            char *eof, c = Serial.read();
            buf_input[n++] = c;
            eof = strstr(buf_input, "#EOF\n");
            T = millis();

            // if line matches EOF syntax
            if (eof) {
              *eof = '\0';
              serial_busy = false;
            }
          }
          else if ((millis()-T) > 5000)
            serial_busy = false;
        }
        // run reader if we're expecting stdin
        if (await_response)
          Reader(),
          await_response = false;
      }
      Menu();
    }
  }
}
// _________________________________________________________


/* // INT TO HEXADECIMAL (DUAL) BYTE(S)

int16_t value = 253; // Example >255 value
char bytes[3];

bytes[0] = (char)(value >> 8);    // High byte
bytes[1] = (char)(value & 0xFF);  // Low byte  
bytes[2] = '\0';

// To reconstruct:
int16_t reconstructed = (bytes[0] << 8) | bytes[1];
Serial.print("reconstructed: "); Serial.println(reconstructed);
Serial.println((char)reconstructed);

int val1 = (unsigned char)str3[0]; 
Serial.println(val1);
 */
