  
#include <Adafruit_TinyUSB.h>
#include "ramdisk.h"
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include <TinyUSB_Mouse_and_Keyboard.h>
#include <TimeLib.h>

#include "tree.h"
#include "graphics.h"
#include "include.h"

// ---------------------------------------- 

void setup() { 
  // mount usb drive
  usb_msc_enable(true);
  usb_msc.begin();  

  // open serial port /dev/ttyACM0
  Serial.begin(9600);

  // start HID keyboard device
  Keyboard.begin();
  Keyboard.releaseAll(); 
  
  pinMode( BGL_PIN, OUTPUT_12MA );
  digitalWrite( BGL_PIN, HIGH );

  GLCD_Init();
  //PWM_Init();
  
  // - - - - - - - - - - - - - - - - - 
  // initialize keypad pins
  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    // to prevent voltage fluctuations
    gpio_set_slew_rate( 
      rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  setState(BOOTING);
  
  // wait for usb drive to mount
  while (!msc_ready) yield();
  
  setSyncProvider(requestSync);
  
  // wait for Pi to send Serial or write to msc
  while (!zero_booted) {
    if (Serial.available() || BOOTSEL) break;
    if ((millis()-T) > 1000) 
      GLCD_anim(),
      T = millis();
    GLCD_getBgl();
  }
  
  setState(BOOTED);
  zero_booted = true;

  clearBuf();
  Menu();
}
// ---------------------------------------------------------

void digitalClockDisplay(){
  // digital clock display of the time
  Serial.print(hour());
  Serial.print(" ");
  Serial.print(day());
  Serial.print(" ");
  Serial.print(month());
  Serial.print(" ");
  Serial.print(year()); 
  Serial.println(); 
}

void sys_setClock(const char* raw) {
  unsigned long x = strtol(raw, 0, 10);
  setTime(x); 
}
// ---------------------------------------------------------

void sys_showDate() {
  if (timeStatus() != timeNotSet) {
    //display.setFont(&Picopixel); 
    display.setCursor(0,5);
    display.print(year());
    display.print("/");
    display.print(month());
    display.print("/");
    display.println(day());
    //display.display();
  }
}

const char* months[12] = {
  "Jan","Feb","Mar",
  "Apr","May","Jun",
  "Jul","Aug","Sep",
  "Oct","Nov","Dec"
};

void sys_tickClock() {
  if (timeStatus() != timeNotSet) {
    display.setFont(&Picopixel); 
    display.clearDisplay();

    display.setCursor(2,5);
    //display.print(String(year()).substring(2,4));
    display.print(months[ ((atoi((const char*)month()))+2)%12 ]);
    //display.print((day()<10)?" ":"");
    display.print(day());
    
    

    display.setCursor(110,6); 
    display.print(hour());
    display.setTextColor((second()%2)?1:0); 
    display.print(":");
    display.setTextColor(1);
    display.print((minute()<10)?"0":"");
    display.print(minute()); 
    //display.print(":");
    //display.print((second()<10)?"0":"");
    //display.print(second());

    display.drawLine(0,8,display.width(),8,1);
    display.display();
     
    display.setFont(NULL); 
    delay(1000);
  }
}
// ---------------------------------------------------------

void loop() {
  int n;
  
  // if mode is text input
  if (ui_mode == UI_WRITE) {
    
    if (KP_checkInput()) {
      display.clearDisplay();
      KP_showIcon(false);
      
      display.setCursor(0,0);
      display.print("> ");

      for (int i=0; i<strlen(buf_input); i++) {
        int hx = (unsigned char)buf_input[i];
        if (hx==197||hx==198||hx==216 ||
            hx==229||hx==230||hx==248)
            display.write(ascii2lcd(hx));
        else
            display.write(buf_input[i]);
      }
      
      display.write(curSym);
      display.display();
    }

    if (BOOTSEL) {
      kp_last_press = millis();
      while (BOOTSEL) {
        if ((millis()-kp_last_press) > 2000) 
          break;
      }
      if ((millis()-kp_last_press) > 2000) 
        Menu();
      else
        sendCommand(); // send text input
    }
  }
  else if (ui_mode == UI_READ) {
    KeyMap *KP = readKeyPad();
    
    if ((getState() == MENU_ON) && (KP != NULL))
      tree::Navigate(KP->key);
      
    else if (getState() == AWAIT_RESP) {
      if ((millis()-resp_timer) > RESP_TIMEOUT) {
        GLCD_msgBox("\n    RESPONSE\n    TIMEOUT\n", false);
        delay(2000);
        
        stdin_available = false,
        await_response = false,
        Menu();
      }
      else {
        GLCD_anim();
      }
    }
    
    // if stdin on usb drive received
    if (stdin_available) {
      setState(STDIN_MSC);
      
      if (await_response)
        Reader(),
        await_response = false;
        
      stdin_available = false;
      Menu();
    }
    
    if (Serial.available()) {
      if (Serial.find("#HEAD ")) {
        memset(header, '\0', sizeof(header)-1);
        n = Serial.readBytesUntil('\n', header, sizeof(header)-1);
        header[n] = '\0';
        storeHeader(header);
        header_t *h = &(header_data[HEAD_PARAMS]);

        if (strcmp(h->data, "DT") == 0) {
          h = &(header_data[HEAD_DATA]);
          sys_setClock((const char*)h->data);
          while(1) 
            sys_tickClock();
        }
        
        display.clearDisplay();          
        for (int i=0; i<HEAD_ENUM_N; i++) {
          display.print(i); display.print(" (");
          display.print(header_data[i].label);
          display.print(") = '");
          display.print(header_data[i].data);
          display.println("'");
          display.display();
          delay(200);
        }
        delay(5000);
      }
    
      if (Serial.find("#STDIN\n")) {
        n = 0; 
        T = millis();
        
        memset(buf_input, 0, sizeof(buf_input));
        serial_busy = true;
        setState(STDIN_SER);
        
        while (serial_busy) {
          if (Serial.available() > 0) { 
            char *eof, c = Serial.read();
            buf_input[n++] = c;
            eof = strstr(buf_input, "#EOF\n");
            T = millis();

            if (eof) {
              *eof = '\0';
              serial_busy = false;
            }
          }
          else if ((millis()-T) > 5000)
            serial_busy = false;
        }

        if (await_response)
          Reader(),
          await_response = false;
      }
      

         
      Menu();
    }
  }
}
// _________________________________________________________


/* // INT TO HEXADECIMAL (DUAL) BYTE(S)

int16_t value = 253; // Example >255 value
char bytes[3];

bytes[0] = (char)(value >> 8);    // High byte
bytes[1] = (char)(value & 0xFF);  // Low byte  
bytes[2] = '\0';

// To reconstruct:
int16_t reconstructed = (bytes[0] << 8) | bytes[1];
Serial.print("reconstructed: "); Serial.println(reconstructed);
Serial.println((char)reconstructed);

int val1 = (unsigned char)str3[0]; 
Serial.println(val1);
 */
