  
#include <Adafruit_TinyUSB.h>
#include "ramdisk.h"
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include <TinyUSB_Mouse_and_Keyboard.h>
#include <TimeLib.h>

#include "tree.h"
#include "graphics.h"
#include "include.h"

// ---------------------------------------- 

void setup() { 
  // mount usb drive
  usb_msc_enable(true);
  usb_msc.begin();  

  // open serial port /dev/ttyACM0
  Serial.begin(9600);

  // start HID keyboard device
  Keyboard.begin();
  Keyboard.releaseAll(); 
  
  pinMode( BGL_PIN, OUTPUT_12MA );
  digitalWrite( BGL_PIN, HIGH );

  GLCD_Init();
  //PWM_Init();
  
  // - - - - - - - - - - - - - - - - - 
  // initialize keypad pins
  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    // to prevent voltage fluctuations
    gpio_set_slew_rate( 
      rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  setState(BOOTING);
  
  // wait for usb drive to mount
  while (!msc_ready) yield();
  
  setSyncProvider(requestSync);
  
  // wait for Pi to send Serial or write to msc
  while (!zero_booted) {
    if (Serial.available() || BOOTSEL) break;
    if ((millis()-T) > 1000) 
      GLCD_anim(),
      T = millis();
    GLCD_getBgl();
  }
  
  setState(BOOTED);
  zero_booted = true;
  
  menu_init = tree::Init(&menuTree, menu_init);
  
  clearBuf();
  Home();
}
// ---------------------------------------------------------

void Home() {
  setState(HOME_ON);
  ui_mode = UI_READ;

  display.clearDisplay();
  display.drawBitmap((display.width()-BMP_WIDTH)/2, (display.height()-BMP_HEIGHT)/2, home_bmp, BMP_WIDTH, BMP_HEIGHT, 1);
  display.display();
  display.drawBitmap((display.width()-BMP_HLF_WIDTH), (display.height()-BMP_HLF_HEIGHT)/2, sunrise_bmp_64, BMP_HLF_WIDTH, BMP_HLF_HEIGHT, 1);
  display.display();
  //delay(5000);
  
  /*
  display.clearDisplay();
  display.drawBitmap((display.width()-BMP_WIDTH)/2, (display.height()-BMP_HEIGHT)/2, home_bmp, BMP_WIDTH, BMP_HEIGHT, 1);
  display.display();
  display.drawBitmap((display.width()-BMP_HLF_WIDTH), (display.height()-BMP_HLF_HEIGHT)/2, moon_bmp_64, BMP_HLF_WIDTH, BMP_HLF_HEIGHT, 1);
  display.display();
  delay(5000);

  display.clearDisplay();
  display.drawBitmap((display.width()-BMP_WIDTH)/2, (display.height()-BMP_HEIGHT)/2, home_bmp, BMP_WIDTH, BMP_HEIGHT, 1);
  display.display();
  display.drawBitmap((display.width()-BMP_HLF_WIDTH), (display.height()-BMP_HLF_HEIGHT)/2, sunset_bmp_64, BMP_HLF_WIDTH, BMP_HLF_HEIGHT, 1);
  display.display();
  delay(5000);

  display.clearDisplay();
  display.drawBitmap((display.width()-BMP_WIDTH)/2, (display.height()-BMP_HEIGHT)/2, home_bmp, BMP_WIDTH, BMP_HEIGHT, 1);
  display.display();
  display.drawBitmap((display.width()-BMP_HLF_WIDTH), (display.height()-BMP_HLF_HEIGHT)/2, cat_moon_bmp_64, BMP_HLF_WIDTH, BMP_HLF_HEIGHT, 1);
  display.display();
  delay(5000);

  display.clearDisplay();
  display.drawBitmap((display.width()-BMP_WIDTH)/2, (display.height()-BMP_HEIGHT)/2, home_bmp, BMP_WIDTH, BMP_HEIGHT, 1);
  display.display();
  display.drawBitmap((display.width()-BMP_HLF_WIDTH), (display.height()-BMP_HLF_HEIGHT)/2, sunrise_bmp_64, BMP_HLF_WIDTH, BMP_HLF_HEIGHT, 1);
  display.display();
  delay(5000);
  */
  printTopBar("HOME");
  display.drawLine(display.width()/2, 0, display.width()/2, display.height()-1, KS0108_ON);
  display.setFont(&Picopixel); 
  display.setCursor(2,14);
  display.print("Date:");
  

  display.setFont(NULL); 
  display.setCursor(0,0);
  display.display();
}

// ---------------------------------------------------------

void sys_setClock(const char* raw) {
  unsigned long x = strtol(raw, 0, 10);
  setTime(x); 
}
// ---------------------------------------------------------

void sys_showDate() {
  if (timeStatus() != timeNotSet) {
    //display.setFont(&Picopixel); 
    display.setCursor(0,5);
    display.print(year());
    display.print("/");
    display.print(month());
    display.print("/");
    display.println(day());
    //display.display();
  }
}
// ---------------------------------------------------------

const char* months[12] = {
  "Jan","Feb","Mar",
  "Apr","May","Jun",
  "Jul","Aug","Sep",
  "Oct","Nov","Dec"
};
// ---------------------------------------------------------

void sys_tickClock() {
  if (timeStatus() != timeNotSet) {
    display.setFont(&Picopixel); 
    /*
    display.setCursor(1,5);
    //display.print(String(year()).substring(2,4));
    display.print(months[ ((atoi((const char*)month()))+2)%12 ]);
    //display.print((day()<10)?" ":"");
    display.print(day());
    */
    display.fillRect(111,1,display.width()-2, 7, 0);
    display.setCursor(111,6); 
    display.print(hour());
    display.setTextColor((second()%2)?1:0); 
    display.print(":");
    display.setTextColor(1);
    display.print((minute()<10)?"0":"");
    display.print(minute()); 
    //display.print(":");
    //display.print((second()<10)?"0":"");
    //display.print(second());
    display.drawLine(display.width()-1,0,display.width()-1,8,1);
    display.setFont(NULL); 
    display.display();
    //delay(1000);
  }
}
// ---------------------------------------------------------

void printTopBar(const char* title) {
  //struct TreeNode* entry = (tree::node_active == NULL) ? &(menuTree) : tree::node_active;
  
  //display.clearDisplay();
  display.fillRect(0,0,display.width()-1, 8, 0);
  
  if (tree::node_active != NULL)
    tree::showTitle((title == NULL) ? tree::node_active->label : title);
  
  if (timeStatus() != timeNotSet) 
    sys_tickClock();
  display.display();
}
// ---------------------------------------------------------

char *str_parts(char *str, bool last=1, const char* delim = " ") {
  return (last) ? ( strchr(str,delim[0]) ? strchr(str,delim[0])+1 : str ) : strtok(str, delim);
}
// ---------------------------------------------------------


void SysData_store(const char* data) {
  char inBuf[strlen(data)+1] = {'\0'};
  strcpy(inBuf, data);
  display.clearDisplay();
  display.println("Data:");
  display.println(inBuf);
  display.display();
  delay(2000);
}

void MSC_getHeader(char* str) {
  if ((str[0] != '#') || (strstr(str,"#HEAD") == NULL)) return;
  char *p = strchr(str, ' ');
  int n;
  header_t *h;

  if (!p) return;
  
  n = p-str, str += n+1;
  p = strchr(str, '\n');

  if (p) {
    *p = '\0';
    storeHeader(str);
    *p = '\n';
    n = p-str, str += n+1;
    
    if ((strcmp(header_data[HEAD_TYPE].data,   "SYS") == 0) 
    &&  (strcmp(header_data[HEAD_ACTION].data, "STORE") == 0)
    &&  (strcmp(header_data[HEAD_PARAMS].data, "HOSTDATA") == 0)
    &&  (strcmp(header_data[HEAD_DATA].data,   "MSC") == 0)) {      
      char *token = strtok(str, "\n");
      if (!token) return;
      do {
        SysData_store(token);
        token = strtok(nullptr, "\n");
      } while (token);
      }
    }

    /*
    display.clearDisplay();
    for (int i=0; i<HEAD_ENUM_N; i++) {
      h = &(header_data[i]);
      display.print(h->label);
      display.print(" ");
      display.println(h->data);
      display.display();
      delay(1000);  
    }
    delay(2000);
    */
    /*
    n = p-str;
    *str
    str = str-n;
    */
    
    /*
    char buf[n] = {'\0'};
    strncpy(buf, str, n);
    
    display.clearDisplay();
    for (int i=0; i<n; i++) {
      display.write(str[i]);
      display.display();
      delay(100);
    }
    delay(2000);
    */
  }
}

/*
bool checkLine(char* str, char last = '\n', char first = NULL) {
  char *cpos = strchr(str, last);
  int n = (cpos-str);

  if ((first != NULL) && (str[0] != first)) return false;

  if (cpos) {
    if (n > 32) return false;
    char buf[n] = {'\0'};
    strncpy(buf, str, n);
    Serial.print("buf: '"); Serial.print(buf); Serial.println("'");
  }
  return false;
}
*/


//void sysData_store(const char* s, );
/*
void MSC_getHeader(char* str) {
  if ((str[0] != '#') || (strstr(str,"#HEAD") == NULL)) return;
  
  header_t *h;
  int n;
  char *p1, *p = strchr(str, ' ');
  if (!p) return;

  n = p-str, str += n+1;
  
  p1 = strchr(str,'\n');
  if (p1)
    n = (p1-str);

  char inBuf[32];
  char tmp[n+1] = {'\0'};
  strncpy(tmp, str, n);
  storeHeader(tmp);
  str += n; n=0;

  display.clearDisplay();
  for (int i=0; i<HEAD_ENUM_N; i++) {
    h = &(header_data[i]);
    display.print(h->label);
    display.print(" ");
    display.println(h->data);
    display.display();
    delay(1000);  
  }
  delay(2000);
  
  
  //if ((header_data[HEAD_TYPE].data == "SYS") && (header_data[HEAD_ACTION].data == "STORE")) {
    //if ((header_data[HEAD_PARAMS].data == "HOSTDATA") && (header_data[HEAD_DATA].data == "MSC")) {      
      char *token = strtok(str, "\n");

      display.clearDisplay();
      do {
        display.println(token);
        display.display();
        delay(1000);
        token = strtok(nullptr, "\n");
      } while (token);
    //}
  //}
}
*/
// ---------------------------------------------------------

void loop() {
  int n;
  
  // if mode is text input
  if (ui_mode == UI_WRITE) {
    
    if (KP_checkInput()) {
      display.clearDisplay();
      KP_showIcon(false);
      
      display.setCursor(0,0);
      display.print("> ");

      for (int i=0; i<strlen(buf_input); i++) {
        int hx = (unsigned char)buf_input[i];
        if (hx==197||hx==198||hx==216 ||
            hx==229||hx==230||hx==248)
            display.write(ascii2lcd(hx));
        else
            display.write(buf_input[i]);
      }
      
      display.write(curSym);
      display.display();
    }

    if (BOOTSEL) {
      kp_last_press = millis();
      while (BOOTSEL) {
        if ((millis()-kp_last_press) > 2000) 
          break;
      }
      if ((millis()-kp_last_press) > 2000) 
        Home();
      else
        sendCommand(); // send text input
    }
  }
  else if (ui_mode == UI_READ) {
    KeyMap *KP = readKeyPad();
    sys_tickClock();
    
    if ((getState() == MENU_ON) && (KP != NULL))
      tree::Navigate(KP->key);
      
    else if (getState() == HOME_ON) {
      if (KP != NULL)
        if (KP->key != 10)
          Menu();  
    }
    else if (getState() == AWAIT_RESP) {
      if ((millis()-resp_timer) > RESP_TIMEOUT) {
        GLCD_msgBox("\n    RESPONSE\n    TIMEOUT\n", false);
        delay(2000);
        
        stdin_available = false;  
        await_response = false;
       
        Home();
      }
      else {
        GLCD_anim();
      }
    }
    
    // if stdin on usb drive received
    if (stdin_available) {
      if ((stdin_buf[0] == '#') && (strstr(stdin_buf,"#HEAD") != NULL))
        MSC_getHeader(stdin_buf);
      
      /*
      if (await_response)
        Reader("MSC"),
        await_response = false;
      else
        MSC_readBuf(stdin_buf);
      */
      stdin_available = false;
      
      if (getState() == MENU_ON)
        Menu();
      else if (getState() == HOME_ON)
        Home();
    }
    
    if (Serial.available()) {
      if (Serial.find("#HEAD ")) {
        memset(header, '\0', sizeof(header)-1);
        n = Serial.readBytesUntil('\n', header, sizeof(header)-1);
        header[n] = '\0';
        storeHeader(header);
        header_t *h = &(header_data[HEAD_PARAMS]);

        if (strcmp(h->data, "DT") == 0) {
          h = &(header_data[HEAD_DATA]);
          sys_setClock((const char*)h->data);
          //while(1) sys_tickClock();
        }
      }
    
      if (Serial.find("#STDIN\n")) {
        n = 0; 
        T = millis();
        
        memset(buf_input, 0, sizeof(buf_input));
        serial_busy = true;
        //setState(STDIN_SER);
        
        while (serial_busy) {
          if (Serial.available() > 0) { 
            char *eof, c = Serial.read();
            buf_input[n++] = c;
            eof = strstr(buf_input, "#EOF\n");
            T = millis();

            if (eof) {
              *eof = '\0';
              serial_busy = false;
            }
          }
          else if ((millis()-T) > 5000)
            serial_busy = false;
        }

        if (await_response)
          Reader("SER"),
          await_response = false;
      }  
      if (getState() == MENU_ON)
        Menu();
      else if (getState() == HOME_ON)
        Home();
    }
  }
}
// _________________________________________________________


/* // INT TO HEXADECIMAL (DUAL) BYTE(S)

int16_t value = 253; // Example >255 value
char bytes[3];

bytes[0] = (char)(value >> 8);    // High byte
bytes[1] = (char)(value & 0xFF);  // Low byte  
bytes[2] = '\0';

// To reconstruct:
int16_t reconstructed = (bytes[0] << 8) | bytes[1];
Serial.print("reconstructed: "); Serial.println(reconstructed);
Serial.println((char)reconstructed);

int val1 = (unsigned char)str3[0]; 
Serial.println(val1);
 */
