  
#include <Adafruit_TinyUSB.h>
#include "ramdisk.h"
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include <TinyUSB_Mouse_and_Keyboard.h>
#include <TimeLib.h>

#include "tree.h"
#include "graphics.h"
#include "include.h"

// ---------------------------------------- 

void setup() { 
  // mount usb drive
  usb_msc_enable(true);
  usb_msc.begin();  

  // open serial port /dev/ttyACM0
  Serial.begin(9600);

  // start HID keyboard device
  Keyboard.begin();
  Keyboard.releaseAll(); 
  
  pinMode( BGL_PIN, OUTPUT_12MA );
  digitalWrite( BGL_PIN, HIGH );

  GLCD_Init();
  //PWM_Init();
  
  // - - - - - - - - - - - - - - - - - 
  // initialize keypad pins
  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    // to prevent voltage fluctuations
    gpio_set_slew_rate( rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  setState(BOOTING);
  
  // wait for usb drive to mount
  while (!msc_ready) yield();
  
  setSyncProvider(requestSync);
  
  // wait for Pi to send Serial or write to msc
  while (!zero_booted) {
    if (Serial.available() || BOOTSEL) break;
    if ((millis()-T) > 1000) 
      GLCD_anim(),
      T = millis();
    GLCD_getBgl();
  }
  
  setState(BOOTED);
  zero_booted = true;
  
  menu_init = tree::Init(&menuTree, menu_init);
  
  clearBuf();
  Home();
}
// ---------------------------------------------------------

void printSysData(int16_t xPos, int16_t yPos) {
  if (getState() != HOME_ON) return;

  display.setFont(&Picopixel); 
  display.setCursor(xPos,yPos);
  
  const char *group, *key, *val;

  for (int i=0; i<ArrLen(homeScreen); i++) {
    display.print(homeScreen[i].name);
    //display.print(":");
    display.setCursor(21, yPos);
    display.println(homeScreen[i].content);
    yPos = display.getCursorY();
    display.setCursor(xPos, yPos);
  }
  display.drawLine(18, 8, 18, display.height()-1, KS0108_ON);
  display.display();
}

// ---------------------------------------------------------

void Home() {
  setState(HOME_ON);
  ui_mode = UI_READ;

  display.clearDisplay();
  display.drawBitmap((display.width()-BMP_WIDTH)/2, (display.height()-BMP_HEIGHT)/2, home_bmp, BMP_WIDTH, BMP_HEIGHT, 1);
  display.display();
  display.drawBitmap((display.width()-BMP_HLF_WIDTH), (display.height()-BMP_HLF_HEIGHT)/2, clouds_bmp_64, BMP_HLF_WIDTH, BMP_HLF_HEIGHT, 1);
  display.display();

  //delay(5000);
  
  /*
  display.clearDisplay();
  display.drawBitmap((display.width()-BMP_WIDTH)/2, (display.height()-BMP_HEIGHT)/2, home_bmp, BMP_WIDTH, BMP_HEIGHT, 1);
  display.display();
  display.drawBitmap((display.width()-BMP_HLF_WIDTH), (display.height()-BMP_HLF_HEIGHT)/2, moon_bmp_64, BMP_HLF_WIDTH, BMP_HLF_HEIGHT, 1);
  display.display();
  delay(5000);

  display.clearDisplay();
  display.drawBitmap((display.width()-BMP_WIDTH)/2, (display.height()-BMP_HEIGHT)/2, home_bmp, BMP_WIDTH, BMP_HEIGHT, 1);
  display.display();
  display.drawBitmap((display.width()-BMP_HLF_WIDTH), (display.height()-BMP_HLF_HEIGHT)/2, sunset_bmp_64, BMP_HLF_WIDTH, BMP_HLF_HEIGHT, 1);
  display.display();
  delay(5000);

  display.clearDisplay();
  display.drawBitmap((display.width()-BMP_WIDTH)/2, (display.height()-BMP_HEIGHT)/2, home_bmp, BMP_WIDTH, BMP_HEIGHT, 1);
  display.display();
  display.drawBitmap((display.width()-BMP_HLF_WIDTH), (display.height()-BMP_HLF_HEIGHT)/2, cat_moon_bmp_64, BMP_HLF_WIDTH, BMP_HLF_HEIGHT, 1);
  display.display();
  delay(5000);

  display.clearDisplay();
  display.drawBitmap((display.width()-BMP_WIDTH)/2, (display.height()-BMP_HEIGHT)/2, home_bmp, BMP_WIDTH, BMP_HEIGHT, 1);
  display.display();
  display.drawBitmap((display.width()-BMP_HLF_WIDTH), (display.height()-BMP_HLF_HEIGHT)/2, sunrise_bmp_64, BMP_HLF_WIDTH, BMP_HLF_HEIGHT, 1);
  display.display();
  delay(5000);
  */
  printTopBar("HOME");

  display.drawLine(display.width()/2, 8, display.width()/2, display.height()-1, KS0108_ON);
  
  if (sysData_written) 
    printSysData(2, 14);
  
  display.setFont(NULL); 
  display.setCursor(0,0);
  display.display();
}

// ---------------------------------------------------------

void sys_setClock(const char* raw) {
  unsigned long x = strtol(raw, 0, 10);
  setTime(x); 
}
// ---------------------------------------------------------

String sys_dateTimeStr(const int (&arr)[3], const char* sep = ":") {
  String val = "";
  int index = 0;

  for (const int &n : arr) 
    val = val
    + ((n<10) ? "0" : "") 
    + String(n) 
    + ((++index < 3) ? sep : "");

  return val;
}
// ---------------------------------------------------------


void sys_tickClock() {
  String t_str = "--:--";
  display.setFont(&Picopixel);

  if (timeStatus() != timeNotSet) {
    dateStr = sys_dateTimeStr({year(), month(), day()}, "-");
    memset(homeScreen[0].content, '\0', sizeof(homeScreen[0].content));
    strcpy(homeScreen[0].content, dateStr.c_str());

    timeStr = sys_dateTimeStr({hour(), minute(), second()}, ":");
    memset(homeScreen[1].content, '\0', sizeof(homeScreen[1].content));
    strcpy(homeScreen[1].content, timeStr.c_str());

    t_str = timeStr.substring(0, timeStr.lastIndexOf(':'));

    if ((getState() == HOME_ON) && sysData_written) {
      display.fillRect(21,10,42,12,0);
      display.setCursor(21, 14);
      display.println(homeScreen[0].content);
      display.setCursor(21, display.getCursorY());
      display.println(homeScreen[1].content);
    } 
  }

  display.fillRect(111,1,display.width()-2, 7, 0);
  display.setCursor(109,6);
  display.print(t_str);

  display.drawLine(display.width()-1,0,display.width()-1,8,1);
  display.setFont(NULL); 
  display.display();
}

/*
void sys_tickClock() {
  display.fillRect(111,1,display.width()-2, 7, 0);
  
  display.setFont(&Picopixel);
  
  if (timeStatus() != timeNotSet) {
    display.setCursor(109,6);

    
    //display.setCursor(1,5);
    //display.print(String(year()).substring(2,4));
    //display.print(months[ ((atoi((const char*)month()))+2)%12 ]);
    //display.print((day()<10)?" ":"");
    //display.print(day());
    
    display.print((hour()<10)?"0":"");
    display.print(hour());
    display.setTextColor((second()%2)?1:0); 
    display.print(":");
    display.setTextColor(1);
    display.print((minute()<10)?"0":"");
    display.print(minute()); 
    //display.print(":");
    //display.print((second()<10)?"0":"");
    //display.print(second());
    //delay(1000);

    dateStr = sys_dateTimeStr({year(), month(), day()}, "-");
    memset(homeScreen[0].content, '\0', sizeof(homeScreen[0].content));
    strcpy(homeScreen[0].content, dateStr.c_str());

    timeStr = sys_dateTimeStr({hour(), minute(), second()}, ":");
    memset(homeScreen[1].content, '\0', sizeof(homeScreen[1].content));
    strcpy(homeScreen[1].content, timeStr.c_str());
  }
  else {
    display.setCursor(109,6);
    display.print("--:--");
  }
  display.drawLine(display.width()-1,0,display.width()-1,8,1);
  display.setFont(NULL); 
  display.display();
}
*/
// ---------------------------------------------------------

void printTopBar(const char* title) {
  //struct TreeNode* entry = (tree::node_active == NULL) ? &(menuTree) : tree::node_active;
  
  //display.clearDisplay();
  display.fillRect(0,0,display.width()-1, 8, 0);
  
  if (tree::node_active != NULL)
    tree::showTitle((title == NULL) ? tree::node_active->label : title);
  
  sys_tickClock();
  
  display.display();
}

// ---------------------------------------------------------

void SysData_checkData() {
  const char *group, *key, *val;

  for (int i=0; i<ArrLen(homeScreen); i++)
    memset(
      homeScreen[i].content, '\0', 
      sizeof(homeScreen[i].content)
    );

  for (int i=0; i<ArrLen(SysData); i++) {
    for (int n=0; n<ArrLen(SysData[i].kv); n++) {
      if (SysData[i].kv[n].id > 0) {
        group = SysData[i].key;
        key = SysData[i].kv[n].key;
        val = SysData[i].kv[n].val;
        if (strcmp(group, "DT")) {
          if (strcmp(key, "epoch") == 0)
            sys_setClock(val);
          else if (strcmp(key, "date") == 0)
            strcpy(homeScreen[0].content, val);
          else if (strcmp(key, "time") == 0)
            strcpy(homeScreen[1].content, val);
        }
        else if (strcmp(group, "DN")) {
          if (strcmp(key, "type") == 0) {
            int x = atoi(val);
            const char* day_type = (x > 0 && x < 3) ? "day" : "night";
            strcpy(homeScreen[2].name, day_type);
          }
          else if (strcmp(key, "pct") == 0) {
            strcpy(homeScreen[2].content, val);
            strcat(homeScreen[2].content, "%");
          }
        }
      }
    }
  }  
}

// ---------------------------------------------------------

bool SysData_store(String data) {
  String gkey, values, subval, key, val;
  bool success = false;
  data_kv_group *group = nullptr;
  data_kv *item = nullptr;
  
  gkey = data.substring(0, data.indexOf('='));
  values = data.substring(data.indexOf('=')+1);

  for (int i=0; i<ArrLen(SysData); i++) {
    if (strcmp(gkey.c_str(), SysData[i].key) == 0) {
      group = &(SysData[i]);
      break;
    }
  }

  if (group != NULL) {
    int idx = 0;

    do {
      idx = values.indexOf(',');
      subval = values.substring(0, ((idx<0)?values.length():idx));
      key = subval.substring(0, subval.indexOf(':'));
      val = subval.substring(subval.indexOf(':')+1);

      for (int i=0; i<ArrLen(group->kv); i++) {
        item = &(group->kv[i]);
        if (item->id > 0) {
          if (strcmp(item->key, key.c_str()) == 0) {
            memset(item->val, 0, sizeof(item->val));
            strcpy(item->val, val.c_str());

            //if (key == "epoch") sys_setClock(val.c_str());
            success = true;
          }
        }
      }
      values = values.substring(idx+1, values.length());
    } while (idx >= 0);
  }
  return success;
}
// ---------------------------------------------------------

void MSC_getHeader(char* str) {
  if ((str[0] != '#') || (strstr(str,"#HEAD") == NULL)) return;
  char *p = strchr(str, ' ');
  String s;
  int n;
  header_t *h;

  if (!p) return;
  
  n = p-str, str += n+1;
  p = strchr(str, '\n');

  if (p) {
    *p = '\0';
    storeHeader(str);
    *p = '\n';
    n = p-str, str += n+1;
    
    if ((strcmp(header_data[HEAD_TYPE].data,   "SYS") == 0) 
    &&  (strcmp(header_data[HEAD_ACTION].data, "STORE") == 0)
    &&  (strcmp(header_data[HEAD_PARAMS].data, "HOSTDATA") == 0)
    &&  (strcmp(header_data[HEAD_DATA].data,   "MSC") == 0)) {      
      char *token = strtok(str, "\n");
      if (!token) return;
      do {
        bool rc = SysData_store(String(token));
        if (!sysData_written && rc) 
          sysData_written = true;
          
        token = strtok(nullptr, "\n");
      } while (token);
      //SysData_checkData();
      Home();
    }
  }
}

// ---------------------------------------------------------

void loop() {
  int n;
  
  // if mode is text input
  if (ui_mode == UI_WRITE) {
    
    if (KP_checkInput()) {
      display.clearDisplay();
      KP_showIcon(false);
      
      display.setCursor(0,0);
      display.print("> ");

      for (int i=0; i<strlen(buf_input); i++) {
        int hx = (unsigned char)buf_input[i];
        if (hx==197||hx==198||hx==216 ||
            hx==229||hx==230||hx==248)
            display.write(ascii2lcd(hx));
        else
            display.write(buf_input[i]);
      }
      
      display.write(curSym);
      display.display();
    }

    if (BOOTSEL) {
      kp_last_press = millis();
      while (BOOTSEL) {
        if ((millis()-kp_last_press) > 2000) 
          break;
      }
      if ((millis()-kp_last_press) > 2000) 
        Home();
      else
        sendCommand();
    }
  }
  else if (ui_mode == UI_READ) {
    KeyMap *KP = readKeyPad();
    sys_tickClock();
    
    if ((getState() == MENU_ON) && (KP != NULL))
      tree::Navigate(KP->key);
      
    else if (getState() == HOME_ON) {
      if (KP != NULL)
        if (KP->key != 10)
          Menu();  
    }
    else if (getState() == AWAIT_RESP) {
      if ((millis()-resp_timer) > RESP_TIMEOUT) {
        GLCD_msgBox("\n    RESPONSE\n    TIMEOUT\n", false);
        delay(2000);
        
        stdin_available = false;  
        await_response = false;
       
        Home();
      }
      else {
        GLCD_anim();
      }
    }
    
    // if stdin on usb drive received
    if (stdin_available) {
      if ((stdin_buf[0] == '#') && (strstr(stdin_buf,"#HEAD") != NULL))
        MSC_getHeader(stdin_buf);
        
      else if (await_response)
        Reader("MSC"),
        await_response = false;
      
      stdin_available = false;
      
      if (getState() == MENU_ON)
        Menu();
      else if (getState() == HOME_ON)
        Home();
    }
    
    if (Serial.available()) {
      if (Serial.find("#HEAD ")) {
        memset(header, '\0', sizeof(header)-1);
        n = Serial.readBytesUntil('\n', header, sizeof(header)-1);
        header[n] = '\0';
        storeHeader(header);
        header_t *h = &(header_data[HEAD_PARAMS]);

        if (strcmp(h->data, "DT") == 0) {
          h = &(header_data[HEAD_DATA]);
          sys_setClock((const char*)h->data);
          //while(1) sys_tickClock();
        }
      }
    
      if (Serial.find("#STDIN\n")) {
        n = 0; 
        T = millis();
        
        memset(buf_input, 0, sizeof(buf_input));
        serial_busy = true;
        //setState(STDIN_SER);
        
        while (serial_busy) {
          if (Serial.available() > 0) { 
            char *eof, c = Serial.read();
            buf_input[n++] = c;
            eof = strstr(buf_input, "#EOF\n");
            T = millis();

            if (eof) {
              *eof = '\0';
              serial_busy = false;
            }
          }
          else if ((millis()-T) > 5000)
            serial_busy = false;
        }

        if (await_response)
          Reader("SER"),
          await_response = false;
      }  
      if (getState() == MENU_ON)
        Menu();
      else if (getState() == HOME_ON)
        Home();
    }
  }
}
// _________________________________________________________


/* // INT TO HEXADECIMAL (DUAL) BYTE(S)

int16_t value = 253; // Example >255 value
char bytes[3];

bytes[0] = (char)(value >> 8);    // High byte
bytes[1] = (char)(value & 0xFF);  // Low byte  
bytes[2] = '\0';

// To reconstruct:
int16_t reconstructed = (bytes[0] << 8) | bytes[1];
Serial.print("reconstructed: "); Serial.println(reconstructed);
Serial.println((char)reconstructed);

int val1 = (unsigned char)str3[0]; 
Serial.println(val1);
 */
