  
#include <Adafruit_TinyUSB.h>
#include "ramdisk.h"
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include <TinyUSB_Mouse_and_Keyboard.h>
#include <TimeLib.h>

#include "tree.h"
#include "graphics.h"
#include "include.h"

// ---------------------------------------- 

void testdrawchar(void) {
  display.clearDisplay();

  display.setTextSize(1);      // Normal 1:1 pixel scale
  display.setTextColor(KS0108_ON); // Draw white text
  display.setCursor(0, 0);     // Start at top-left corner
  display.cp437(true);         // Use full 256 char 'Code Page 437' font

  // Not all the characters will fit on the display. This is normal.
  // Library will draw what it can and the rest will be clipped.
  for(int16_t i=0; i<256; i++) {
    GLCD_overflow();
    display.print(i); display.print(" : ");
    if(i == '\n') display.write(' ');
    else          display.write(i);
    display.println();
    
    display.display();
    delay(500);
  }
  delay(2000);
}

void setup() { 
  // mount usb drive
  usb_msc_enable(true);
  usb_msc.begin();  

  // open serial port /dev/ttyACM0
  Serial.begin(9600);

  // start HID keyboard device
  Keyboard.begin();
  Keyboard.releaseAll(); 
  
  pinMode( BGL_PIN, OUTPUT_12MA );
  digitalWrite( BGL_PIN, HIGH );

  GLCD_Init();
  //PWM_Init();
  
  // - - - - - - - - - - - - - - - - - 
  // initialize keypad pins
  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    // to prevent voltage fluctuations
    gpio_set_slew_rate( rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  setState(BOOTING);
  
  // wait for usb drive to mount
  while (!msc_ready) yield();
  
  setSyncProvider(requestSync);
  
  // wait for Pi to send Serial or write to msc
  while (!zero_booted) {
    if (Serial.available() || BOOTSEL) break;
    if ((millis()-T) > 1000) 
      GLCD_anim(),
      T = millis();
    GLCD_getBgl();
  }
  
  setState(BOOTED);
  zero_booted = true;
  
  menu_init = tree::Init(&menuTree, menu_init);
  
  clearBuf();

  /*
  display.clearDisplay();
  //display.fillRect(0,0, display.width(), display.height(), 1);
  display.drawBitmap((display.width()-BMP_MOON_WIDTH)/2, (display.height()-BMP_MOON_HEIGHT)/2, moon_full_bmp, BMP_MOON_WIDTH, BMP_MOON_HEIGHT, 1); 
  display.display();
  while (1);
  */
  Home();
  //Dump();
  //testdrawchar();
}
// ---------------------------------------------------------


void Dump() {
  uint8_t b;
  const char *group, *key, *val;
  display.clearDisplay();
  display.setFont(&Picopixel);

  for (int i=0; i<ArrLen(SysData); i++) {
    group = SysData[i].key;

    b = bit2byte(SysData[i].id, 0);
    GLCD_overflow();
    display.print(b); display.print(" ");
    display.println(group);
    
    for (int n=0; n<ArrLen(SysData[i].kv); n++) {
      key = SysData[i].kv[n].key;
      val = SysData[i].kv[n].val;
      GLCD_overflow();
      display.print("  ");
      display.print(bit2byte(SysData[i].kv[n].id, 1));
      display.print(" ");
      display.println(key);
    }
    display.display();
    delay(2000);
  }

  display.setFont(NULL);
  delay(5000);
  
  /*
  uint8_t id;
  data_kv_group *group = nullptr;
  data_kv *item = nullptr;

  display.setFont(&Picopixel); 
  display.setCursor(0,0);

  id = DATA_DT;
  group = &(SysData[id-1]);
  if (group != NULL) {
    for (int i=0; i<ArrLen(group->kv); i++) {
      item = &(group->kv[i]);
      if (item->id > 0) {
        uint8_t b = bit2byte(item->id, id);
        display.print(b); display.print(" "); display.println(item->key);
        display.display();
        delay(1000);
      }
    }
  }
  */

}
// ---------------------------------------------------------
/*
void printSysData(int16_t xPos, int16_t yPos) {
  int x;
  int offset = 22;

  if (getState() != HOME_ON) return;

  data_kv_group *group = nullptr;
  data_kv *item = nullptr;

  display.setFont(&Picopixel); 
  display.cp437(true);
  display.setCursor(xPos,yPos);

  group = &(SysData[DATA_DT-1]);
  item = &(group->kv[0]); display.print(item->key); display.setCursor(offset,yPos); display.println(item->val); display.setCursor(xPos, yPos=display.getCursorY());
  item = &(group->kv[1]); display.print(item->key); display.setCursor(offset,yPos); display.println(item->val); display.setCursor(xPos, yPos=display.getCursorY());

  group = &(SysData[DATA_SUN-1]);
  item = &(group->kv[0]); display.print("sun"); display.setCursor(offset,yPos); display.print(item->val); display.print(" - ");
  item = &(group->kv[1]); display.println(item->val); display.setCursor(xPos, yPos=display.getCursorY());

  group = &(SysData[DATA_DN-1]); 
  item = &(group->kv[0]); x = atoi(item->val);
  display.print((x>0 && x<3)?"day":"nite"); display.setCursor(offset,yPos);
  item = &(group->kv[2]); display.print(item->val); display.print("% of "); 
  item = &(group->kv[1]); display.print(item->val); display.println("h");  
  display.setCursor(xPos, yPos=display.getCursorY());

  group = &(SysData[DATA_MOON-1]);
  display.print("moon"); display.setCursor(offset,yPos); 
  //item = &(group->kv[1]); display.print(item->val); display.print("% ~ "); 
  item = &(group->kv[0]); display.print(item->val); 
  display.setCursor(display.getCursorX()-1, display.getCursorY()-1);
  display.setFont(NULL); display.write(9); display.setFont(&Picopixel);
  display.println(); display.setCursor(xPos, yPos=display.getCursorY());
  
  //display.write(9); display.println();
  //display.setFont(NULL); display.write(248); display.setFont(&Picopixel); display.println(); 
  

  display.drawBitmap(
    (display.width()-BMP_HLF_WIDTH), 
    (display.height()-BMP_HLF_HEIGHT)/2,
    (x < 1) ? cat_moon_bmp_64 : ((x < 2) ? sunrise_bmp_64 : ((x < 3) ? sunset_bmp_64 : moon_bmp_64)),
    BMP_HLF_WIDTH,
    BMP_HLF_HEIGHT,
    1
  );


  display.drawLine(offset-2, 8, offset-2, display.height()-1, KS0108_ON);
  display.display();
}
*/
/*
void printSysData(int16_t xPos, int16_t yPos) {
  if (getState() != HOME_ON) return;

  display.setFont(&Picopixel); 
  display.setCursor(xPos,yPos);
  
  const char *group, *key, *val;

  for (int i=0; i<ArrLen(homeScreen); i++) {
    display.print(homeScreen[i].name);
    //display.print(":");
    display.setCursor(21, yPos);
    display.println(homeScreen[i].content);
    yPos = display.getCursorY();
    display.setCursor(xPos, yPos);
  }
  display.drawLine(18, 8, 18, display.height()-1, KS0108_ON);
  display.display();
}
*/

// ---------------------------------------------------------

void printHomeItems(int16_t xPos, int16_t yPos) {
  display.setFont(&Picopixel); 
  display.cp437(true);

  display.fillRect(1, 10, 63, 53, 0);
  display.setCursor(xPos,yPos);

  for (int i=0; i<ArrLen(homeScreen); i++) {
    display.print(homeScreen[i].name); display.setCursor(21, yPos);
    display.print(homeScreen[i].content);
    display.print((i==3)?"%":((i==5)?"'C":""));
    display.println();
    display.setCursor(xPos, yPos = display.getCursorY());
  }

  display.drawLine(19, 8, 19, display.height()-1, KS0108_ON);
  display.display();
  screenUpdate = millis();
}

// ---------------------------------------------------------

void Home() {
  int x = atoi(homeScreen[3].content);
  int16_t sunPos;

  setState(HOME_ON);
  ui_mode = UI_READ;

  display.clearDisplay();
  display.drawBitmap((display.width()-BMP_WIDTH)/2, (display.height()-BMP_HEIGHT)/2, home_bmp, BMP_WIDTH, BMP_HEIGHT, 1);
  

  display.drawBitmap(
    (display.width()-BMP_HLF_WIDTH), 
    (display.height()-BMP_HLF_HEIGHT)/2, 
    ((x < 100) ? sunset_empty_bmp_64 : nightsky_bmp_64),
    //((x < 100) ? sunset_empty_bmp_64 : moon_bmp_64),
    //((x >= 100) ? moon_bmp_64 : ((x<50) ? sunrise_bmp_64 : sunset_bmp_64)), 
    
    BMP_HLF_WIDTH, BMP_HLF_HEIGHT, 1);

  if (x < 100) {
    sunPos = (x < 50) ? 24 : (x/2);
    display.fillCircle(display.width()-32, sunPos-5, 10, 0);
    display.drawCircle(display.width()-32, sunPos-5, 10, 1);
    display.fillRect((display.width()-BMP_FOOTER_WIDTH), (display.height()-BMP_FOOTER_HEIGHT), display.height()-1, display.width()-1, 0);
    display.drawBitmap((display.width()-BMP_FOOTER_WIDTH), (display.height()-BMP_FOOTER_HEIGHT), sunset_sea_bmp_64, BMP_FOOTER_WIDTH, BMP_FOOTER_HEIGHT, 1);    
  }
  else {
    display.fillRect((display.width()/2)+1, ((display.height()/2)-BMP_MOON_HEIGHT)+9, BMP_MOON_WIDTH, BMP_MOON_HEIGHT, 0);
    display.drawBitmap((display.width()/2)+1, ((display.height()/2)-BMP_MOON_HEIGHT)+9, moon_full_bmp, BMP_MOON_WIDTH, BMP_MOON_HEIGHT, 1); 
    /*
    display.fillRect((display.width()/2), (display.height()/2), BMP_MOON_WIDTH, BMP_MOON_HEIGHT, 0);
    display.drawBitmap((display.width()/2), (display.height()/2), moon_full_bmp, BMP_MOON_WIDTH, BMP_MOON_HEIGHT, 1); 
    */
  }


  /*
  display.display();
  display.drawBitmap((display.width()-BMP_HLF_WIDTH), (display.height()-BMP_HLF_HEIGHT)/2, clouds_bmp_64, BMP_HLF_WIDTH, BMP_HLF_HEIGHT, 1);
  display.display();
  */

  printTopBar("HOME");

  display.drawLine(display.width()/2, 8, display.width()/2, display.height()-1, KS0108_ON);
  
  if (sysData_written) 
    printHomeItems(2, 14);
  
  display.setFont(NULL); 
  display.setCursor(0,0);
  display.display();
}

// ---------------------------------------------------------

void sys_setClock(const char* raw) {
  unsigned long x = strtol(raw, 0, 10);
  setTime(x);
}
// ---------------------------------------------------------

String sys_dateTimeStr(const int (&arr)[3], const char* sep = ":") {
  String val = "";
  int index = 0;

  for (const int &n : arr) 
    val = val
    + ((n<10) ? "0" : "") 
    + String(n) 
    + ((++index < 3) ? sep : "");

  return val;
}
// ---------------------------------------------------------

void sys_tickClock() {
  String t_str = "--:--";
  display.setFont(&Picopixel);

  if (timeStatus() != timeNotSet) {
    dateStr = sys_dateTimeStr({year(), month(), day()}, "-");
    timeStr = sys_dateTimeStr({hour(), minute(), second()}, ":");

    memset(homeScreen[0].content, '\0', sizeof(homeScreen[0].content));
    strcpy(homeScreen[0].content, dateStr.c_str());

    memset(homeScreen[1].content, '\0', sizeof(homeScreen[1].content));
    strcpy(homeScreen[1].content, timeStr.c_str());

    t_str = timeStr.substring(0, timeStr.lastIndexOf(':'));
    //t_str.replace(":", " ");
  }

  display.fillRect(111,1,display.width()-2, 7, 0);
  display.setCursor(109,6);

  for (int i=0; i<t_str.length(); i++) {
    if (t_str[i] == ':')
      display.setTextColor((second()%2)?1:0);
    display.write((char)t_str[i]);
    display.setTextColor(1);  
  }

  display.drawLine(display.width()-1,0,display.width()-1,8,1);
  display.setFont(NULL); 
  display.display();
}

/*
void sys_tickClock() {
  String t_str = "--:--";
  display.setFont(&Picopixel);

  if (timeStatus() != timeNotSet) {
    dateStr = sys_dateTimeStr({year(), month(), day()}, "-");
    memset(homeScreen[0].content, '\0', sizeof(homeScreen[0].content));
    strcpy(homeScreen[0].content, dateStr.c_str());

    timeStr = sys_dateTimeStr({hour(), minute(), second()}, ":");
    memset(homeScreen[1].content, '\0', sizeof(homeScreen[1].content));
    strcpy(homeScreen[1].content, timeStr.c_str());

    t_str = timeStr.substring(0, timeStr.lastIndexOf(':'));

    if ((getState() == HOME_ON) && sysData_written) {
      display.fillRect(21,10,42,12,0);
      display.setCursor(21, 14);
      display.println(homeScreen[0].content);
      display.setCursor(21, display.getCursorY());
      display.println(homeScreen[1].content);
    } 
  }

  display.fillRect(111,1,display.width()-2, 7, 0);
  display.setCursor(109,6);
  display.print(t_str);

  display.drawLine(display.width()-1,0,display.width()-1,8,1);
  display.setFont(NULL); 
  display.display();
}
*/

/*
void sys_tickClock() {
  display.fillRect(111,1,display.width()-2, 7, 0);
  
  display.setFont(&Picopixel);
  
  if (timeStatus() != timeNotSet) {
    display.setCursor(109,6);

    
    //display.setCursor(1,5);
    //display.print(String(year()).substring(2,4));
    //display.print(months[ ((atoi((const char*)month()))+2)%12 ]);
    //display.print((day()<10)?" ":"");
    //display.print(day());
    
    display.print((hour()<10)?"0":"");
    display.print(hour());
    display.setTextColor((second()%2)?1:0); 
    display.print(":");
    display.setTextColor(1);
    display.print((minute()<10)?"0":"");
    display.print(minute()); 
    //display.print(":");
    //display.print((second()<10)?"0":"");
    //display.print(second());
    //delay(1000);

    dateStr = sys_dateTimeStr({year(), month(), day()}, "-");
    memset(homeScreen[0].content, '\0', sizeof(homeScreen[0].content));
    strcpy(homeScreen[0].content, dateStr.c_str());

    timeStr = sys_dateTimeStr({hour(), minute(), second()}, ":");
    memset(homeScreen[1].content, '\0', sizeof(homeScreen[1].content));
    strcpy(homeScreen[1].content, timeStr.c_str());
  }
  else {
    display.setCursor(109,6);
    display.print("--:--");
  }
  display.drawLine(display.width()-1,0,display.width()-1,8,1);
  display.setFont(NULL); 
  display.display();
}
*/
// ---------------------------------------------------------

void printTopBar(const char* title) {
  display.fillRect(0,0,display.width()-1, 8, 0);
  
  if (tree::node_active != NULL)
    tree::showTitle((title == NULL) ? tree::node_active->label : title);
  
  sys_tickClock();
  
  display.display();
}

// ---------------------------------------------------------

void SysData_checkData() {
  const char *group, *key, *val;

  for (int i=0; i<ArrLen(homeScreen); i++)
    memset(
      homeScreen[i].content, '\0', 
      sizeof(homeScreen[i].content)
    );

  for (int i=0; i<ArrLen(SysData); i++) {
    group = SysData[i].key;

    for (int n=0; n<ArrLen(SysData[i].kv); n++) {
      key = SysData[i].kv[n].key;
      val = SysData[i].kv[n].val;

      if (SysData[i].kv[n].id > 0) {
        if (strcmp(group, "DT")) {
          if (strcmp(key, "epoch") == 0)
            sys_setClock(val);
          else if (strcmp(key, "date") == 0)
            strcpy(homeScreen[0].content, val);
          else if (strcmp(key, "time") == 0)
            strcpy(homeScreen[1].content, val);
        }
        else if (strcmp(group, "DN")) {
          if (SysData[i].kv[n].id == DATA_DN_TYPE) {
            memset(homeScreen[2].name, '\0', sizeof(homeScreen[2].name));
            strcpy(homeScreen[2].name, key);            
          }
          /*
          if (strcmp(key, "type") == 0) {
            int x = atoi(val);
            const char* day_type = (x > 0 && x < 3) ? "day" : "nite";
            strcpy(homeScreen[2].name, day_type);
          }
          else if (strcmp(key, "pct") == 0) {
            strcpy(homeScreen[2].content, val);
            strcat(homeScreen[2].content, "%");
          }
          */
        }
      }
    }
  }  
}

// ---------------------------------------------------------

bool SysData_store(String data) {
  String gkey, values, subval, key, val;
  bool success = false;
  data_kv_group *group = nullptr;
  data_kv *item = nullptr;
  
  gkey = data.substring(0, data.indexOf('='));
  values = data.substring(data.indexOf('=')+1);

  for (int i=0; i<ArrLen(SysData); i++) {
    if (strcmp(gkey.c_str(), SysData[i].key) == 0) {
      group = &(SysData[i]);
      break;
    }
  }

  if (group != NULL) {
    int idx = 0;

    do {
      idx = values.indexOf(',');
      subval = values.substring(0, ((idx<0)?values.length():idx));
      key = subval.substring(0, subval.indexOf(':'));
      val = subval.substring(subval.indexOf(':')+1);

      for (int i=0; i<ArrLen(group->kv); i++) {
        item = &(group->kv[i]);
        if (item->id > 0) {
          if (strcmp(item->key, key.c_str()) == 0) {
            memset(item->val, 0, sizeof(item->val));
            strcpy(item->val, val.c_str());
            success = true;
          }
        }
      }
      values = values.substring(idx+1, values.length());
    } while (idx >= 0);
  }
  return success;
}
// ---------------------------------------------------------

void MSC_getHeader(char* str) {
  if ((str[0] != '#') || (strstr(str,"#HEAD") == NULL)) return;
  char *p = strchr(str, ' ');
  String s;
  int n;
  header_t *h;

  if (!p) return;
  
  n = p-str, str += n+1;
  p = strchr(str, '\n');

  if (p) {
    *p = '\0';
    storeHeader(str);
    *p = '\n';
    n = p-str, str += n+1;
    
    if ((strcmp(header_data[HEAD_TYPE].data,   "SYS") == 0) 
    &&  (strcmp(header_data[HEAD_ACTION].data, "STORE") == 0)
    &&  (strcmp(header_data[HEAD_PARAMS].data, "HOSTDATA") == 0)
    &&  (strcmp(header_data[HEAD_DATA].data,   "MSC") == 0)) {      
      char *token = strtok(str, "\n");
      if (!token) return;
      do {
        bool rc = SysData_store(String(token));
        if (!sysData_written && rc) 
          sysData_written = true;
          
        token = strtok(nullptr, "\n");
      } while (token);
      //SysData_checkData();
      //Home();
    }
  }
}

// ---------------------------------------------------------

int16_t idle_x = 1;
int16_t idle_y = 12;
int homeScreen_write_index = 0;

void loop() {
  int n;
  
  // if mode is text input
  if (ui_mode == UI_WRITE) {
    
    if (KP_checkInput()) {
      display.clearDisplay();
      KP_showIcon(false);
      
      display.setCursor(0,0);
      display.print("> ");

      for (int i=0; i<strlen(buf_input); i++) {
        int hx = (unsigned char)buf_input[i];
        if (hx==197||hx==198||hx==216 ||
            hx==229||hx==230||hx==248)
            display.write(ascii2lcd(hx));
        else
            display.write(buf_input[i]);
      }
      
      display.write(curSym);
      display.display();
    }

    if (BOOTSEL) {
      kp_last_press = millis();
      while (BOOTSEL) {
        if ((millis()-kp_last_press) > 2000) 
          break;
      }
      if ((millis()-kp_last_press) > 2000) 
        Home();
      else
        sendCommand();
    }
  }
  else if (ui_mode == UI_READ) {
    KeyMap *KP = readKeyPad();

    if (sysData_written) 
      sys_tickClock();

    if (getState() == MENU_ON) {
      if (KP != NULL)
        tree::Navigate(KP->key);
    }
    else if (getState() == HOME_ON) {
      if (sysData_written && ((millis()-screenUpdate) > 1000)) 
        printHomeItems(2, 14),
        screenUpdate = millis();

      /*
      if (!sysData_written) {
        if (idle_x > 64)
          idle_y += 4,
          idle_x = 1;

        display.setFont(&Tiny3x3a2pt7b);
        display.setTextColor(1);
        display.setCursor(idle_x,idle_y);
        display.write(random(32,128));
        display.display();
        display.setFont(NULL);
        delay(20);

        idle_x += 4; 
        if (idle_y > 59)
          display.fillRect(1, 10, 63, 53, 0),
          idle_x = 2,
          idle_y = 12,
          delay(500);
      }
      */
      if (KP != NULL)
        if (KP->key != 10)
          Menu();
    }
    else if (getState() == AWAIT_RESP) {
      if ((millis()-resp_timer) > RESP_TIMEOUT) {
        GLCD_msgBox("\n    RESPONSE\n    TIMEOUT\n", false);
        delay(2000);
        
        stdin_available = false;  
        await_response = false;
       
        Home();
      }
      else {
        GLCD_anim();
      }
    }
    
    // if stdin on usb drive received
    if (stdin_available) {
      if ((stdin_buf[0] == '#') && (strstr(stdin_buf,"#HEAD") != NULL))
        MSC_getHeader(stdin_buf);
        
      else if (await_response)
        Reader("MSC"),
        await_response = false;
      
      stdin_available = false;
      
      Home();
      /*
      if (getState() == MENU_ON)
        Menu();
      else if (getState() == HOME_ON)
        Home();
      */
    }
    
    if (Serial.available()) {
      if (Serial.find("#HEAD ")) {
        memset(header, '\0', sizeof(header)-1);
        n = Serial.readBytesUntil('\n', header, sizeof(header)-1);
        header[n] = '\0';
        
        storeHeader(header);

        header_t *h = &(header_data[HEAD_PARAMS]);
        
        if (strcmp(h->data, "DT") == 0) {
          h = &(header_data[HEAD_DATA]);
          sys_setClock((const char*)h->data);
          if (timeStatus() != timeNotSet) {
            memset(homeScreen[0].content, '\0', sizeof(homeScreen[0].content));
            memset(homeScreen[1].content, '\0', sizeof(homeScreen[1].content));
            strcpy(homeScreen[0].content, sys_dateTimeStr({year(), month(), day()}, "-").c_str());
            strcpy(homeScreen[1].content, sys_dateTimeStr({hour(), minute(), second()}, ":").c_str());
          }
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "SUN") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[2].content, '\0', sizeof(homeScreen[2].content));
          strcpy(homeScreen[2].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "DAY") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[3].content, '\0', sizeof(homeScreen[3].content));
          strcpy(homeScreen[3].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "MOON") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[4].content, '\0', sizeof(homeScreen[4].content));
          strcpy(homeScreen[4].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "TEMP") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[5].content, '\0', sizeof(homeScreen[5].content));
          strcpy(homeScreen[5].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "IP") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[6].content, '\0', sizeof(homeScreen[6].content));
          strcpy(homeScreen[6].content, (const char*)h->data);
          homeScreen_write_index++;
        }

        if (homeScreen_write_index >= 6)
          sysData_written = true;
        //printHomeItems(2, 14);
        //Home();

        /*
        if (strcmp(h->data, "MULT") == 0) {          
          const char* val;
          int pos;
          T = millis();
          
          serial_busy = true;
          
          while (serial_busy) {
            if (Serial.available() > 0) {
              buf = Serial.readStringUntil('\n'); 

              if (buf.startsWith("#EOF")) {
                serial_busy = false;
                break;
              }
              
              val = buf.substring(buf.indexOf(' ')+1, buf.length()).c_str();
              pos = 0;

              if (buf.substring(0, buf.indexOf(' ')) == "DT")
                sys_setClock(val);
              else if (buf.substring(0, buf.indexOf(' ')) == "SUN")  pos = 2;
              else if (buf.substring(0, buf.indexOf(' ')) == "DAY")  pos = 3;
              else if (buf.substring(0, buf.indexOf(' ')) == "MOON") pos = 4;
              else if (buf.substring(0, buf.indexOf(' ')) == "TEMP") pos = 5;

              if (pos > 0) {
                memset(homeScreen[pos].content, '\0', sizeof(homeScreen[pos].content));
                strcpy(homeScreen[pos].content, val);
              }

              T = millis();
            }
            else if ((millis()-T) > 2000)
              serial_busy = false;
          }
          printHomeItems(2, 14);
        }
        */

      }
    
      if (Serial.find("#STDIN\n")) {
        n = 0; 
        T = millis();
        
        memset(buf_input, 0, sizeof(buf_input));
        serial_busy = true;
        //setState(STDIN_SER);
        
        while (serial_busy) {
          if (Serial.available() > 0) { 
            char *eof, c = Serial.read();
            buf_input[n++] = c;
            eof = strstr(buf_input, "#EOF\n");
            T = millis();

            if (eof) {
              *eof = '\0';
              serial_busy = false;
            }
          }
          else if ((millis()-T) > 5000)
            serial_busy = false;
        }

        if (await_response)
          Reader("SER"),
          await_response = false;
      }  
      Home();
      /*
      if (getState() == MENU_ON)
        Menu();
      else if (getState() == HOME_ON)
        Home();
      */
    }
  }
}
// _________________________________________________________


/* // INT TO HEXADECIMAL (DUAL) BYTE(S)

int16_t value = 253; // Example >255 value
char bytes[3];

bytes[0] = (char)(value >> 8);    // High byte
bytes[1] = (char)(value & 0xFF);  // Low byte  
bytes[2] = '\0';

// To reconstruct:
int16_t reconstructed = (bytes[0] << 8) | bytes[1];
Serial.print("reconstructed: "); Serial.println(reconstructed);
Serial.println((char)reconstructed);

int val1 = (unsigned char)str3[0]; 
Serial.println(val1);
 */
