  
#include <Adafruit_TinyUSB.h>
#include "ramdisk.h"
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include <TinyUSB_Mouse_and_Keyboard.h>
#include <TimeLib.h>

#include "tree.h"
#include "graphics.h"
#include "include.h"

// ---------------------------------------- 


void setup() { 
  // mount usb drive
  usb_msc_enable(true);
  usb_msc.begin();  

  // open serial port /dev/ttyACM0
  Serial.begin(9600);

  // start HID keyboard device
  Keyboard.begin();
  Keyboard.releaseAll(); 
  
  pinMode( BGL_PIN, OUTPUT_12MA );
  digitalWrite( BGL_PIN, HIGH );

  GLCD_Init();
  setSyncProvider(requestSync);

  // - - - - - - - - - - - - - - - - - 
  // initialize keypad pins
  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    // to prevent voltage fluctuations
    gpio_set_slew_rate( rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  setState(BOOTING);
  
  // wait for usb drive to mount
  while (!msc_ready) yield();
  
  // wait for Pi to send Serial or write to msc
  while (!zero_booted) {
    if (Serial.available() || BOOTSEL) break;
    if ((millis()-T) > 1000) 
      GLCD_anim(),
      T = millis();
    //GLCD_getBgl();
  }
  
  setState(BOOTED);
  zero_booted = true;
  
  menu_init = tree::Init(&menuTree, menu_init);
  
  clearBuf();

  Home();
}

// ---------------------------------------------------------

void Home() {
  setState(HOME_ON);
  ui_mode = UI_READ;

  display.clearDisplay();
  display.setFont(NULL);
  display.setTextSize(2);
  display.setCursor(display.width()/2, display.height()/2);
  display.println("HOME");
  display.display();
  display.setTextSize(1);
  delay(2000);
}

// ---------------------------------------------------------


void clock_tick() {
  String t_str = "--:--";

  if (timeStatus() != timeNotSet) {
    dateStr = sys_dateTimeStr({year(), month(), day()}, "-");
    timeStr = sys_dateTimeStr({hour(), minute(), second()}, ":");
  }
}
// ---------------------------------------------------------

void loop() {
    // if stdin on usb drive received
    if (stdin_available) {
      Reader("MSC");
      stdin_available = false;
      Home();
    }
}

// __________________________________________________________

/*
void loop() {
  int n;
  
  // if mode is text input
  if (ui_mode == UI_WRITE) {
    
    if (KP_checkInput()) {
      display.clearDisplay();
      KP_showIcon(false);
      
      display.setCursor(0,0);
      display.print("> ");

      for (int i=0; i<strlen(buf_input); i++) {
        int hx = (unsigned char)buf_input[i];
        if (hx==197||hx==198||hx==216 ||
            hx==229||hx==230||hx==248)
            display.write(ascii2lcd(hx));
        else
            display.write(buf_input[i]);
      }
      
      display.write(curSym);
      display.display();
    }

    if (BOOTSEL) {
      kp_last_press = millis();
      while (BOOTSEL) {
        if ((millis()-kp_last_press) > 2000) 
          break;
      }
      if ((millis()-kp_last_press) > 2000) 
        Home();
      else
        sendCommand();
    }
  }
  else if (ui_mode == UI_READ) {
    KeyMap *KP = readKeyPad();

    if (sysData_written) 
      sys_tickClock();

    if (getState() == MENU_ON) {
      if (KP != NULL)
        tree::Navigate(KP->key);
    }
    else if (getState() == HOME_ON) {
      if (sysData_written && ((millis()-screenUpdate) > 1000)) 
        printHomeItems(2, 14),
        screenUpdate = millis();

      if (KP != NULL)
        if (KP->key != 10)
          Menu();
    }
    else if (getState() == AWAIT_RESP) {
      if ((millis()-resp_timer) > RESP_TIMEOUT) {
        GLCD_msgBox("\n    RESPONSE\n    TIMEOUT\n", false);
        delay(2000);
        
        stdin_available = false;  
        await_response = false;
       
        Home();
      }
      else {
        GLCD_anim();
      }
    }
    
    // if stdin on usb drive received
    if (stdin_available) {
      if ((stdin_buf[0] == '#') && (strstr(stdin_buf,"#HEAD") != NULL))
        MSC_getHeader(stdin_buf);
        
      else if (await_response)
        Reader("MSC"),
        await_response = false;
      
      stdin_available = false;
      
      Home();
    }
    
    if (Serial.available()) {
      if (Serial.find("#HEAD ")) {
        memset(header, '\0', sizeof(header)-1);
        n = Serial.readBytesUntil('\n', header, sizeof(header)-1);
        header[n] = '\0';
        
        storeHeader(header);

        header_t *h = &(header_data[HEAD_PARAMS]);
        
        if (strcmp(h->data, "DT") == 0) {
          h = &(header_data[HEAD_DATA]);
          sys_setClock((const char*)h->data);
          if (timeStatus() != timeNotSet) {
            memset(homeScreen[0].content, '\0', sizeof(homeScreen[0].content));
            memset(homeScreen[1].content, '\0', sizeof(homeScreen[1].content));
            strcpy(homeScreen[0].content, sys_dateTimeStr({year(), month(), day()}, "-").c_str());
            strcpy(homeScreen[1].content, sys_dateTimeStr({hour(), minute(), second()}, ":").c_str());
          }
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "SUN") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[2].content, '\0', sizeof(homeScreen[2].content));
          strcpy(homeScreen[2].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "DAY") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[3].content, '\0', sizeof(homeScreen[3].content));
          strcpy(homeScreen[3].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "MOON") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[4].content, '\0', sizeof(homeScreen[4].content));
          strcpy(homeScreen[4].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "TEMP") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[5].content, '\0', sizeof(homeScreen[5].content));
          strcpy(homeScreen[5].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "IP") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[6].content, '\0', sizeof(homeScreen[6].content));
          strcpy(homeScreen[6].content, (const char*)h->data);
          homeScreen_write_index++;
        }

        if (homeScreen_write_index >= 6)
          sysData_written = true;
      }
    
      if (Serial.find("#STDIN\n")) {
        n = 0; 
        T = millis();
        
        memset(buf_input, 0, sizeof(buf_input));
        serial_busy = true;
        //setState(STDIN_SER);
        
        while (serial_busy) {
          if (Serial.available() > 0) { 
            char *eof, c = Serial.read();
            buf_input[n++] = c;
            eof = strstr(buf_input, "#EOF\n");
            T = millis();

            if (eof) {
              *eof = '\0';
              serial_busy = false;
            }
          }
          else if ((millis()-T) > 5000)
            serial_busy = false;
        }

        if (await_response)
          Reader("SER"),
          await_response = false;
      }  
      Home();
    }
  }
}
*/
// _________________________________________________________


/* // INT TO HEXADECIMAL (DUAL) BYTE(S)

int16_t value = 253; // Example >255 value
char bytes[3];

bytes[0] = (char)(value >> 8);    // High byte
bytes[1] = (char)(value & 0xFF);  // Low byte  
bytes[2] = '\0';

// To reconstruct:
int16_t reconstructed = (bytes[0] << 8) | bytes[1];
Serial.print("reconstructed: "); Serial.println(reconstructed);
Serial.println((char)reconstructed);

int val1 = (unsigned char)str3[0]; 
Serial.println(val1);
 */
