  
#include <Adafruit_TinyUSB.h>
#include "ramdisk.h"
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include <TinyUSB_Mouse_and_Keyboard.h>
#include <TimeLib.h>

#include "tree.h"
#include "graphics.h"
#include "include.h"

// ---------------------------------------- 


void setup() { 
  usb_msc_enable(true);
  usb_msc.begin();  

  Serial.begin(9600);

  Keyboard.begin();
  Keyboard.releaseAll(); 
  
  pinMode( BGL_PIN, OUTPUT_12MA );
  //digitalWrite( BGL_PIN, HIGH );

  BGL_set(ON);
  GLCD_Init();
  setSyncProvider(requestSync);

  // - - - - - - - - - - - - - - - - - 

  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    gpio_set_slew_rate( rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  setState(BOOTING);
  
  while (!msc_ready) yield();
  
  while (!zero_booted) {
    if (Serial.available() || BOOTSEL) break;
    if ((millis()-T) > 1000) 
      GLCD_anim(), T = millis();

    sysTick();
  }
  zero_booted = true;
  setState(BOOTED);

  menu_init = tree::Init(&menuTree, menu_init);
  
  clearBuf();
  Home();
}

// ---------------------------------------------------------

void sysTick() {
  if ((millis()-bgl_timer)>bgl_timeout) BGL_set(OFF);
}

// ---------------------------------------------------------

/*
String checkString(String s, char sep = ' ') {
  if (s.indexOf(s) != -1) 
    s = s.substring(0, s.indexOf(sep));

  String lookup[4] = {
    "#HEAD",
    "#EOF"
  };

  for (const String &sub : lookup)
    if (s == sub)
      return sub;

  return "" ;
}
*/
// ---------------------------------------------------------

int8_t processHeader(String header, uint8_t ln) {
  //if (header.substring(0, header.indexOf(' ')) == "#HEAD")
  if (header == "#STDIN") {
    return 1;
  }
  else if (header.startsWith("#HEAD")) {
    if (header.substring(header.indexOf(' ')+1, header.length()) == "DATA")
      return 3;
    else
      return 2;
  }
  else if (header == "#EOF") 
    return -1;

  return 0;
}
// ---------------------------------------------------------

bool checkDataStr(String data) {
  GLCD_print(String("data: "+data), LCD_PRINTLN, false);
  return true;
}
// ---------------------------------------------------------

void writeData(String data) {

}
// ---------------------------------------------------------

/*
void readSerialData() {
  unsigned long serial_timer;  
  bool writing_data, serial_busy = true;
  uint8_t mode, ln_count = 0;
  int n = 0;
  char c;
  
  memset(serial_buf, '\0', SERIAL_BUF_SIZE);
  buf = "";
  serial_timer = millis(); 
  writing_data = false;
  
  while (serial_busy) {
    if (Serial.available() > 0) {
      c = Serial.read();
      serial_buf[n++] = c;

      if (c == '\n') {
        if (buf[0] == '#') {
          mode = checkHeader(buf, ln_count);
          if (mode == 3)
            display.clearDisplay(),
            writing_data = true,
            mode = 2;
        }
        if (writing_data)
          checkDataStr(buf);

        ln_count++;
        buf = "";
      }
      else 
        buf += c;

      serial_timer = millis(); 
    }
    if (mode < 0)
      serial_busy = false;
    
    else if (mode == 1 || mode == 2)
      memset(serial_buf, '\0', SERIAL_BUF_SIZE);

    if ((millis()-serial_timer) > 2000)
      serial_busy = false;

  }
  while (Serial.available() > 0) c = Serial.read();
  serial_busy = false;
}
*/
// ---------------------------------------------------------

char* stdin_head(uint8_t mode, int N = 16) {
  char h[N] = {'\0'}; 
  
  for (int i = 0; i < N; i++) {
    char c = ((mode > 0) ? (char)stdin_buf[i] : Serial.read());
    if (c == 10 || c == 13) break;
    h[i] = c;
  }
  return NULL;
}

// ---------------------------------------------------------

char* msc_head(int N = 16) {
  char h[N] = {'\0'}; int i;
  for (i=0; i<N; i++) {
    if (stdin_buf[i] == 10 || stdin_buf[i] == 13) break;
    h[i] = (char)stdin_buf[i];
  }
  return NULL;
}

// ---------------------------------------------------------

char* ser_head(int N = 16) {
  char c, h[N] = {'\0'}; int i;
  for (i=0; i<N; i++) {
    c = Serial.read();
    if (c == 10 || c== 13) break;
    h[i] = c;
  }
  return NULL;
}

// ---------------------------------------------------------

uint8_t checkIncoming() {
  return (uint8_t)((stdin_available) ? 2 : ((Serial.available() && Serial.find("#STDIN\n")) ? 1 : 0));
}
// ---------------------------------------------------------

uint8_t checkHeader() {
  return (uint8_t)( (stdin_available && strstr(stdin_buf,"#HEAD ")) ? 2 : ((Serial.available() && Serial.find("#HEAD ")) ? 1 : 0));
}
// ---------------------------------------------------------

String getHeader(uint8_t t) {
  String head = "";

  for (int i=0; i<16; i++) {
    char c = (t == 2) ? stdin_buf[i+6] : ((Serial.available()) ? Serial.read() : '\n');
    if (c == '\n') break;
    head += c;
  }
  return head;
}
// ---------------------------------------------------------

void loop() {
  input_available = 0;

  if (input_available = checkIncoming()) {
    uint8_t avail_type = checkHeader();
    
    if (avail_type > 0) {
      String header = getHeader(avail_type);

      GLCD_print("type: ", LCD_PRINT, true);
      GLCD_print(avail_type, LCD_PRINTLN, false);
      GLCD_print("data: ", LCD_PRINT, false);
      GLCD_print(header, LCD_PRINTLN, false);
      delay(3000);

      /*
      char* idx = strchr(stdin_buf, ' '); idx = (!idx) ? &stdin_buf[6] : idx;

      for (int i=0; i<16; i++) {
        char c = (avail_type == 2) ? stdin_buf[i+6] : ((Serial.available()) ? Serial.read() : '\n');
        if (c == '\n') break;
        display.write(c);
        display.display();
      }


      /*
      if (avail_type == 2) {
        char *str = strchr(stdin_buf, ' ');
        if (str) { str++;
          for (int i=0; i<16; i++) {
            if (*str == '\n') break;
            display.write(*str++);
            display.display();
          }   
        }
      }

      else if (avail_type == 1) {
        for (int i=0; i<16; i++) {
          char c = Serial.read();
          if (c == '\n') break;
          display.write(c);
          display.display();
        }
        //String dataStr = Serial.readStringUntil('\n');    
      }
      */
      
      //GLCD_print((const char*)stdin_head(avail_type-1), LCD_PRINTLN, false);
      /*
      const char* head_txt = stdin_head(avail_type);
      GLCD_print("data: ", LCD_PRINT, false);
      if (head_txt)
        GLCD_print(head_txt, LCD_PRINTLN, false),
        delay(3000);
      */
      /*
      if (head == 2) {
        head_txt = stdin_head(16);
        if (msc_head != NULL) {
          GLCD_print("HEAD: ", LCD_PRINT, true);
          GLCD_print(msc_head, LCD_PRINTLN, false);
          delay(3000);      
        }      
      }
      */
    }
    stdin_available = false;
    input_available = 0;
  }
  //else if (checkHeader())

  /*
  if (stdin_available && strstr(stdin_buf,"#HEAD")) 
    GLCD_print("MSC HEADER FOUND!", LCD_PRINTLN, true), delay(3000),
    stdin_available = false;

  else if (Serial.available() && Serial.find("#HEAD"))
    GLCD_print("SER HEADER FOUND!", LCD_PRINTLN, true), delay(3000);

  if (stdin_available) {
    Reader("MSC");
    stdin_available = false;
  }
  */

    /*
    const char* msc_head = stdin_head(16);
    if (msc_head != NULL) {
      GLCD_print("HEAD: ", LCD_PRINT, true);
      GLCD_print(msc_head, LCD_PRINTLN, false);
      delay(3000);      
    }
    */
    /*
    char *sep = strchr(stdin_buf, ' ');
    if (sep) {
      *sep = '\0';
      GLCD_print(stdin_buf, LCD_PRINTLN, true);
      delay(3000);
      *sep = '\0';
    }
    Reader("MSC");
    stdin_available = false;
    Home();
    */
    /*
    char *sep = strchr(stdin_buf, ' ');
    if (sep) {
      int p = (int)(sep-stdin_buf);
      memset(h, '\0', 16);
      strncpy(h, stdin_buf, p);
      GLCD_print("head: ", LCD_PRINT, true);
      GLCD_print(h, LCD_PRINTLN, false);
      delay(5000);
    }
    */
  //  }
  /*
  uint8_t header_available = (stdin_available && ((strstr(stdin_buf,"#HEAD") != NULL))) ? 2 : (((Serial.available() > 0) && Serial.find("#HEAD")) ? 1 : 0);

  if (header_available > 0) {
    if (header_available == 2)
      GLCD_print("header available <- 2", LCD_PRINTLN, true);
    else if (header_available == 1)
      GLCD_print("header available <- 1", LCD_PRINTLN, true);
    delay(5000);
  }
  */
  /*
  if (Serial.available()) {
    readSerialData();
    GLCD_print(serial_buf,LCD_PRINTLN,true);
    delay(5000);
  }
  */
  sysTick();
}
// ---------------------------------------------------------

void Home() {
  setState(HOME_ON);
  ui_mode = UI_READ;

  display.clearDisplay();
  display.setFont(NULL);
  display.setTextSize(2);
  display.setCursor(display.width()/4, display.height()/4);
  GLCD_print("HELLO",LCD_PRINTLN,false);
  display.setTextSize(1);
  delay(2000);
}

// ---------------------------------------------------------


void clock_tick() {
  String t_str = "--:--";

  if (timeStatus() != timeNotSet) {
    dateStr = sys_dateTimeStr({year(), month(), day()}, "-");
    timeStr = sys_dateTimeStr({hour(), minute(), second()}, ":");
  }
}
// __________________________________________________________

/*
void loop() {
  int n;
  
  // if mode is text input
  if (ui_mode == UI_WRITE) {
    
    if (KP_checkInput()) {
      display.clearDisplay();
      KP_showIcon(false);
      
      display.setCursor(0,0);
      display.print("> ");

      for (int i=0; i<strlen(buf_input); i++) {
        int hx = (unsigned char)buf_input[i];
        if (hx==197||hx==198||hx==216 ||
            hx==229||hx==230||hx==248)
            display.write(ascii2lcd(hx));
        else
            display.write(buf_input[i]);
      }
      
      display.write(curSym);
      display.display();
    }

    if (BOOTSEL) {
      kp_last_press = millis();
      while (BOOTSEL) {
        if ((millis()-kp_last_press) > 2000) 
          break;
      }
      if ((millis()-kp_last_press) > 2000) 
        Home();
      else
        sendCommand();
    }
  }
  else if (ui_mode == UI_READ) {
    KeyMap *KP = readKeyPad();

    if (sysData_written) 
      sys_tickClock();

    if (getState() == MENU_ON) {
      if (KP != NULL)
        tree::Navigate(KP->key);
    }
    else if (getState() == HOME_ON) {
      if (sysData_written && ((millis()-screenUpdate) > 1000)) 
        printHomeItems(2, 14),
        screenUpdate = millis();

      if (KP != NULL)
        if (KP->key != 10)
          Menu();
    }
    else if (getState() == AWAIT_RESP) {
      if ((millis()-resp_timer) > RESP_TIMEOUT) {
        GLCD_msgBox("\n    RESPONSE\n    TIMEOUT\n", false);
        delay(2000);
        
        stdin_available = false;  
        await_response = false;
       
        Home();
      }
      else {
        GLCD_anim();
      }
    }
    
    // if stdin on usb drive received
    if (stdin_available) {
      if ((stdin_buf[0] == '#') && (strstr(stdin_buf,"#HEAD") != NULL))
        MSC_getHeader(stdin_buf);
        
      else if (await_response)
        Reader("MSC"),
        await_response = false;
      
      stdin_available = false;
      
      Home();
    }
    
    if (Serial.available()) {
      if (Serial.find("#HEAD ")) {
        memset(header, '\0', sizeof(header)-1);
        n = Serial.readBytesUntil('\n', header, sizeof(header)-1);
        header[n] = '\0';
        
        storeHeader(header);

        header_t *h = &(header_data[HEAD_PARAMS]);
        
        if (strcmp(h->data, "DT") == 0) {
          h = &(header_data[HEAD_DATA]);
          sys_setClock((const char*)h->data);
          if (timeStatus() != timeNotSet) {
            memset(homeScreen[0].content, '\0', sizeof(homeScreen[0].content));
            memset(homeScreen[1].content, '\0', sizeof(homeScreen[1].content));
            strcpy(homeScreen[0].content, sys_dateTimeStr({year(), month(), day()}, "-").c_str());
            strcpy(homeScreen[1].content, sys_dateTimeStr({hour(), minute(), second()}, ":").c_str());
          }
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "SUN") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[2].content, '\0', sizeof(homeScreen[2].content));
          strcpy(homeScreen[2].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "DAY") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[3].content, '\0', sizeof(homeScreen[3].content));
          strcpy(homeScreen[3].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "MOON") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[4].content, '\0', sizeof(homeScreen[4].content));
          strcpy(homeScreen[4].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "TEMP") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[5].content, '\0', sizeof(homeScreen[5].content));
          strcpy(homeScreen[5].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "IP") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[6].content, '\0', sizeof(homeScreen[6].content));
          strcpy(homeScreen[6].content, (const char*)h->data);
          homeScreen_write_index++;
        }

        if (homeScreen_write_index >= 6)
          sysData_written = true;
      }
    
      if (Serial.find("#STDIN\n")) {
        n = 0; 
        T = millis();
        
        memset(buf_input, 0, sizeof(buf_input));
        serial_busy = true;
        //setState(STDIN_SER);
        
        while (serial_busy) {
          if (Serial.available() > 0) { 
            char *eof, c = Serial.read();
            buf_input[n++] = c;
            eof = strstr(buf_input, "#EOF\n");
            T = millis();

            if (eof) {
              *eof = '\0';
              serial_busy = false;
            }
          }
          else if ((millis()-T) > 5000)
            serial_busy = false;
        }

        if (await_response)
          Reader("SER"),
          await_response = false;
      }  
      Home();
    }
  }
}
*/
// _________________________________________________________


/* // INT TO HEXADECIMAL (DUAL) BYTE(S)

int16_t value = 253; // Example >255 value
char bytes[3];

bytes[0] = (char)(value >> 8);    // High byte
bytes[1] = (char)(value & 0xFF);  // Low byte  
bytes[2] = '\0';

// To reconstruct:
int16_t reconstructed = (bytes[0] << 8) | bytes[1];
Serial.print("reconstructed: "); Serial.println(reconstructed);
Serial.println((char)reconstructed);

int val1 = (unsigned char)str3[0]; 
Serial.println(val1);
 */
