  
#include <Adafruit_TinyUSB.h>
#include "ramdisk.h"
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include <TinyUSB_Mouse_and_Keyboard.h>
#include <TimeLib.h>

#include "tree.h"
#include "graphics.h"
#include "include.h"

// ---------------------------------------- 


void setup() { 
  usb_msc_enable(true);
  usb_msc.begin();  

  Serial.begin(9600);

  Keyboard.begin();
  Keyboard.releaseAll(); 
  
  pinMode( BGL_PIN, OUTPUT_12MA );
  //digitalWrite( BGL_PIN, HIGH );

  BGL_set(ON);
  GLCD_Init();
  setSyncProvider(requestSync);

  // - - - - - - - - - - - - - - - - - 

  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    gpio_set_slew_rate( rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  setState(BOOTING);
  
  while (!msc_ready) yield();
  
  while (!zero_booted) {
    if (Serial.available() || BOOTSEL) break;
    if ((millis()-T) > 1000) 
      GLCD_anim(), T = millis();

    sysTick();
  }
  zero_booted = true;
  setState(BOOTED);

  menu_init = tree::Init(&menuTree, menu_init);
  
  clearBuf();
  Home();
}

// ---------------------------------------------------------

void sysTick() {
  if ((millis()-bgl_timer)>bgl_timeout) BGL_set(OFF);
}

// ---------------------------------------------------------

/*
String checkString(String s, char sep = ' ') {
  if (s.indexOf(s) != -1) 
    s = s.substring(0, s.indexOf(sep));

  String lookup[4] = {
    "#HEAD",
    "#EOF"
  };

  for (const String &sub : lookup)
    if (s == sub)
      return sub;

  return "" ;
}
*/
// ---------------------------------------------------------

uint8_t hasIncoming() {
  return (uint8_t)((stdin_available) ? 2 : ((Serial.available() && Serial.find("#STDIN")) ? 1 : 0));
}
// ---------------------------------------------------------

uint8_t hasHeader() {
  return (uint8_t)( (stdin_available && strstr(stdin_buf,"#HEAD ")) ? 2 : ((Serial.available() && Serial.find("#HEAD ")) ? 1 : 0));
}
// ---------------------------------------------------------

String getHeader(uint8_t t, char **ptr) {
  String head = "";
  int i;
  for (i=0; i<16; i++) {
    char c = (t == 2) ? stdin_buf[i+6] : ((Serial.available()) ? Serial.read() : '\n');
    if (c == '\n') break;
    head += c;
    ptr++;
  }
  
  return head;
}
// ---------------------------------------------------------

uint8_t checkHeader(String h) {
  uint8_t x = 0b0000;
  String key = (h.indexOf(' ') > -1) ? h.substring(0, h.indexOf(' ')) : h;
  String val = (h.indexOf(' ') > -1) ? h.substring(h.indexOf(' ')+1, h.length()) : h;  
  
  if (key == "SYS") {  x |= (1 << 4); // 10 -> 10
    if (val == "DATA") x |= (1 << 0); // 1  -> 11
  }
  return x;
}
// ---------------------------------------------------------

unsigned char msc_readByte(int offs = 0) {
  static int pos;
  pos = (offs > 0) ? offs : pos;
  return stdin_buf[(++pos %= strlen(stdin_buf)+1)];
}
// ---------------------------------------------------------

String msc_readLine(char* ptr, int offs = 0) {
  static int pos;
  char c = ' ';
  String line = "";

  pos = (offs > 0) ? offs : pos;

  while (ptr && (c != '\n'))
    line += ptr[pos++];

  return line;
  /*
  for (int i=0; i<16; i++) {
    char c = (t == 2) ? stdin_buf[i+6] : ((Serial.available()) ? Serial.read() : '\n');
    if (c == '\n') break;
    head += c;
  }
  return head;
  */
}

void loop() {
  char *msc_buf = nullptr;
  uint8_t n, stdin_mode = 0;
  uint8_t input_available = 0;
  uint8_t header_type = 0;
  String header = "";
  // - - - - - - - - - - - - - - - - - -

  // stdin_available || Serial == #STDIN"
  if (input_available = hasIncoming()) {
    header_type = hasHeader();
    
    if (header_type > 0) {
      msc_buf = (header_type == 2) ? &stdin_buf[6] : &stdin_buf[0];
      header = getHeader(header_type, &msc_buf);
      if (header.length())
        stdin_mode = checkHeader(header);
        GLCD_print("MODE: ",0, 1);
        GLCD_print(stdin_mode, 1, 0);
        delay(3000);
    }
    
    if (Serial.available() > 0) {
      memset(serial_buf, '\0', SERIAL_BUF_SIZE);
      while (Serial.available() > 0)
        serial_buf[n++] = (char)Serial.read();
      if (strlen(serial_buf))
        Reader(serial_buf); 
    }
    else if (stdin_available && strlen(msc_buf))
      Reader(msc_buf);

    /*
    if (input_available == 1) {
      if (stdin_mode == 0) {
        memset(serial_buf, '\0', SERIAL_BUF_SIZE);
        while (Serial.available() > 0)
          serial_buf[n++] = (char)Serial.read();
        Reader(serial_buf);  
      }
      else if (stdin_mode >= 16) {
        String line = Serial.readStringUntil('\n');
        display.clearDisplay();
        display.print("SER: ");
        display.println(line);
        display.display();
        delay(5000);
      }
    }
    else if (input_available == 2) {
      if (stdin_mode == 0) 
        Reader(msc_buf);

      else if (stdin_mode >= 16) {
        String line = msc_readLine(msc_buf);
        display.clearDisplay();
        display.print("MSC: ");
        display.println(line);
        display.display();
        delay(5000);
      }
    }
    */
    /*
    // no header
    if (stdin_mode == 0) {
      if (input_available == 1) { // Serial
        memset(serial_buf, '\0', SERIAL_BUF_SIZE);
        while (Serial.available() > 0)
          serial_buf[n++] = (char)Serial.read();
        Reader(serial_buf);
      }
      else if (input_available == 2) // msc
        Reader(msc_buf);
    }
    else if (stdin_mode >= 16) { // DATA WRITING

    }
    */
    stdin_available = false;
    Home();
  }
  
  sysTick();
}
// ---------------------------------------------------------

void Home() {
  setState(HOME_ON);
  ui_mode = UI_READ;

  display.clearDisplay();
  display.setFont(NULL);
  display.setTextSize(2);
  display.setCursor(display.width()/4, display.height()/4);
  GLCD_print("HELLO",LCD_PRINTLN,false);
  display.setTextSize(1);
  delay(2000);
}

// ---------------------------------------------------------


void clock_tick() {
  String t_str = "--:--";

  if (timeStatus() != timeNotSet) {
    dateStr = sys_dateTimeStr({year(), month(), day()}, "-");
    timeStr = sys_dateTimeStr({hour(), minute(), second()}, ":");
  }
}
// __________________________________________________________

/*
void loop() {
  int n;
  
  // if mode is text input
  if (ui_mode == UI_WRITE) {
    
    if (KP_checkInput()) {
      display.clearDisplay();
      KP_showIcon(false);
      
      display.setCursor(0,0);
      display.print("> ");

      for (int i=0; i<strlen(buf_input); i++) {
        int hx = (unsigned char)buf_input[i];
        if (hx==197||hx==198||hx==216 ||
            hx==229||hx==230||hx==248)
            display.write(ascii2lcd(hx));
        else
            display.write(buf_input[i]);
      }
      
      display.write(curSym);
      display.display();
    }

    if (BOOTSEL) {
      kp_last_press = millis();
      while (BOOTSEL) {
        if ((millis()-kp_last_press) > 2000) 
          break;
      }
      if ((millis()-kp_last_press) > 2000) 
        Home();
      else
        sendCommand();
    }
  }
  else if (ui_mode == UI_READ) {
    KeyMap *KP = readKeyPad();

    if (sysData_written) 
      sys_tickClock();

    if (getState() == MENU_ON) {
      if (KP != NULL)
        tree::Navigate(KP->key);
    }
    else if (getState() == HOME_ON) {
      if (sysData_written && ((millis()-screenUpdate) > 1000)) 
        printHomeItems(2, 14),
        screenUpdate = millis();

      if (KP != NULL)
        if (KP->key != 10)
          Menu();
    }
    else if (getState() == AWAIT_RESP) {
      if ((millis()-resp_timer) > RESP_TIMEOUT) {
        GLCD_msgBox("\n    RESPONSE\n    TIMEOUT\n", false);
        delay(2000);
        
        stdin_available = false;  
        await_response = false;
       
        Home();
      }
      else {
        GLCD_anim();
      }
    }
    
    // if stdin on usb drive received
    if (stdin_available) {
      if ((stdin_buf[0] == '#') && (strstr(stdin_buf,"#HEAD") != NULL))
        MSC_getHeader(stdin_buf);
        
      else if (await_response)
        Reader("MSC"),
        await_response = false;
      
      stdin_available = false;
      
      Home();
    }
    
    if (Serial.available()) {
      if (Serial.find("#HEAD ")) {
        memset(header, '\0', sizeof(header)-1);
        n = Serial.readBytesUntil('\n', header, sizeof(header)-1);
        header[n] = '\0';
        
        storeHeader(header);

        header_t *h = &(header_data[HEAD_PARAMS]);
        
        if (strcmp(h->data, "DT") == 0) {
          h = &(header_data[HEAD_DATA]);
          sys_setClock((const char*)h->data);
          if (timeStatus() != timeNotSet) {
            memset(homeScreen[0].content, '\0', sizeof(homeScreen[0].content));
            memset(homeScreen[1].content, '\0', sizeof(homeScreen[1].content));
            strcpy(homeScreen[0].content, sys_dateTimeStr({year(), month(), day()}, "-").c_str());
            strcpy(homeScreen[1].content, sys_dateTimeStr({hour(), minute(), second()}, ":").c_str());
          }
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "SUN") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[2].content, '\0', sizeof(homeScreen[2].content));
          strcpy(homeScreen[2].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "DAY") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[3].content, '\0', sizeof(homeScreen[3].content));
          strcpy(homeScreen[3].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "MOON") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[4].content, '\0', sizeof(homeScreen[4].content));
          strcpy(homeScreen[4].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "TEMP") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[5].content, '\0', sizeof(homeScreen[5].content));
          strcpy(homeScreen[5].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "IP") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[6].content, '\0', sizeof(homeScreen[6].content));
          strcpy(homeScreen[6].content, (const char*)h->data);
          homeScreen_write_index++;
        }

        if (homeScreen_write_index >= 6)
          sysData_written = true;
      }
    
      if (Serial.find("#STDIN\n")) {
        n = 0; 
        T = millis();
        
        memset(buf_input, 0, sizeof(buf_input));
        serial_busy = true;
        //setState(STDIN_SER);
        
        while (serial_busy) {
          if (Serial.available() > 0) { 
            char *eof, c = Serial.read();
            buf_input[n++] = c;
            eof = strstr(buf_input, "#EOF\n");
            T = millis();

            if (eof) {
              *eof = '\0';
              serial_busy = false;
            }
          }
          else if ((millis()-T) > 5000)
            serial_busy = false;
        }

        if (await_response)
          Reader("SER"),
          await_response = false;
      }  
      Home();
    }
  }
}
*/
// _________________________________________________________


/* // INT TO HEXADECIMAL (DUAL) BYTE(S)

int16_t value = 253; // Example >255 value
char bytes[3];

bytes[0] = (char)(value >> 8);    // High byte
bytes[1] = (char)(value & 0xFF);  // Low byte  
bytes[2] = '\0';

// To reconstruct:
int16_t reconstructed = (bytes[0] << 8) | bytes[1];
Serial.print("reconstructed: "); Serial.println(reconstructed);
Serial.println((char)reconstructed);

int val1 = (unsigned char)str3[0]; 
Serial.println(val1);
 */
