  
#include <Adafruit_TinyUSB.h>
#include "ramdisk.h"
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include <TinyUSB_Mouse_and_Keyboard.h>
#include <TimeLib.h>

#include "tree.h"
#include "graphics.h"
#include "include.h"

// ---------------------------------------- 

void setup() { 
  usb_msc_enable(true);
  usb_msc.begin();  

  Serial.begin(9600);

  Keyboard.begin();
  Keyboard.releaseAll(); 
  
  pinMode( BGL_PIN, OUTPUT_12MA );

  BGL_set(ON);
  GLCD_Init();

  // - - - - - - - - - - - - - - - - - 

  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    gpio_set_slew_rate( rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  setState(BOOTING);

  while (!msc_ready) yield();
  while (!zero_booted) {
    if (Serial.available() || BOOTSEL) break;
    if ((millis()-T) > 1000) 
      GLCD_anim(), T = millis();
    sysTick();
  }
  zero_booted = true;
  setState(BOOTED);
  setSyncProvider(requestSync);

  menu_init = tree::Init(&menuTree, menu_init);

  clearBuf();
  Home(true);
}

// ---------------------------------------------------------

void clock_blink() {
  display.setFont(&Picopixel);
  display.setCursor(clock_cur_pos, 6);
  display.setTextColor((second()%2)?1:0);
  display.write(':');
  display.display();
  display.setFont(NULL);
  display.setCursor(0,0);
  display.setTextColor(KS0108_ON); 
}

// ---------------------------------------------------------

void clock_tick(bool update) {
  clock_str  = "--:--";
  timeSynced = (timeStatus() == timeSet) ? true : false;

  if (timeStatus() != timeNotSet) {
    dateStr = sys_dateTimeStr({year(), month(), day()}, "-");
    timeStr = sys_dateTimeStr({hour(), minute(), second()}, ":");
    clock_str = timeStr.substring(0, timeStr.lastIndexOf(':'));

    if (update) {
      memset(homeScreen[0].content, '\0', 16);
      strncpy(homeScreen[0].content, dateStr.c_str(), 16);

      memset(homeScreen[1].content, '\0', 16);    
      strncpy(homeScreen[1].content, timeStr.c_str(), 16);
    }
  }
  if (update)
    clock_show(clock_str);
}
// ---------------------------------------------------------

void clock_show(String &str, int16_t &cur) {
  if (getState() == MENU_ON || getState() == HOME_ON) { 
    display.fillRect(111,1,display.width()-2, 7, 0);
    display.setFont(&Picopixel); 
    display.setCursor(109,6);

    for (int i=0; i<str.length(); i++) {
      if (str[i] == ':') cur = display.getCursorX();
      display.write((char)str[i]);
    }
    display.display();
    display.setFont(NULL); 
  }
}
// ---------------------------------------------------------

void checkHeader(String &str) {
  int  i, end, x = 0, n = 0;
  
  end = str.indexOf('\n');
  str = str.substring(str.indexOf(' ')+1, ((end<0)?str.length():end));

  if (str.indexOf(' ') < 0) return;
  if (str.substring(0, str.indexOf(' ')) == "HOME") {
    str = str.substring(str.indexOf(' ')+1, str.length());
    memset(homeScreen[0].content, '\0', 16);

    for (int i=0; i<str.length(); i++) {
      char c = str[i];
      homeScreen[n].content[x++] = c;  

      if (c == ' ' || i == (str.length()-1)) { 
        if (n < 7) {
          if (n == 0)
            clock_set(homeScreen[n].content), n++;
          if (i < (str.length()-1))
            memset(homeScreen[++n].content, '\0', 16);
          x = 0;
          continue;
        }
      }
    }
    data_stored = true;
  }  
}
// ---------------------------------------------------------

void sysTick() {
  if ((bgl_timeout > 0) && ((millis()-bgl_timer)>bgl_timeout))
    BGL_set(OFF);

  if (getState() != TXT_INPUT) {
    if (!(millis()%10))
      clock_tick();

    if ((millis()-clock_update) > 1000)
      clock_blink(),
      clock_update = millis();  
  }
}

// ---------------------------------------------------------

void printHomeItems(int16_t xPos, int16_t yPos) {
  display.setFont(&Picopixel); 
  display.cp437(true);

  display.fillRect(1, 10, 63, 53, 0);
  display.setCursor(xPos,yPos);

  for (int i=0; i<ArrLen(homeScreen); i++) {
    display.print(homeScreen[i].name);
    display.setCursor(21, yPos);
    display.print(homeScreen[i].content);
    display.print((i==3)?"%":((i==5)?"'C":""));
    
    if (i == 4) 
      display.drawPixel(xPos+33, 39, 1),
      display.drawPixel(xPos+31, 39, 1),
      display.drawPixel(xPos+32, 38, 1),
      display.drawPixel(xPos+32, 40, 1);

    display.println(); display.setCursor(xPos, yPos = display.getCursorY());
  }

  display.drawLine(19, 8, 19, display.height()-1, KS0108_ON);
  display.display();
  display.setCursor(0,0);
  display.setFont(NULL); 
}
// ---------------------------------------------------------

void homeArtwork(bool loaded = false) {
  int x = atoi(homeScreen[3].content);
  int16_t sunPos; 

  // clear art frame
  display.fillRect(64, 9, (display.width()/2)-1, 53, 0);

  if (loaded) {
    display.drawBitmap(
      (display.width()-BMP_HLF_WIDTH), 
      (display.height()-BMP_HLF_HEIGHT)/2,
      ((x < 100) ? sunset_empty_bmp_64 : nightsky_bmp_64),
      BMP_HLF_WIDTH, BMP_HLF_HEIGHT, 1
    );    
    if (x < 100) {
      sunPos = (x < 50) ? 24 : (x/2);
      display.fillCircle(display.width()-32, sunPos-5, 10, 0);
      display.drawCircle(display.width()-32, sunPos-5, 10, 1);
      display.fillRect((display.width()-BMP_FOOTER_WIDTH), (display.height()-BMP_FOOTER_HEIGHT), display.height()-1, display.width()-1, 0);
      display.drawBitmap((display.width()-BMP_FOOTER_WIDTH), (display.height()-BMP_FOOTER_HEIGHT), sunset_sea_bmp_64, BMP_FOOTER_WIDTH, BMP_FOOTER_HEIGHT, 1);    
    }
    else {
      display.fillRect((display.width()/2)+1, ((display.height()/2)-BMP_MOON_HEIGHT)+9, BMP_MOON_WIDTH, BMP_MOON_HEIGHT, 0);
      display.drawBitmap((display.width()/2)+1, ((display.height()/2)-BMP_MOON_HEIGHT)+9, moon_full_bmp, BMP_MOON_WIDTH, BMP_MOON_HEIGHT, 1);
      //display.fillRect((display.width()/2), (display.height()/2), BMP_MOON_WIDTH, BMP_MOON_HEIGHT, 0);
      //display.drawBitmap((display.width()/2), (display.height()/2), moon_full_bmp, BMP_MOON_WIDTH, BMP_MOON_HEIGHT, 1); 
    }
  }
  else {
    display.drawBitmap(
      (display.width()-BMP_HLF_WIDTH), 
      (display.height()-BMP_HLF_HEIGHT)/2,
      default_64,
      BMP_HLF_WIDTH, BMP_HLF_HEIGHT, 1
    );
  }

  display.drawLine(
    display.width()/2, 8, 
    display.width()/2, display.height()-1,
    KS0108_ON
  );

  display.display();
}
// ---------------------------------------------------------

void Home(bool init) {
  setState(HOME_ON);

  if (init)
    display.clearDisplay();

  display.drawBitmap(
    (display.width()-BMP_WIDTH)/2, 
    (display.height()-BMP_HEIGHT)/2, 
    home_bmp, 
    BMP_WIDTH, BMP_HEIGHT, 1
  );

  homeArtwork(data_stored);
  printTopBar("HOME");

  if (init)
    clock_tick();

  if (data_stored)
    printHomeItems(2,15);

  display.display();
  display.setCursor(0,0);
  display.setFont(NULL);
}

// ---------------------------------------------------------

void checkStreams() {
  int i,n = 0;

  if (Serial.available() > 0) {
    memset(buf_input, '\0', sizeof(buf_input));

    while (Serial.available() > 0) {
      buf = Serial.readStringUntil('\n');
      if (buf.startsWith("#HEAD ")) {
        checkHeader(buf);
        if (data_stored) {
          Serial_flush();
          Home(false);
          return;
        }
      }
      else {
        for (i=0; i<buf.length(); i++)
          buf_input[n++] = (char)buf[i];
        buf_input[n++] = '\n';
      }
    }
    Serial_flush();
    
    if (strlen(buf_input) > 0) {
      if (await_response) {
        Reader(buf_input);
        await_response = false;
        Menu();
      }
    }
  }
  else if (stdin_available) {
    if (await_response) {
      Reader(stdin_buf);
      await_response = false;
      Menu();
    }
    stdin_available = false;
  } 
}

// ---------------------------------------------------------

void loop() {
  sysTick();

  checkStreams();

  if (getState() == AWAIT_RESP) {
    if ((millis()-resp_timer) > RESP_TIMEOUT) {
      GLCD_msgBox("\n    RESPONSE\n    TIMEOUT\n", false); delay(2000);
      stdin_available = false;  
      await_response = false;
      Menu();
    }
    else 
      GLCD_anim();
  }
  else if (getState() == TXT_INPUT) {
    if (KP_checkInput()) {
      display.clearDisplay();
      KP_showIcon(false);
      
      display.setCursor(0,0);
      display.print("> ");

      GLCD_decodeStr(buf_input);

      display.write(curSym);
      display.display();
      BGL_set(ON);
    }
    if (BOOTSEL) {
      kp_last_press = millis();
      while (BOOTSEL) {
        if ((millis()-kp_last_press) > 2000) 
          break;
      }
      if ((millis()-kp_last_press) < 2000)
        sendCommand(),
        Menu();
    }
  }
  else {
    KeyMap *KP = readKeyPad();

    if (KP != NULL) { BGL_set(ON);
      if (getState() == MENU_ON) 
        tree::Navigate(KP->key);

      else if (getState() == HOME_ON)
        Menu();
    }
    //else { checkStreams(); }
  }
}


//###################################################################


/*
void sysTick() {
  if ((bgl_timeout > 0) && ((millis()-bgl_timer)>bgl_timeout))
    BGL_set(OFF);


  if (data_updated && ((millis()-data_timestamp) > 60000UL))
    Serial.println("REQ DATA"),
    data_updated = false;

  clock_tick();
}
// ---------------------------------------------------------

void clock_tick() {
  String t_str = "--:--";
  
  timeSynced = (timeStatus() == timeSet) ? true : false;

  if (timeStatus() != timeNotSet) {
    dateStr = sys_dateTimeStr({year(), month(), day()}, "-");
    timeStr = sys_dateTimeStr({hour(), minute(), second()}, ":");
    t_str = timeStr.substring(0, timeStr.lastIndexOf(':'));

    memset(homeScreen[0].content, '\0', 12);
    strncpy(homeScreen[0].content, dateStr.c_str(), 12);
    memset(homeScreen[1].content, '\0', 12);
    strncpy(homeScreen[1].content, timeStr.c_str(), 12);

    if ((millis()-clockUpdate) > 1000) {
      if (getState() == HOME_ON) { 
        display.setFont(&Picopixel);
        display.fillRect(108,0,display.width(),9,1);
        display.setCursor(110,7);
        display.setTextColor(KS0108_INVERSE);
        display.println(timeStr.substring(0, timeStr.lastIndexOf(':')));
        display.display();
        display.setFont(NULL);
        display.setTextColor(0);
        clockUpdate = millis();
      }
    }
  }
}
// ---------------------------------------------------------


uint8_t hasIncoming() {
  return (uint8_t)((stdin_available) ? 2 : ((Serial.available() && Serial.find("#STDIN\n")) ? 1 : 0));
}
// ---------------------------------------------------------

void data_isStored() {
  data_stored = true;
  data_updated = true;
  data_timestamp = millis();
}
// ---------------------------------------------------------

void storeHeader(char** ptr, char* h) {
  bool wr = false;

  memset(h, '\0', HEADER_SIZE); 

  while (*ptr && **ptr != '\n') {
    if (!wr && **ptr == ' ') 
      wr = true;
    else if (wr) 
      *h++ = **ptr;
    
    (*ptr)++;
  }
  if (**ptr == '\n') (*ptr)++;
}
// ---------------------------------------------------------

void checkHeader(char* h, char delim = '=') {
  int sep;
  String key, val, arg = "";

  for (int i = 0; i<strlen(h); i++) arg += (char)h[i];
  sep = arg.indexOf(' ');
  key = arg.substring(0, sep);

  if (key == "SYS") {
    do {
      arg = arg.substring(((arg.indexOf(' ') < 0) ? 0 : arg.indexOf(' ')+1), arg.length());
      val = arg.substring(0, arg.indexOf(' ')); sep = val.indexOf('=');
      key = val.substring(0, sep);
      val = val.substring(sep+1, val.length());

      if (key == "epoch") {
        clock_set(val.c_str());
        data_isStored();
        continue;
      }

      for (int i=0; i<7; i++) {
        if ( strcmp(key.c_str(), homeScreen[i].name) == 0 ) {
          memset(homeScreen[i].content, '\0', 12);
          strncpy(homeScreen[i].content, val.c_str(), 12);
          data_isStored();
          break;
        }
      }
    } while (arg.indexOf(' ') > -1);
      
  }
}
// ---------------------------------------------------------

void checkStreams() {
  uint8_t incoming;
  uint16_t n = 0;
  char *sep, *txt_buf;
  unsigned long serial_timer;

  incoming = hasIncoming();
  
  if (incoming > 0) { 
    await_response = true; // REM
    txt_buf = (incoming == 2) ? stdin_buf : serial_buf;

    if (incoming == 1) { 
      memset(serial_buf, '\0', SERIAL_BUF_SIZE); n = 0;
      serial_timer = millis();

      while ((millis()-serial_timer)<5000) {
        sep = strstr(txt_buf, "#EOF");
        if (sep) { *sep = '\0'; break; }
        if (Serial.available() > 0) {
          txt_buf[n++] = Serial.read();
          serial_timer = millis();
        }
      }
      while (Serial.available() > 0) Serial.read();
    }

    if (strstr(txt_buf, "#HEAD ")) {
      storeHeader(&txt_buf, header);
      //checkHeader(header);
    }

    if (await_response && strlen(txt_buf) > 1)
      Reader(txt_buf);

    if (incoming == 2)
      stdin_available = false;

    await_response = false;
    Home();
  }
  else if (Serial.available())
    while (Serial.available() > 0)
      char c = Serial.read();

  sysTick();
}

void loop() {
  checkStreams();
}

// ---------------------------------------------------------

void Home() {
  setState(HOME_ON);
  ui_mode = UI_READ;
  
  display.clearDisplay();

  if (data_stored) {
    clock_tick();
    
    for (int i=0; i<7; i++) {
      GLCD_print(homeScreen[i].name, 0, 0); GLCD_print(": ",0,0);
      GLCD_print(homeScreen[i].content, 1, 0); 
    }
    //delay(3000);
  }
  else {
    GLCD_print("READY.",1,1);
  }
}
*/

/*
uint8_t hasIncoming() {
  return (uint8_t)((stdin_available) ? 2 : ((Serial.available() && Serial.find("#STDIN")) ? 1 : 0));
}
// ---------------------------------------------------------

uint8_t hasHeader() {
  return (uint8_t)( (stdin_available && strstr(stdin_buf,"#HEAD ")) ? 2 : ((Serial.available() && Serial.find("#HEAD ")) ? 1 : 0));
}
// ---------------------------------------------------------

String getHeader(uint8_t t, char **ptr) {
  String head = "";
  int i;
  for (i=0; i<16; i++) {
    char c = (t == 2) ? stdin_buf[i+6] : ((Serial.available()) ? Serial.read() : '\n');
    if (c == '\n') break;
    head += c;
    ptr++;
  }
  
  return head;
}
// ---------------------------------------------------------

uint8_t checkHeader(String h) {
  uint8_t x = 0b0000;
  String key = (h.indexOf(' ') > -1) ? h.substring(0, h.indexOf(' ')) : h;
  String val = (h.indexOf(' ') > -1) ? h.substring(h.indexOf(' ')+1, h.length()) : h;  
  
  if (key == "SYS") {  x |= (1 << 4); // 10 -> 10
    if (val == "DATA") x |= (1 << 0); // 1  -> 11
  }
  return x;
}
// ---------------------------------------------------------

unsigned char msc_readByte(int offs = 0) {
  static int pos;
  pos = (offs > 0) ? offs : pos;
  return stdin_buf[(++pos %= strlen(stdin_buf)+1)];
}
// ---------------------------------------------------------

String msc_readLine(char* ptr, int offs = 0) {
  static int pos;
  char c = ' ';
  String line = "";

  pos = (offs > 0) ? offs : pos;

  while (ptr && (c != '\n'))
    line += ptr[pos++];

  return line;
}

// ---------------------------------------------------------

*/

/*
void loop() {
  int n;
  
  // if mode is text input
  if (ui_mode == UI_WRITE) {
    
    if (KP_checkInput()) {
      display.clearDisplay();
      KP_showIcon(false);
      
      display.setCursor(0,0);
      display.print("> ");

      for (int i=0; i<strlen(buf_input); i++) {
        int hx = (unsigned char)buf_input[i];
        if (hx==197||hx==198||hx==216 ||
            hx==229||hx==230||hx==248)
            display.write(ascii2lcd(hx));
        else
            display.write(buf_input[i]);
      }
      
      display.write(curSym);
      display.display();
    }

    if (BOOTSEL) {
      kp_last_press = millis();
      while (BOOTSEL) {
        if ((millis()-kp_last_press) > 2000) 
          break;
      }
      if ((millis()-kp_last_press) > 2000) 
        Home();
      else
        sendCommand();
    }
  }
  else if (ui_mode == UI_READ) {
    KeyMap *KP = readKeyPad();

    if (sysData_written) 
      sys_tickClock();

    if (getState() == MENU_ON) {
      if (KP != NULL)
        tree::Navigate(KP->key);
    }
    else if (getState() == HOME_ON) {
      if (sysData_written && ((millis()-screenUpdate) > 1000)) 
        printHomeItems(2, 14),
        screenUpdate = millis();

      if (KP != NULL)
        if (KP->key != 10)
          Menu();
    }
    else if (getState() == AWAIT_RESP) {
      if ((millis()-resp_timer) > RESP_TIMEOUT) {
        GLCD_msgBox("\n    RESPONSE\n    TIMEOUT\n", false);
        delay(2000);
        
        stdin_available = false;  
        await_response = false;
       
        Home();
      }
      else {
        GLCD_anim();
      }
    }
    
    // if stdin on usb drive received
    if (stdin_available) {
      if ((stdin_buf[0] == '#') && (strstr(stdin_buf,"#HEAD") != NULL))
        MSC_getHeader(stdin_buf);
        
      else if (await_response)
        Reader("MSC"),
        await_response = false;
      
      stdin_available = false;
      
      Home();
    }
    
    if (Serial.available()) {
      if (Serial.find("#HEAD ")) {
        memset(header, '\0', sizeof(header)-1);
        n = Serial.readBytesUntil('\n', header, sizeof(header)-1);
        header[n] = '\0';
        
        storeHeader(header);

        header_t *h = &(header_data[HEAD_PARAMS]);
        
        if (strcmp(h->data, "DT") == 0) {
          h = &(header_data[HEAD_DATA]);
          sys_setClock((const char*)h->data);
          if (timeStatus() != timeNotSet) {
            memset(homeScreen[0].content, '\0', sizeof(homeScreen[0].content));
            memset(homeScreen[1].content, '\0', sizeof(homeScreen[1].content));
            strcpy(homeScreen[0].content, sys_dateTimeStr({year(), month(), day()}, "-").c_str());
            strcpy(homeScreen[1].content, sys_dateTimeStr({hour(), minute(), second()}, ":").c_str());
          }
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "SUN") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[2].content, '\0', sizeof(homeScreen[2].content));
          strcpy(homeScreen[2].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "DAY") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[3].content, '\0', sizeof(homeScreen[3].content));
          strcpy(homeScreen[3].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "MOON") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[4].content, '\0', sizeof(homeScreen[4].content));
          strcpy(homeScreen[4].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "TEMP") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[5].content, '\0', sizeof(homeScreen[5].content));
          strcpy(homeScreen[5].content, (const char*)h->data);
          homeScreen_write_index++;
        }
        else if (strcmp(h->data, "IP") == 0) {
          h = &(header_data[HEAD_DATA]);
          memset(homeScreen[6].content, '\0', sizeof(homeScreen[6].content));
          strcpy(homeScreen[6].content, (const char*)h->data);
          homeScreen_write_index++;
        }

        if (homeScreen_write_index >= 6)
          sysData_written = true;
      }
    
      if (Serial.find("#STDIN\n")) {
        n = 0; 
        T = millis();
        
        memset(buf_input, 0, sizeof(buf_input));
        serial_busy = true;
        //setState(STDIN_SER);
        
        while (serial_busy) {
          if (Serial.available() > 0) { 
            char *eof, c = Serial.read();
            buf_input[n++] = c;
            eof = strstr(buf_input, "#EOF\n");
            T = millis();

            if (eof) {
              *eof = '\0';
              serial_busy = false;
            }
          }
          else if ((millis()-T) > 5000)
            serial_busy = false;
        }

        if (await_response)
          Reader("SER"),
          await_response = false;
      }  
      Home();
    }
  }
}
*/
// _________________________________________________________


/* // INT TO HEXADECIMAL (DUAL) BYTE(S)

int16_t value = 253; // Example >255 value
char bytes[3];

bytes[0] = (char)(value >> 8);    // High byte
bytes[1] = (char)(value & 0xFF);  // Low byte  
bytes[2] = '\0';

// To reconstruct:
int16_t reconstructed = (bytes[0] << 8) | bytes[1];
Serial.print("reconstructed: "); Serial.println(reconstructed);
Serial.println((char)reconstructed);

int val1 = (unsigned char)str3[0]; 
Serial.println(val1);
 */
