  
#include <Adafruit_TinyUSB.h>
#include "ramdisk.h"
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include <TinyUSB_Mouse_and_Keyboard.h>
#include <TimeLib.h>

#include "tree.h"
#include "graphics.h"
#include "include.h"

// ---------------------------------------- 

void setup() { 
  usb_msc_enable(true);
  usb_msc.begin();  

  Serial.begin(115200);
  Serial.setTimeout(3000);
  Keyboard.begin();
  Keyboard.releaseAll(); 
  
  pinMode( BGL_PIN, OUTPUT_12MA );

  BGL_set(ON);
  GLCD_Init();

  // - - - - - - - - - - - - - - - - - 

  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    gpio_set_slew_rate( rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  setState(BOOTING);
  serial_timer = millis();

  while (!msc_ready) yield();
  while (!zero_booted) {
    if (Serial.available() || BOOTSEL) break;
    if ((millis()-T) > 1000) 
      GLCD_anim(), T = millis();
    //sysTick();
  }
  zero_booted = true;

  setState(BOOTED);
  setSyncProvider(requestSync);

  menu_init = tree::Init(&menuTree, menu_init);

  clearBuf();
  Home(true);
}
// ---------------------------------------------------------

void Home(bool init) {
  setState(HOME_ON);

  display.clearDisplay();

  display.drawBitmap(
    (display.width()-BMP_WIDTH)/2, 
    (display.height()-BMP_HEIGHT)/2, 
    home_bmp, 
    BMP_WIDTH, BMP_HEIGHT, 1
  );

  homeArtwork(data_stored);
  printTopBar("HOME");
  
  //if (data_stored)
  printHomeItems(2,15);
}

// ---------------------------------------------------------

int getIndex(const char* key) {
  for (int i=0; i<ArrLen(homeScreen); i++)
    if (strcmp(key, (const char*)homeScreen[i].name) == 0)
      return i;
  return -1;
}
// ---------------------------------------------------------

bool checkHeader(char** key) {
  char *val  = strchr(*key, ' ');
  int  index = -1, 
       items = ArrLen(homeScreen);

  if (val == NULL) return false;

  *val  = '\0'; val++;
  index = getIndex(*key);

  if (strcmp(*key, "epoch") == 0) {
    clock_set(val);
    return true;
  }
  else if (index >= 0 || index < items) {
    strcpy(homeScreen[index].content, val);
    return true;
  }

  return false;
}
// ---------------------------------------------------------

void loop() {
  bool stored, serial_busy;

  if (stdin_available) {
    if (await_response)
      Reader(stdin_buf),
      await_response = false;
    
    stdin_available = false;

    if (getState() == MENU_ON)
      Menu();
    else
      Home(true);
  }
  else if (Serial.available() > 0) { 
    buf_input[0] = '\0';
    serial_timer = millis();
    serial_busy  = true;

    while (serial_busy && ((millis()-serial_timer)<3000)) {
      if (Serial.available() > 0) {
        int n = Serial.readBytesUntil('\n', buf, sizeof(buf)-1); buf[n] = '\0';
        char *head = strstr(buf, "#HEAD ");
        char *eof  = strstr(buf, "#EOF");
        
        serial_timer = millis();

        if (head) {
          head = strchr(head,' '); head++;
          stored = checkHeader(&head);
          if (stored)
            data_stored = true;
        }
        else if (eof) {
          serial_busy = false;
        }
        else {
          if ((strlen(buf_input)+strlen(buf))+2 < sizeof(buf_input)-1)
            strcat(buf_input, buf),
            strcat(buf_input, "\n");
        }
      }
    }
    Serial_flush();
    
    if (await_response)
      Reader(buf_input),
      await_response = false;
    else {
      display.clearDisplay();
      for (int i=0; i<strlen(buf_input); i++)
        GLCD_overflow(56),
        display.write(buf_input[i]),
        display.display();
      delay(2000);
    }
    if (getState() == MENU_ON)
      Menu();
    else
      Home(true);
  }
  else {
    KeyMap *KP = readKeyPad();

    if (KP != NULL) { BGL_set(ON);
      if (getState() == MENU_ON) {
        tree::Navigate(KP->key);
      }
      else if (getState() == HOME_ON) {
        Menu();
      }
      else if (getState() == TXT_INPUT) {
        if (KP_T9_getChar(KP)) {
          display.cp437(true); 
          GLCD_print("> ",0,1);
          GLCD_decodeStr(buf_input);
          display.write(curSym);
          KP_showIcon(true);
        }
      }
    }
    else if (BOOTSEL) { kp_last_press = millis();
      while (BOOTSEL) 
        if ((millis()-kp_last_press) > 2000) 
          break;

      if ((millis()-kp_last_press) < 2000) {
        if (getState() == TXT_INPUT)
          sendCommand();
      }
    }
  }
}

// ---------------------------------------------------------
/*
void clock_blink() {
  display.setFont(&Picopixel);
  display.setCursor(clock_cur_pos, 6);
  display.setTextColor((second()%2)?1:0);
  display.write(':');
  display.display();
  display.setFont(NULL);
  display.setCursor(0,0);
  display.setTextColor(KS0108_ON); 
}

// ---------------------------------------------------------

void clock_tick(bool update) {
  clock_str  = "--:--";
  timeSynced = (timeStatus() == timeSet) ? true : false;

  if (timeStatus() != timeNotSet) {
    dateStr = sys_dateTimeStr({year(), month(), day()}, "-");
    timeStr = sys_dateTimeStr({hour(), minute(), second()}, ":");
    clock_str = timeStr.substring(0, timeStr.lastIndexOf(':'));

    if (update) {
      memset(homeScreen[0].content, '\0', 16);
      strncpy(homeScreen[0].content, dateStr.c_str(), 16);

      memset(homeScreen[1].content, '\0', 16);    
      strncpy(homeScreen[1].content, timeStr.c_str(), 16);
    }
  }
  if (update)
    clock_show(clock_str);
}
// ---------------------------------------------------------

void clock_show(String &str, int16_t &cur) {
  if (getState() == MENU_ON || getState() == HOME_ON) { 
    display.fillRect(111,1,display.width()-2, 7, 0);
    display.setFont(&Picopixel); 
    display.setCursor(109,6);

    for (int i=0; i<str.length(); i++) {
      if (str[i] == ':') cur = display.getCursorX();
      display.write((char)str[i]);
    }
    display.display();
    display.setFont(NULL); 
  }
}
// ---------------------------------------------------------

void checkHeader(String &str) {
  int  i, end, x = 0, n = 0;
  
  end = str.indexOf('\n');
  str = str.substring(str.indexOf(' ')+1, ((end<0)?str.length():end));

  if (str.indexOf(' ') < 0) return;
  if (str.substring(0, str.indexOf(' ')) == "HOME") {
    str = str.substring(str.indexOf(' ')+1, str.length());
    memset(homeScreen[0].content, '\0', 16);

    for (int i=0; i<str.length(); i++) {
      char c = str[i];
      homeScreen[n].content[x++] = c;  

      if (c == ' ' || i == (str.length()-1)) { 
        if (n < 7) {
          if (n == 0)
            clock_set(homeScreen[n].content), n++;
          if (i < (str.length()-1))
            memset(homeScreen[++n].content, '\0', 16);
          x = 0;
          continue;
        }
      }
    }
    data_stored = true;
  }  
}
// ---------------------------------------------------------

void sysTick() {
  if ((bgl_timeout > 0) && ((millis()-bgl_timer)>bgl_timeout))
    BGL_set(OFF);

  if (getState() != TXT_INPUT) {
    if (!(millis()%10))
      clock_tick();

    if ((millis()-clock_update) > 1000)
      clock_blink(),
      clock_update = millis();  
  }
}

// ---------------------------------------------------------

void printHomeItems(int16_t xPos, int16_t yPos) {
  display.setFont(&Picopixel); 
  display.cp437(true);

  display.fillRect(1, 10, 63, 53, 0);
  display.setCursor(xPos,yPos);

  for (int i=0; i<ArrLen(homeScreen); i++) {
    display.print(homeScreen[i].name);
    display.setCursor(21, yPos);
    display.print(homeScreen[i].content);
    display.print((i==3)?"%":((i==5)?"'C":""));
    
    if (i == 4) 
      display.drawPixel(xPos+33, 39, 1),
      display.drawPixel(xPos+31, 39, 1),
      display.drawPixel(xPos+32, 38, 1),
      display.drawPixel(xPos+32, 40, 1);

    display.println(); display.setCursor(xPos, yPos = display.getCursorY());
  }

  display.drawLine(19, 8, 19, display.height()-1, KS0108_ON);
  display.display();
  display.setCursor(0,0);
  display.setFont(NULL); 
}
// ---------------------------------------------------------

void homeArtwork(bool loaded = false) {
  int x = atoi(homeScreen[3].content);
  int16_t sunPos; 

  // clear art frame
  display.fillRect(64, 9, (display.width()/2)-1, 53, 0);

  if (loaded) {
    display.drawBitmap(
      (display.width()-BMP_HLF_WIDTH), 
      (display.height()-BMP_HLF_HEIGHT)/2,
      ((x < 100) ? sunset_empty_bmp_64 : nightsky_bmp_64),
      BMP_HLF_WIDTH, BMP_HLF_HEIGHT, 1
    );    
    if (x < 100) {
      sunPos = (x < 50) ? 24 : (x/2);
      display.fillCircle(display.width()-32, sunPos-5, 10, 0);
      display.drawCircle(display.width()-32, sunPos-5, 10, 1);
      display.fillRect((display.width()-BMP_FOOTER_WIDTH), (display.height()-BMP_FOOTER_HEIGHT), display.height()-1, display.width()-1, 0);
      display.drawBitmap((display.width()-BMP_FOOTER_WIDTH), (display.height()-BMP_FOOTER_HEIGHT), sunset_sea_bmp_64, BMP_FOOTER_WIDTH, BMP_FOOTER_HEIGHT, 1);    
    }
    else {
      display.fillRect((display.width()/2)+1, ((display.height()/2)-BMP_MOON_HEIGHT)+9, BMP_MOON_WIDTH, BMP_MOON_HEIGHT, 0);
      display.drawBitmap((display.width()/2)+1, ((display.height()/2)-BMP_MOON_HEIGHT)+9, moon_full_bmp, BMP_MOON_WIDTH, BMP_MOON_HEIGHT, 1);
      //display.fillRect((display.width()/2), (display.height()/2), BMP_MOON_WIDTH, BMP_MOON_HEIGHT, 0);
      //display.drawBitmap((display.width()/2), (display.height()/2), moon_full_bmp, BMP_MOON_WIDTH, BMP_MOON_HEIGHT, 1); 
    }
  }
  else {
    display.drawBitmap(
      (display.width()-BMP_HLF_WIDTH), 
      (display.height()-BMP_HLF_HEIGHT)/2,
      default_64,
      BMP_HLF_WIDTH, BMP_HLF_HEIGHT, 1
    );
  }

  display.drawLine(
    display.width()/2, 8, 
    display.width()/2, display.height()-1,
    KS0108_ON
  );

  display.display();
}
// ---------------------------------------------------------

void Home(bool init) {
  setState(HOME_ON);

  if (init)
    display.clearDisplay();

  display.drawBitmap(
    (display.width()-BMP_WIDTH)/2, 
    (display.height()-BMP_HEIGHT)/2, 
    home_bmp, 
    BMP_WIDTH, BMP_HEIGHT, 1
  );

  homeArtwork(data_stored);
  printTopBar("HOME");

  if (init)
    clock_tick();

  if (data_stored)
    printHomeItems(2,15);

  display.display();
  display.setCursor(0,0);
  display.setFont(NULL);
}

// ---------------------------------------------------------

void checkStreams() {
  int i,n = 0;

  if (Serial.available() > 0) {
    memset(buf_input, '\0', sizeof(buf_input));

    while (Serial.available() > 0) {
      buf = Serial.readStringUntil('\n');
      if (buf.startsWith("#HEAD ")) {
        checkHeader(buf);
        if (data_stored) {
          Serial_flush();
          Home(false);
          return;
        }
      }
      else {
        for (i=0; i<buf.length(); i++)
          buf_input[n++] = (char)buf[i];
        buf_input[n++] = '\n';
      }
    }
    Serial_flush();
    
    if (strlen(buf_input) > 0) {
      if (await_response) {
        Reader(buf_input);
        await_response = false;
        Menu();
      }
    }
  }
  else if (stdin_available) {
    if (await_response) {
      Reader(stdin_buf);
      await_response = false;
      Menu();
    }
    stdin_available = false;
  } 
}

// ---------------------------------------------------------

void loop() {
  sysTick();

  checkStreams();

  if (getState() == AWAIT_RESP) {
    if ((millis()-resp_timer) > RESP_TIMEOUT) {
      GLCD_msgBox("\n    RESPONSE\n    TIMEOUT\n", false); delay(2000);
      stdin_available = false;  
      await_response = false;
      Menu();
    }
    else 
      GLCD_anim();
  }
  else if (getState() == TXT_INPUT) {
    if (KP_checkInput()) {
      display.clearDisplay();
      KP_showIcon(false);
      
      display.setCursor(0,0);
      display.print("> ");

      GLCD_decodeStr(buf_input);

      display.write(curSym);
      display.display();
      BGL_set(ON);
    }
    if (BOOTSEL) {
      kp_last_press = millis();
      while (BOOTSEL) {
        if ((millis()-kp_last_press) > 2000) 
          break;
      }
      if ((millis()-kp_last_press) < 2000)
        sendCommand();
        //Menu();
    }
  }
  else {
    KeyMap *KP = readKeyPad();

    if (KP != NULL) { BGL_set(ON);
      if (getState() == MENU_ON) 
        tree::Navigate(KP->key);

      else if (getState() == HOME_ON)
        Menu();
    }
    //else { checkStreams(); }
  }
}

*/


//###################################################################

