  
#include <Adafruit_TinyUSB.h>
#include "ramdisk.h"
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include <TinyUSB_Mouse_and_Keyboard.h>
#include <TimeLib.h>

#include "tree.h"
#include "graphics.h"
#include "include.h"

// ---------------------------------------- 

void setup() { 
  usb_msc_enable(true);
  usb_msc.begin();  

  Serial.begin(115200);
  Serial.setTimeout(3000);
  Keyboard.begin();
  Keyboard.releaseAll(); 
  
  pinMode( BGL_PIN, OUTPUT_12MA );

  GLCD_Init();

  // - - - - - - - - - - - - - - - - - 

  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i],      OUTPUT ),
    digitalWrite( rowPins[i], HIGH   ),
    
    gpio_set_slew_rate( rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  setState(BOOTING);
  serial_timer = millis();

  while (!msc_ready) yield();
  while (!zero_booted) {
    if (Serial.available() || BOOTSEL) break;
    if ((millis()-T) > 1000) 
      GLCD_anim(), T = millis();
  }
  zero_booted = true;

  setState(BOOTED);
  setSyncProvider(requestSync);

  menu_init = tree::Init(&menuTree, menu_init);

  clearBuf();
  Home(true);
}
// ---------------------------------------------------------

void Home(bool init) {
  setState(HOME_ON);

  display.clearDisplay();

  display.drawBitmap(
    (display.width()-BMP_WIDTH)/2, 
    (display.height()-BMP_HEIGHT)/2, 
    home_bmp, 
    BMP_WIDTH, BMP_HEIGHT, 1
  );

  homeArtwork(data_stored);
  printTopBar("HOME");
  printHomeItems(2,15);
  BGL_set(ON);
}

// ---------------------------------------------------------

int getIndex(const char* key) {
  for (int i=0; i<ArrLen(homeScreen); i++)
    if (strcmp(key, (const char*)homeScreen[i].name) == 0)
      return i;
  return -1;
}
// ---------------------------------------------------------

bool checkHeader(char** key) {
  char *val  = strchr(*key, ' ');
  int  index = -1, 
       items = ArrLen(homeScreen);

  if (val == NULL) return false;

  *val  = '\0'; val++;
  index = getIndex(*key);

  if (strcmp(*key, "epoch") == 0) {
    clock_set(val);
    return true;
  }
  else if (strcmp(*key, "unread") == 0) {
    strcpy(sysData[0].content, val);
    return true;
  }
  else if (index >= 0 || index < items) {
    if (strcmp(*key, "moon") == 0) {
      char *sep = strchr(val,' ');
      if (sep) {
        *sep = '\0'; sep++;
        setMoonDay( sep);
      }
    }
    strcpy(homeScreen[index].content, val);
    return true;
  }

  return false;
}
// ---------------------------------------------------------

void loop() {
  bool stored, serial_busy;
  char header[32];

  if (stdin_available) {
    if (await_response)
      Reader(stdin_buf),
      await_response = false;
    
    stdin_available = false;

    if (getState() == MENU_ON)
      Menu();
    else
      Home(true);
  }
  else if (Serial.available() > 0) { 
    buf_input[0] = '\0';
    header[0] = '\0';
    serial_timer = millis();
    serial_busy  = true;
    
    //await_response = true; // REM

    while (serial_busy && ((millis()-serial_timer)<3000)) {
      if (Serial.available() > 0) {
        int n = Serial.readBytesUntil('\n', buf, sizeof(buf)-1); buf[n] = '\0';

        char *forc = strstr(buf, "#FORCE");
        char *head = strstr(buf, "#HEAD ");
        char *eof  = strstr(buf, "#EOF");

        serial_timer = millis();

        if (head) {
          head = strchr(head,' '); head++;
          strcpy(header, head);
          stored = checkHeader(&head);

          if (stored)
            data_stored = true;
        }
        else if (eof) {
          serial_busy = false;
        }
        else if (forc) {
          await_response = true;
        }
          else {
          if ((strlen(buf_input)+strlen(buf))+2 < sizeof(buf_input)-1)
            strcat(buf_input, buf),
            strcat(buf_input, "\n");
        }
      }
    }
    Serial_flush();
    
    if (await_response) 
      Reader(buf_input),
      await_response = false;

    if (getState() == MENU_ON)
      Menu();
    else if (getState() == HOME_ON)
      Home(true);
  }
  else {
    KeyMap *KP = readKeyPad();

    if (KP != NULL) { BGL_set(ON);
      if (getState() == MENU_ON) {
        tree::Navigate(KP->key);
      }
      else if (getState() == HOME_ON) {
        Menu();
      }
      else if (getState() == TXT_INPUT) {
        if (KP_T9_getChar(KP)) {
          display.cp437(true); 
          GLCD_print("> ",0,1);
          GLCD_decodeStr(buf_input);
          display.write(curSym);
          KP_showIcon(true);
          Serial.println("buf_input:");
          Serial.println(buf_input);
        }
      }
    }
    else if (BOOTSEL) { kp_last_press = millis();
      while (BOOTSEL) 
        if ((millis()-kp_last_press) > 2000) 
          break;

      if ((millis()-kp_last_press) < 2000) {
        if (getState() == TXT_INPUT)
          sendCommand();
        else
        if (getState() == AWAIT_RESP) {
          stdin_available = false;  
          await_response = false;
          Menu();
        }
      }
    }
    else if (getState() == AWAIT_RESP) {
      if ((millis()-resp_timer) > RESP_TIMEOUT) {
        GLCD_msgBox("\n    RESPONSE\n    TIMEOUT\n", false); delay(2000);
        stdin_available = false;  
        await_response = false;
        Menu();
      }
      else 
        GLCD_anim();
    }
  }
  sysTick();
}


//###################################################################

